/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.api;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.ShutdownManager;
import com.zutubi.pulse.Version;
import com.zutubi.pulse.agent.Agent;
import com.zutubi.pulse.agent.AgentManager;
import com.zutubi.pulse.agent.SlaveAgent;
import com.zutubi.pulse.api.AuthenticationException;
import com.zutubi.pulse.api.TokenManager;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.committransformers.CommitMessageTransformerManager;
import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.system.SystemStartedEvent;
import com.zutubi.pulse.form.squeezer.SqueezeException;
import com.zutubi.pulse.form.squeezer.Squeezers;
import com.zutubi.pulse.form.squeezer.TypeSqueezer;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.model.AntPulseFileDetails;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.CommitMessageTransformer;
import com.zutubi.pulse.model.CustomPulseFileDetails;
import com.zutubi.pulse.model.Cvs;
import com.zutubi.pulse.model.ExecutablePulseFileDetails;
import com.zutubi.pulse.model.MakePulseFileDetails;
import com.zutubi.pulse.model.Maven2PulseFileDetails;
import com.zutubi.pulse.model.MavenPulseFileDetails;
import com.zutubi.pulse.model.NamedEntity;
import com.zutubi.pulse.model.P4;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.model.RemoteTriggerBuildReason;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.Svn;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.model.VersionedPulseFileDetails;
import com.zutubi.pulse.model.XCodePulseFileDetails;
import com.zutubi.pulse.util.OgnlUtils;
import com.zutubi.pulse.util.TimeStamps;
import com.zutubi.pulse.validation.PulseValidationContext;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.ValidationException;
import com.zutubi.validation.ValidationManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import ognl.Ognl;
import ognl.OgnlException;
import org.acegisecurity.AuthenticationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteApi
implements EventListener {
    private TokenManager tokenManager;
    private ShutdownManager shutdownManager;
    private BuildManager buildManager;
    private ProjectManager projectManager;
    private UserManager userManager;
    private AgentManager agentManager;
    private AuthenticationManager authenticationManager;
    private EventManager eventManager;
    private ValidationManager validationManager;
    private static final Map<Class, String[]> structDefs = new HashMap<Class, String[]>();
    private CommitMessageTransformerManager transformerManager;

    public RemoteApi() {
        structDefs.put(Project.class, new String[]{"name", "description", "url"});
        structDefs.put(Cvs.class, new String[]{"root", "module", "password", "branch", "quietPeriod", "monitor", "pollingInterval"});
        structDefs.put(Svn.class, new String[]{"url", "username", "password", "keyfile", "passphrase", "monitor", "pollingInterval"});
        structDefs.put(P4.class, new String[]{"port", "user", "password", "client", "monitor", "pollingInterval"});
        structDefs.put(AntPulseFileDetails.class, new String[]{"buildFile", "targets", "arguments", "workingDir"});
        structDefs.put(ExecutablePulseFileDetails.class, new String[]{"executable", "arguments", "workingDir"});
        structDefs.put(MavenPulseFileDetails.class, new String[]{"targets", "workingDir", "arguments"});
        structDefs.put(Maven2PulseFileDetails.class, new String[]{"goals", "workingDir", "arguments"});
        structDefs.put(MakePulseFileDetails.class, new String[]{"makefile", "targets", "arguments", "workingDir"});
        structDefs.put(XCodePulseFileDetails.class, new String[]{"workingDir", "project", "config", "target", "action", "settings"});
        structDefs.put(CustomPulseFileDetails.class, new String[]{"pulseFile"});
        structDefs.put(VersionedPulseFileDetails.class, new String[]{"pulseFileName"});
        ComponentContext.autowire((Object)this);
    }

    public int getVersion() {
        Version v = Version.getVersion();
        return v.getBuildNumberAsInt();
    }

    public String login(String username, String password) throws AuthenticationException {
        return this.tokenManager.login(username, password);
    }

    public boolean logout(String token) {
        return this.tokenManager.logout(token);
    }

    public String ping() {
        return "pong";
    }

    public Vector<String> getAllUserLogins(String token) throws AuthenticationException {
        this.tokenManager.verifyAdmin(token);
        List<User> users = this.userManager.getAllUsers();
        Vector<String> result = new Vector<String>(users.size());
        for (User user : users) {
            result.add(user.getLogin());
        }
        return result;
    }

    public Vector<String> getAllProjectNames(String token) throws AuthenticationException {
        this.tokenManager.verifyUser(token);
        List<Project> projects = this.projectManager.getAllProjects();
        return this.getNames(projects);
    }

    public Vector<String> getAllProjectGroups(String token) throws AuthenticationException {
        this.tokenManager.verifyUser(token);
        List<ProjectGroup> groups = this.projectManager.getAllProjectGroups();
        Vector<String> result = new Vector<String>(groups.size());
        for (ProjectGroup g : groups) {
            result.add(g.getName());
        }
        return result;
    }

    public Hashtable<String, Object> getProjectGroup(String token, String name) throws AuthenticationException, IllegalArgumentException {
        this.tokenManager.verifyUser(token);
        ProjectGroup group = this.projectManager.getProjectGroup(name);
        if (group == null) {
            throw new IllegalArgumentException(String.format("Unknown project group: '%s'", name));
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("name", group.getName());
        result.put("projects", this.getNames(group.getProjects()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createProjectGroup(String token, String name, Vector<String> projects) throws AuthenticationException, IllegalArgumentException {
        this.tokenManager.verifyAdmin(token);
        if (!TextUtils.stringSet((String)name)) {
            throw new IllegalArgumentException("Name is required");
        }
        if (this.projectManager.getProjectGroup(name) != null) {
            throw new IllegalArgumentException(String.format("A project group with name '%s' already exists", name));
        }
        List<Project> members = this.getProjectList(projects);
        ProjectGroup group = new ProjectGroup(name);
        group.setProjects(members);
        try {
            this.tokenManager.loginUser(token);
            this.projectManager.save(group);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editProjectGroup(String token, String name, String newName, Vector<String> projects) throws AuthenticationException, IllegalArgumentException {
        this.tokenManager.verifyAdmin(token);
        ProjectGroup group = this.projectManager.getProjectGroup(name);
        if (group == null) {
            throw new IllegalArgumentException(String.format("Unknown project group '%s'", name));
        }
        if (!TextUtils.stringSet((String)newName)) {
            throw new IllegalArgumentException("Name is required");
        }
        if (!newName.equals(name) && this.projectManager.getProjectGroup(newName) != null) {
            throw new IllegalArgumentException(String.format("A project group with name '%s' already exists", newName));
        }
        group.setName(newName);
        List<Project> members = this.getProjectList(projects);
        group.setProjects(members);
        try {
            this.tokenManager.loginUser(token);
            this.projectManager.save(group);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    public boolean deleteProjectGroup(String token, String name) throws AuthenticationException {
        this.tokenManager.verifyAdmin(token);
        ProjectGroup group = this.projectManager.getProjectGroup(name);
        if (group == null) {
            return false;
        }
        this.projectManager.delete(group);
        return true;
    }

    public Vector<String> getMyProjectNames(String token) throws AuthenticationException {
        User user = this.tokenManager.verifyUser(token);
        LinkedList<Project> projects = new LinkedList<Project>();
        if (user != null) {
            projects.addAll(this.userManager.getUserProjects(user, this.projectManager));
        }
        return this.getNames(projects);
    }

    public Vector<Hashtable<String, Object>> getBuild(String token, String projectName, int id) throws AuthenticationException {
        Vector<Hashtable<String, Object>> result = new Vector<Hashtable<String, Object>>(1);
        this.tokenManager.verifyUser(token);
        Project project = this.internalGetProject(projectName);
        BuildResult build = this.buildManager.getByProjectAndNumber(project, id);
        if (build == null) {
            return result;
        }
        result.add(this.convertResult(build));
        return result;
    }

    public Vector<Hashtable<String, Object>> getLatestBuildsForProject(String token, String projectName, String buildSpecification, boolean completedOnly, int maxResults) throws AuthenticationException {
        this.tokenManager.verifyUser(token);
        Project project = this.internalGetProject(projectName);
        PersistentName[] specs = null;
        if (TextUtils.stringSet((String)buildSpecification)) {
            BuildSpecification spec = this.getBuildSpecification(project, buildSpecification);
            specs = new PersistentName[]{spec.getPname()};
        }
        ResultState[] states = null;
        if (completedOnly) {
            states = ResultState.getCompletedStates();
        }
        List<BuildResult> builds = this.buildManager.queryBuilds(new Project[]{project}, states, specs, -1L, -1L, null, 0, maxResults, true);
        Vector<Hashtable<String, Object>> result = new Vector<Hashtable<String, Object>>(builds.size());
        for (BuildResult build : builds) {
            Hashtable<String, Object> buildDetails = this.convertResult(build);
            result.add(buildDetails);
        }
        return result;
    }

    public Vector<Hashtable<String, Object>> getLatestBuildForProject(String token, String projectName, String buildSpecification, boolean completedOnly) throws AuthenticationException {
        return this.getLatestBuildsForProject(token, projectName, buildSpecification, completedOnly, 1);
    }

    public Vector<Hashtable<String, Object>> getPersonalBuild(String token, int id) throws AuthenticationException {
        Vector<Hashtable<String, Object>> result = new Vector<Hashtable<String, Object>>(1);
        User user = this.tokenManager.verifyUser(token);
        BuildResult build = this.buildManager.getByUserAndNumber(user, id);
        if (build == null) {
            return result;
        }
        result.add(this.convertResult(build));
        return result;
    }

    public Vector<Hashtable<String, Object>> getLatestPersonalBuilds(String token, boolean completedOnly, int maxResults) throws AuthenticationException {
        User user = this.tokenManager.verifyUser(token);
        List<BuildResult> builds = this.buildManager.getPersonalBuilds(user);
        if (completedOnly) {
            Iterator<BuildResult> it = builds.iterator();
            while (it.hasNext()) {
                BuildResult b = it.next();
                if (b.completed()) continue;
                it.remove();
            }
        }
        if (maxResults >= 0 && builds.size() > maxResults) {
            builds = builds.subList(0, maxResults);
        }
        Vector<Hashtable<String, Object>> result = new Vector<Hashtable<String, Object>>(builds.size());
        for (BuildResult build : builds) {
            Hashtable<String, Object> buildDetails = this.convertResult(build);
            result.add(buildDetails);
        }
        return result;
    }

    public Vector<Hashtable<String, Object>> getLatestPersonalBuild(String token, boolean completedOnly) throws AuthenticationException {
        return this.getLatestPersonalBuilds(token, completedOnly, 1);
    }

    private Hashtable<String, Object> convertResult(BuildResult build) {
        Hashtable<String, Object> buildDetails = new Hashtable<String, Object>();
        buildDetails.put("id", (int)build.getNumber());
        buildDetails.put("project", build.getProject().getName());
        buildDetails.put("specification", build.getBuildSpecification());
        buildDetails.put("status", build.getState().getPrettyString());
        buildDetails.put("completed", build.completed());
        buildDetails.put("succeeded", build.succeeded());
        TimeStamps timeStamps = build.getStamps();
        buildDetails.put("startTime", new Date(timeStamps.getStartTime()));
        buildDetails.put("endTime", new Date(timeStamps.getEndTime()));
        if (timeStamps.hasEstimatedTimeRemaining()) {
            buildDetails.put("progress", timeStamps.getEstimatedPercentComplete());
        } else {
            buildDetails.put("progress", -1);
        }
        return buildDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerBuild(String token, String projectName, String buildSpecification) throws AuthenticationException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.internalGetProject(projectName);
            this.getBuildSpecification(project, buildSpecification);
            this.projectManager.triggerBuild(project, buildSpecification, new RemoteTriggerBuildReason(), null, true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    public Vector<String> getProjectBuildSpecifications(String token, String projectName) throws AuthenticationException {
        this.tokenManager.verifyUser(token);
        Project project = this.internalGetProject(projectName);
        return this.getNames(project.getBuildSpecifications());
    }

    public String getProjectState(String token, String projectName) throws AuthenticationException {
        this.tokenManager.verifyUser(token);
        Project project = this.internalGetProject(projectName);
        return project.getState().toString().toLowerCase();
    }

    public Hashtable<String, String> preparePersonalBuild(String token, String projectName, String buildSpecification) throws AuthenticationException {
        this.tokenManager.verifyRoleIn(token, "ROLE_PERSONAL");
        Project project = this.internalGetProject(projectName);
        this.getBuildSpecification(project, buildSpecification);
        Hashtable<String, String> scmDetails = new Hashtable<String, String>();
        scmDetails.put("type", project.getScm().getType());
        scmDetails.putAll(project.getScm().getRepositoryProperties());
        return scmDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseProject(String token, String projectName) throws AuthenticationException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.internalGetProject(projectName);
            if (project.isPaused()) {
                boolean bl = false;
                return bl;
            }
            this.projectManager.pauseProject(project);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeProject(String token, String projectName) throws AuthenticationException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.internalGetProject(projectName);
            if (project.isPaused()) {
                this.projectManager.resumeProject(project);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    public boolean createAgent(String token, String name, String host, int port) throws AuthenticationException, LicenseException {
        this.tokenManager.verifyAdmin(token);
        LicenseHolder.ensureAuthorization("canAddAgent");
        Slave newSlave = new Slave(name, host, port);
        this.validate((Object)newSlave);
        if (!TextUtils.stringSet((String)name) || this.agentManager.agentExists(name)) {
            throw new IllegalArgumentException(String.format("An agent by the name '%s' already exists. Please select a different name.", name));
        }
        this.agentManager.addSlave(new Slave(name, host, port));
        return true;
    }

    public String getAgentStatus(String token, String name) throws AuthenticationException {
        this.tokenManager.verifyUser(token);
        Agent agent = this.agentManager.getAgent(name);
        if (agent == null) {
            return "";
        }
        return agent.getStatus().getPrettyString();
    }

    public boolean enableAgent(String token, String name) throws AuthenticationException {
        this.tokenManager.verifyAdmin(token);
        Agent agent = this.agentManager.getAgent(name);
        if (agent == null) {
            throw new IllegalArgumentException("Unknown agent '" + name + "'");
        }
        if (agent.isSlave()) {
            this.agentManager.enableSlave(((SlaveAgent)agent).getSlave());
        } else {
            this.agentManager.enableMasterAgent();
        }
        return true;
    }

    public boolean disableAgent(String token, String name) throws AuthenticationException {
        this.tokenManager.verifyAdmin(token);
        Agent agent = this.agentManager.getAgent(name);
        if (agent == null) {
            throw new IllegalArgumentException("Unknown agent '" + name + "'");
        }
        if (agent.isSlave()) {
            this.agentManager.disableSlave(((SlaveAgent)agent).getSlave());
        } else {
            this.agentManager.disableMasterAgent();
        }
        return true;
    }

    public boolean shutdown(String token, boolean force, boolean exitJvm) throws AuthenticationException {
        this.tokenManager.verifyAdmin(token);
        this.shutdownManager.delayedShutdown(force, exitJvm);
        return true;
    }

    public boolean stopService(String token) throws AuthenticationException {
        this.tokenManager.verifyAdmin(token);
        this.shutdownManager.delayedStop();
        return true;
    }

    public boolean setPassword(String token, String login, String password) throws AuthenticationException {
        this.tokenManager.verifyAdmin(token);
        User user = this.userManager.getUser(login);
        if (user == null) {
            throw new IllegalArgumentException(String.format("Unknown username '%s'", login));
        }
        this.userManager.setPassword(user, password);
        this.userManager.save(user);
        return true;
    }

    public boolean createUser(String token, Hashtable<String, Object> user) throws AuthenticationException, LicenseException {
        this.tokenManager.verifyAdmin(token);
        LicenseHolder.ensureAuthorization("canAddUser");
        String login = (String)user.get("login");
        User existingUser = this.userManager.getUser(login);
        if (existingUser != null) {
            throw new IllegalArgumentException(String.format("A user with the login '%s' already exists. Please select a different login.", login));
        }
        User instance = new User();
        instance.setLogin(login);
        instance.setName((String)user.get("name"));
        this.userManager.addUser(instance, false, false);
        return true;
    }

    public boolean deleteUser(String token, String login) throws AuthenticationException, IllegalArgumentException {
        this.tokenManager.verifyAdmin(token);
        User user = this.userManager.getUser(login);
        if (user == null) {
            throw new IllegalArgumentException(String.format("Unknown user login: '%s'", login));
        }
        this.userManager.delete(user);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createProject(String token, Hashtable<String, Object> project, Hashtable<String, Object> scm, Hashtable<String, Object> type) throws AuthenticationException, LicenseException, IllegalArgumentException {
        try {
            this.tokenManager.loginUser(token);
            String name = (String)project.get("name");
            Project existingProject = this.projectManager.getProject(name);
            if (existingProject != null) {
                throw new IllegalArgumentException(String.format("A project with the name '%s' already exists. Please use a different name.", name));
            }
            Project newProject = new Project();
            this.setProperties(project, (Object)newProject);
            this.validate((Object)newProject);
            Scm newScm = this.createScm(scm);
            this.validate(newScm);
            newProject.setScm(newScm);
            PulseFileDetails newType = this.createFileDetails(type);
            this.validate((Object)newType);
            newProject.setPulseFileDetails(newType);
            this.projectManager.create(newProject);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteProject(String token, String name) throws AuthenticationException, IllegalArgumentException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.projectManager.getProject(name);
            if (project == null) {
                throw new IllegalArgumentException(String.format("Unknown project name: '%s'", name));
            }
            this.projectManager.delete(project);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editProject(String token, String name, Hashtable<String, Object> projectDetails) throws AuthenticationException, IllegalArgumentException {
        try {
            String newName;
            this.tokenManager.loginUser(token);
            Project project = this.projectManager.getProject(name);
            if (project == null) {
                throw new IllegalArgumentException(String.format("Unknown project name: '%s'", name));
            }
            if (projectDetails.containsKey("name") && !name.equals(newName = (String)projectDetails.get("name")) && this.projectManager.getProject(newName) != null) {
                throw new IllegalArgumentException(String.format("The name '%s' is already in use by another project. Please select a different name.", newName));
            }
            this.setProperties(projectDetails, (Object)project);
            this.validate((Object)project);
            this.projectManager.save(project);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Object> getProject(String token, String name) throws IllegalArgumentException, AuthenticationException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.projectManager.getProject(name);
            if (project == null) {
                throw new IllegalArgumentException(String.format("Unknown project name: '%s'", name));
            }
            Hashtable<String, Object> details = this.extractDetails((Object)project);
            details.put("scm", project.getScm().getType());
            details.put("type", project.getPulseFileDetails().getType());
            Hashtable<String, Object> hashtable = details;
            return hashtable;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Object> cloneProject(String token, String name, String cloneName, String cloneDescription) throws IllegalArgumentException, AuthenticationException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.projectManager.getProject(name);
            if (project == null) {
                throw new IllegalArgumentException(String.format("Unknown project name: '%s'", name));
            }
            if (this.projectManager.getProject(cloneName) != null) {
                throw new IllegalArgumentException(String.format("The name '%s' is already in use by another project. Please select a different name.", name));
            }
            Project clone = this.projectManager.cloneProject(project, cloneName, cloneDescription);
            Hashtable<String, Object> details = this.extractDetails((Object)clone);
            details.put("scm", clone.getScm().getType());
            details.put("type", clone.getPulseFileDetails().getType());
            Hashtable<String, Object> hashtable = details;
            return hashtable;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Object> getScm(String token, String projectName) throws AuthenticationException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.projectManager.getProject(projectName);
            if (project == null) {
                throw new IllegalArgumentException(String.format("Unknown project name: '%s'", projectName));
            }
            Hashtable<String, Object> hashtable = this.extractDetails(project.getScm());
            return hashtable;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editScm(String token, String name, Hashtable<String, Object> scmDetails) throws AuthenticationException, IllegalArgumentException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.projectManager.getProject(name);
            if (project == null) {
                throw new IllegalArgumentException(String.format("Unknown project name: '%s'", name));
            }
            this.setProperties(scmDetails, project.getScm());
            this.validate(project.getScm());
            this.projectManager.save(project);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Object> getProjectType(String token, String name) throws AuthenticationException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.projectManager.getProject(name);
            if (project == null) {
                throw new IllegalArgumentException(String.format("Unknown project name: '%s'", name));
            }
            Hashtable<String, Object> hashtable = this.extractDetails((Object)project.getPulseFileDetails());
            return hashtable;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editProjectType(String token, String name, Hashtable<String, Object> specifics) throws AuthenticationException, IllegalArgumentException {
        try {
            this.tokenManager.loginUser(token);
            Project project = this.projectManager.getProject(name);
            if (project == null) {
                throw new IllegalArgumentException(String.format("Unknown project name: '%s'", name));
            }
            this.setProperties(specifics, (Object)project.getPulseFileDetails());
            this.validate((Object)project.getPulseFileDetails());
            this.projectManager.save(project);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tokenManager.logoutUser();
        }
    }

    public int deleteAllCommitMessageLinks(String token) throws AuthenticationException {
        this.tokenManager.verifyAdmin(token);
        List<CommitMessageTransformer> transformers = this.transformerManager.getCommitMessageTransformers();
        int result = transformers.size();
        for (CommitMessageTransformer t : transformers) {
            this.transformerManager.delete(t);
        }
        return result;
    }

    private <T extends NamedEntity> Vector<String> getNames(Collection<T> entities) {
        Vector<String> result = new Vector<String>(entities.size());
        for (NamedEntity t : entities) {
            result.add(t.getName());
        }
        return result;
    }

    private Hashtable<String, Object> extractDetails(Object obj) {
        if (!structDefs.containsKey(obj.getClass())) {
            throw new RuntimeException(String.format("Object of type '%s' is not supported by the remote interface.", obj.getClass().getName()));
        }
        Hashtable<String, Object> details = new Hashtable<String, Object>();
        for (String property : structDefs.get(obj.getClass())) {
            try {
                Object value = Ognl.getValue((String)property, (Object)obj);
                if (value == null) continue;
                TypeSqueezer squeezer = Squeezers.findSqueezer(value.getClass());
                details.put(property, squeezer.squeeze(value));
            }
            catch (OgnlException e) {
                e.printStackTrace();
            }
            catch (SqueezeException e) {
                e.printStackTrace();
            }
        }
        return details;
    }

    private void validate(Object o) throws IllegalArgumentException {
        PulseValidationContext ctx = new PulseValidationContext(o);
        try {
            this.validationManager.validate(o, (ValidationContext)ctx);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (ctx.hasErrors()) {
            if (ctx.hasFieldErrors()) {
                String field = (String)ctx.getFieldErrors().keySet().iterator().next();
                String message = (String)ctx.getFieldErrors(field).iterator().next();
                throw new IllegalArgumentException(String.format("Field %s is invalid. Reason: %s", field, message));
            }
            if (ctx.hasActionErrors()) {
                String message = (String)ctx.getActionErrors().iterator().next();
                throw new IllegalArgumentException(String.format("The following error occured validating your request: %s", message));
            }
        }
    }

    private PulseFileDetails createFileDetails(Hashtable<String, Object> type) throws IllegalArgumentException {
        PulseFileDetails details;
        String projectType = (String)type.remove("type");
        if ("ant".equals(projectType)) {
            details = new AntPulseFileDetails();
        } else if ("executable".equals(projectType)) {
            details = new ExecutablePulseFileDetails();
        } else if ("maven".equals(projectType)) {
            details = new MavenPulseFileDetails();
        } else if ("maven2".equals(projectType)) {
            details = new Maven2PulseFileDetails();
        } else if ("xcode".equals(projectType)) {
            details = new XCodePulseFileDetails();
        } else if ("custom".equals(projectType)) {
            details = new CustomPulseFileDetails();
        } else if ("versioned".equals(projectType)) {
            details = new VersionedPulseFileDetails();
        } else {
            throw new IllegalArgumentException("Unknown project type: " + type);
        }
        this.setProperties(type, (Object)details);
        return details;
    }

    private Scm createScm(Hashtable<String, Object> details) throws IllegalArgumentException {
        Cvs scm;
        String type = (String)details.remove("type");
        if ("cvs".equals(type)) {
            scm = new Cvs();
        } else if ("svn".equals(type)) {
            scm = new Svn();
        } else if ("perforce".equals(type)) {
            scm = new P4();
        } else {
            throw new IllegalArgumentException("Unknown scm type: " + type);
        }
        this.setProperties(details, scm);
        return scm;
    }

    private void setProperties(Hashtable<String, Object> scmDetails, Object object) {
        OgnlUtils.setProperties(scmDetails, (Object)object);
    }

    private Project internalGetProject(String projectName) {
        Project project = this.projectManager.getProject(projectName);
        if (project == null) {
            throw new IllegalArgumentException("Unknown project '" + projectName + "'");
        }
        return project;
    }

    private List<Project> getProjectList(Vector<String> projects) {
        ArrayList<Project> members = new ArrayList<Project>(projects.size());
        for (String s : projects) {
            members.add(this.internalGetProject(s));
        }
        return members;
    }

    private BuildSpecification getBuildSpecification(Project project, String buildSpecification) {
        BuildSpecification spec = TextUtils.stringSet((String)buildSpecification) ? project.getBuildSpecification(buildSpecification) : project.getDefaultSpecification();
        if (spec == null) {
            throw new IllegalArgumentException("Unknown build specification '" + buildSpecification + "'");
        }
        return spec;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setShutdownManager(ShutdownManager shutdownManager) {
        this.shutdownManager = shutdownManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setValidationManager(ValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    public void setCommitMessageTransformerManager(CommitMessageTransformerManager manager) {
        this.transformerManager = manager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        eventManager.register((EventListener)this);
    }

    public void handleEvent(Event evt) {
        ComponentContext.autowire((Object)this);
        this.eventManager.unregister((EventListener)this);
    }

    public Class[] getHandledEvents() {
        return new Class[]{SystemStartedEvent.class};
    }
}

