/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.api;

import com.zutubi.pulse.api.AdminTokenManager;
import com.zutubi.pulse.api.AuthenticationException;
import com.zutubi.pulse.api.TokenManager;
import com.zutubi.pulse.model.AcegiUser;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.security.AcegiUtils;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class DefaultTokenManager
implements TokenManager {
    private int loginCount = 0;
    private Set<String> validTokens = new TreeSet<String>();
    private UserManager userManager;
    private AuthenticationManager authenticationManager;
    private AdminTokenManager adminTokenManager;

    public synchronized String login(String username, String password) throws AuthenticationException {
        return this.login(username, password, 1800000L);
    }

    public void init() {
    }

    public synchronized String login(String username, String password, long expiry) throws AuthenticationException {
        this.checkTokenAccessEnabled();
        if (++this.loginCount % 1000 == 0) {
            this.checkForExpiredTokens();
        }
        try {
            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
            this.logoutUser();
            long expiryTime = System.currentTimeMillis() + expiry;
            String signatureValue = this.getTokenSignature(username, expiryTime, password);
            String tokenValue = username + ":" + expiryTime + ":" + signatureValue;
            String encoded = new String(Base64.encodeBase64((byte[])tokenValue.getBytes()));
            this.validTokens.add(encoded);
            return encoded;
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
    }

    public synchronized boolean logout(String token) {
        try {
            this.verifyToken(token);
        }
        catch (AuthenticationException e) {
            return false;
        }
        this.validTokens.remove(token);
        return true;
    }

    public User verifyAdmin(String token) throws AuthenticationException {
        return this.verifyRoleIn(token, "ROLE_ADMINISTRATOR");
    }

    public User verifyUser(String token) throws AuthenticationException {
        return this.verifyRoleIn(token, "ROLE_USER");
    }

    public User verifyRoleIn(String token, String ... allowedAuthorities) throws AuthenticationException {
        if (this.checkAdminToken(token)) {
            return null;
        }
        User user = this.verifyToken(token);
        AcegiUser principle = this.userManager.getPrinciple(user);
        for (GrantedAuthority authority : principle.getAuthorities()) {
            for (String allowedAuthority : allowedAuthorities) {
                if (!authority.getAuthority().equals(allowedAuthority)) continue;
                return user;
            }
        }
        throw new AuthenticationException("Access denied");
    }

    private boolean checkAdminToken(String token) {
        return this.adminTokenManager != null && this.adminTokenManager.checkAdminToken(token);
    }

    public void loginUser(String token) throws AuthenticationException {
        User user = this.verifyToken(token);
        AcegiUser principle = this.userManager.getPrinciple(user);
        AcegiUtils.loginAs(principle);
    }

    public void logoutUser() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    private synchronized User verifyToken(String token) throws AuthenticationException {
        String username;
        this.checkTokenAccessEnabled();
        if (!this.validTokens.contains(token)) {
            throw new AuthenticationException("Invalid token");
        }
        try {
            username = this.verifyExpiry(token);
        }
        catch (AuthenticationException e) {
            this.validTokens.remove(token);
            throw e;
        }
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new AuthenticationException("Unknown user");
        }
        return user;
    }

    private synchronized void checkForExpiredTokens() {
        LinkedList<String> expiredTokens = new LinkedList<String>();
        for (String token : this.validTokens) {
            try {
                this.verifyExpiry(token);
            }
            catch (AuthenticationException e) {
                expiredTokens.add(token);
            }
        }
        for (String token : expiredTokens) {
            this.validTokens.remove(token);
        }
    }

    private String verifyExpiry(String token) throws AuthenticationException {
        String decoded = new String(Base64.decodeBase64((byte[])token.getBytes()));
        String[] parts = decoded.split(":");
        long expiry = Long.parseLong(parts[1]);
        if (System.currentTimeMillis() > expiry) {
            throw new AuthenticationException("Token expired");
        }
        return parts[0];
    }

    private String getTokenSignature(String username, long expiryTime, String password) {
        return DigestUtils.md5Hex((String)(username + ":" + expiryTime + ":" + password));
    }

    private void checkTokenAccessEnabled() throws AuthenticationException {
        if (this.userManager == null) {
            throw new AuthenticationException("Token based login disabled.");
        }
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAdminTokenManager(AdminTokenManager adminTokenManager) {
        this.adminTokenManager = adminTokenManager;
    }
}

