/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.agent;

import com.zutubi.pulse.BuildService;
import com.zutubi.pulse.SystemInfo;
import com.zutubi.pulse.Version;
import com.zutubi.pulse.agent.Agent;
import com.zutubi.pulse.agent.Status;
import com.zutubi.pulse.logging.CustomLogRecord;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.services.SlaveService;
import com.zutubi.pulse.services.SlaveStatus;
import com.zutubi.pulse.services.UpgradeState;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveAgent
implements Agent {
    private final int masterBuildNumber = Version.getVersion().getBuildNumberAsInt();
    private Slave slave;
    private Status status;
    private long lastPingTime = 0L;
    private SlaveService slaveService;
    private ServiceTokenManager serviceTokenManager;
    private BuildService buildService;
    private String pingError = null;
    private UpgradeState upgradeState = UpgradeState.NONE;
    private int upgradeProgress = -1;
    private String upgradeMessage = null;

    public SlaveAgent(Slave slave, SlaveService slaveService, ServiceTokenManager serviceTokenManager, BuildService buildService) {
        this.slave = slave;
        this.slaveService = slaveService;
        this.serviceTokenManager = serviceTokenManager;
        this.buildService = buildService;
        switch (slave.getEnableState()) {
            case ENABLED: {
                this.status = Status.OFFLINE;
                break;
            }
            case DISABLED: 
            case UPGRADING: {
                this.status = Status.DISABLED;
                break;
            }
            case FAILED_UPGRADE: {
                this.status = Status.DISABLED;
                this.upgradeState = UpgradeState.FAILED;
            }
        }
    }

    @Override
    public long getId() {
        return this.slave.getId();
    }

    @Override
    public BuildService getBuildService() {
        return this.buildService;
    }

    @Override
    public SystemInfo getSystemInfo() {
        return this.slaveService.getSystemInfo(this.serviceTokenManager.getToken());
    }

    @Override
    public List<CustomLogRecord> getRecentMessages() {
        return this.slaveService.getRecentMessages(this.serviceTokenManager.getToken());
    }

    public String getName() {
        return this.slave.getName();
    }

    public Slave getSlave() {
        return this.slave;
    }

    public SlaveService getSlaveService() {
        return this.slaveService;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getLocation() {
        return this.slave.getHost() + ":" + this.slave.getPort();
    }

    @Override
    public boolean isSlave() {
        return true;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getLastPingTime() {
        return this.lastPingTime;
    }

    public boolean hasBeenPinged() {
        return this.lastPingTime != 0L;
    }

    public String getPrettyPingTime() {
        if (this.hasBeenPinged()) {
            return DateFormat.getDateTimeInstance(1, 1).format(new Date(this.lastPingTime));
        }
        return "<never>";
    }

    public long getSecondsSincePing() {
        return (System.currentTimeMillis() - this.lastPingTime) / 1000L;
    }

    private void setLastPingTime(long time) {
        this.lastPingTime = time;
    }

    public String getPingError() {
        return this.pingError;
    }

    @Override
    public boolean isOnline() {
        return this.status.isOnline();
    }

    public boolean isEnabled() {
        return this.slave.isEnabled();
    }

    public boolean isUpgrading() {
        return this.slave.getEnableState() == Slave.EnableState.UPGRADING;
    }

    public boolean isFailedUpgrade() {
        return this.slave.getEnableState() == Slave.EnableState.FAILED_UPGRADE;
    }

    public boolean isAvailable() {
        return this.status == Status.IDLE;
    }

    public void updateStatus(SlaveStatus status) {
        this.lastPingTime = status.getPingTime();
        this.status = status.getStatus();
        this.pingError = status.getMessage();
    }

    public void upgradeStatus(UpgradeState state, int progress, String message) {
        this.upgradeState = state;
        this.upgradeProgress = progress;
        this.upgradeMessage = message;
    }

    public UpgradeState getUpgradeState() {
        return this.upgradeState;
    }

    public int getUpgradeProgress() {
        return this.upgradeProgress;
    }

    public String getUpgradeMessage() {
        return this.upgradeMessage;
    }
}

