/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.BuildContext;
import com.zutubi.pulse.BuildService;
import com.zutubi.pulse.RecipeDispatchRequest;
import com.zutubi.pulse.RecipeQueue;
import com.zutubi.pulse.agent.Agent;
import com.zutubi.pulse.agent.AgentManager;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.core.Stoppable;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.events.AgentEvent;
import com.zutubi.pulse.events.AgentStatusEvent;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.SlaveAgentRemovedEvent;
import com.zutubi.pulse.events.build.RecipeCompletedEvent;
import com.zutubi.pulse.events.build.RecipeDispatchedEvent;
import com.zutubi.pulse.events.build.RecipeErrorEvent;
import com.zutubi.pulse.events.build.RecipeEvent;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.scm.SCMChangeEvent;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.util.logging.Logger;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedRecipeQueue
implements Runnable,
RecipeQueue,
EventListener,
Stoppable {
    private static final Logger LOG = Logger.getLogger(ThreadedRecipeQueue.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition lockCondition = this.lock.newCondition();
    private final Map<Long, Agent> onlineAgents = new TreeMap<Long, Agent>();
    private final List<RecipeDispatchRequest> queuedDispatches = new LinkedList<RecipeDispatchRequest>();
    private final Map<Long, Agent> availableAgents = new TreeMap<Long, Agent>();
    private final Map<Long, Agent> executingAgents = new TreeMap<Long, Agent>();
    private ExecutorService executor;
    private boolean stopRequested = false;
    private boolean isRunning = false;
    private int sleepInterval = 60;
    private long unsatisfiableTimeout = 0L;
    private AgentManager agentManager;
    private EventManager eventManager;

    public void init() {
        try {
            for (Agent a : this.agentManager.getOnlineAgents()) {
                this.online(a);
            }
            this.eventManager.register((EventListener)this);
            this.start();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("The queue is already running.");
        }
        LOG.debug("start();");
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.execute(this);
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(RecipeDispatchRequest dispatchRequest) {
        RecipeErrorEvent error = null;
        try {
            this.determineRevision(dispatchRequest);
            this.lock.lock();
            try {
                if (this.requestMayBeFulfilled(dispatchRequest)) {
                    this.addToQueue(dispatchRequest);
                } else if (this.unsatisfiableTimeout == 0L) {
                    error = new RecipeErrorEvent((Object)this, dispatchRequest.getRequest().getId(), "No online agent is capable of executing the build stage");
                } else {
                    if (this.unsatisfiableTimeout > 0L) {
                        dispatchRequest.setTimeout(System.currentTimeMillis() + this.unsatisfiableTimeout);
                    }
                    this.addToQueue(dispatchRequest);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            error = new RecipeErrorEvent((Object)this, dispatchRequest.getRequest().getId(), "Unable to determine revision to build: " + e.getMessage());
        }
        if (error != null) {
            this.eventManager.publish((Event)error);
        }
    }

    private void addToQueue(RecipeDispatchRequest dispatchRequest) {
        this.queuedDispatches.add(dispatchRequest);
        dispatchRequest.queued();
        this.lockCondition.signal();
    }

    private void determineRevision(RecipeDispatchRequest dispatchRequest) throws BuildException, SCMException {
        BuildRevision buildRevision = dispatchRequest.getRevision();
        if (!buildRevision.isInitialised()) {
            Project project = dispatchRequest.getBuild().getProject();
            Scm scm = project.getScm();
            Revision revision = scm.createServer().getLatestRevision();
            this.updateRevision(dispatchRequest, revision);
        }
    }

    private void updateRevision(RecipeDispatchRequest dispatchRequest, Revision revision) throws BuildException {
        Project project = dispatchRequest.getBuild().getProject();
        String pulseFile = project.getPulseFileDetails().getPulseFile(dispatchRequest.getRequest().getId(), project, revision, null);
        dispatchRequest.getRevision().update(revision, pulseFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecipeDispatchRequest> takeSnapshot() {
        LinkedList<RecipeDispatchRequest> snapshot = new LinkedList<RecipeDispatchRequest>();
        this.lock.lock();
        try {
            snapshot.addAll(this.queuedDispatches);
        }
        finally {
            this.lock.unlock();
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelRequest(long id) {
        boolean removed = false;
        try {
            this.lock.lock();
            RecipeDispatchRequest removeRequest = null;
            for (RecipeDispatchRequest request : this.queuedDispatches) {
                if (request.getRequest().getId() != id) continue;
                removeRequest = request;
                break;
            }
            if (removeRequest != null) {
                this.queuedDispatches.remove(removeRequest);
                removed = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void online(Agent agent) {
        this.lock.lock();
        try {
            if (!this.onlineAgents.containsKey(agent.getId())) {
                this.onlineAgents.put(agent.getId(), agent);
                this.availableAgents.put(agent.getId(), agent);
                this.resetTimeouts(agent);
                this.lockCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void resetTimeouts(Agent agent) {
        for (RecipeDispatchRequest request : this.queuedDispatches) {
            if (!request.hasTimeout() || !request.getHostRequirements().fulfilledBy(request, agent.getBuildService())) continue;
            request.clearTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void offline(Agent agent) {
        RecipeErrorEvent error = null;
        List<RecipeDispatchRequest> removedRequests = null;
        this.lock.lock();
        try {
            this.onlineAgents.remove(agent.getId());
            if (this.unsatisfiableTimeout == 0L) {
                removedRequests = this.removeUnfulfillable();
            } else if (this.unsatisfiableTimeout > 0L) {
                this.checkQueuedTimeouts(System.currentTimeMillis() + this.unsatisfiableTimeout);
            }
            long deadRecipe = 0L;
            for (Map.Entry<Long, Agent> entry : this.executingAgents.entrySet()) {
                if (entry.getValue().getId() != agent.getId()) continue;
                deadRecipe = entry.getKey();
                break;
            }
            if (deadRecipe != 0L) {
                this.executingAgents.remove(deadRecipe);
                error = new RecipeErrorEvent((Object)this, deadRecipe, "Connection to agent lost during recipe execution");
            }
            this.availableAgents.remove(agent.getId());
            this.lockCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
        if (error != null) {
            this.eventManager.publish((Event)error);
        }
        if (removedRequests != null) {
            this.publishUnfulfillable(removedRequests);
        }
    }

    private void checkQueuedTimeouts(long timeout) {
        assert (this.lock.isHeldByCurrentThread());
        for (RecipeDispatchRequest request : this.queuedDispatches) {
            if (request.hasTimeout() || this.requestMayBeFulfilled(request)) continue;
            request.setTimeout(timeout);
        }
    }

    private List<RecipeDispatchRequest> removeUnfulfillable() {
        assert (this.lock.isHeldByCurrentThread());
        LinkedList<RecipeDispatchRequest> unfulfillable = new LinkedList<RecipeDispatchRequest>();
        for (RecipeDispatchRequest request : this.queuedDispatches) {
            if (this.requestMayBeFulfilled(request)) continue;
            unfulfillable.add(request);
        }
        this.queuedDispatches.removeAll(unfulfillable);
        return unfulfillable;
    }

    private boolean requestMayBeFulfilled(RecipeDispatchRequest request) {
        for (Agent a : this.onlineAgents.values()) {
            if (!request.getHostRequirements().fulfilledBy(request, a.getBuildService())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        this.stopRequested = false;
        LOG.debug("started.");
        while (!this.stopRequested) {
            this.lock.lock();
            LOG.debug("lock.lock();");
            try {
                if (this.stopRequested) break;
                LinkedList<RecipeDispatchRequest> doneRequests = new LinkedList<RecipeDispatchRequest>();
                LinkedList<Agent> unavailableAgents = new LinkedList<Agent>();
                long currentTime = System.currentTimeMillis();
                block7: for (RecipeDispatchRequest request : this.queuedDispatches) {
                    if (request.hasTimedOut(currentTime)) {
                        doneRequests.add(request);
                        this.eventManager.publish((Event)new RecipeErrorEvent((Object)this, request.getRequest().getId(), "Recipe request timed out waiting for a capable agent to become available"));
                        continue;
                    }
                    for (Agent agent : this.availableAgents.values()) {
                        BuildService service = agent.getBuildService();
                        if (!request.getHostRequirements().fulfilledBy(request, service) || unavailableAgents.contains(agent) || !this.dispatchRequest(request, agent, unavailableAgents, doneRequests)) continue;
                        continue block7;
                    }
                }
                this.queuedDispatches.removeAll(doneRequests);
                for (Agent a : unavailableAgents) {
                    this.availableAgents.remove(a.getId());
                }
                try {
                    LOG.debug("lockCondition.await();");
                    this.lockCondition.await(this.sleepInterval, TimeUnit.SECONDS);
                    LOG.debug("lockCondition.unawait();");
                }
                catch (InterruptedException e) {
                    LOG.debug("lockCondition.wait() was interrupted: " + e.getMessage());
                }
            }
            finally {
                this.lock.unlock();
                LOG.debug("lock.unlock();");
            }
        }
        this.executor.shutdown();
        LOG.debug("stopped.");
        this.isRunning = false;
    }

    private boolean dispatchRequest(RecipeDispatchRequest request, Agent agent, List<Agent> unavailableAgents, List<RecipeDispatchRequest> dispatchedRequests) {
        BuildRevision buildRevision = request.getRevision();
        RecipeRequest recipeRequest = request.getRequest();
        buildRevision.apply(recipeRequest);
        recipeRequest.prepare(agent.getName());
        this.eventManager.publish((Event)new RecipeDispatchedEvent(this, recipeRequest, agent));
        dispatchedRequests.add(request);
        try {
            BuildContext context = new BuildContext();
            context.setBuildNumber(request.getBuild().getNumber());
            context.setBuildRevision(buildRevision.getRevision().getRevisionString());
            context.setBuildTimestamp(buildRevision.getTimestamp());
            agent.getBuildService().build(recipeRequest, context);
            unavailableAgents.add(agent);
            this.executingAgents.put(recipeRequest.getId(), agent);
        }
        catch (Exception e) {
            LOG.warning("Unable to dispatch recipe: " + e.getMessage(), (Throwable)e);
            this.eventManager.publish((Event)new RecipeErrorEvent((Object)this, recipeRequest.getId(), "Unable to dispatch recipe: " + e.getMessage()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force) {
        if (this.isStopped()) {
            throw new IllegalStateException("The queue is already stopped.");
        }
        this.lock.lock();
        try {
            LOG.debug("stop();");
            this.stopRequested = true;
            this.lockCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isStopped() {
        return !this.isRunning();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        this.lock.lock();
        try {
            int n = this.queuedDispatches.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executingCount() {
        this.lock.lock();
        try {
            int n = this.executingAgents.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void handleEvent(Event evt) {
        if (evt instanceof RecipeEvent) {
            this.handleRecipeEvent((RecipeEvent)evt);
        } else if (evt instanceof AgentEvent) {
            this.handleSlaveEvent((AgentEvent)evt);
        } else if (evt instanceof SCMChangeEvent) {
            this.handleScmChange((SCMChangeEvent)evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecipeEvent(RecipeEvent event) {
        this.lock.lock();
        try {
            Agent agent = this.executingAgents.get(event.getRecipeId());
            if (agent != null) {
                this.executingAgents.remove(event.getRecipeId());
                if (this.onlineAgents.containsKey(agent.getId())) {
                    this.availableAgents.put(agent.getId(), agent);
                    this.lockCondition.signal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleSlaveEvent(AgentEvent event) {
        if (event instanceof AgentStatusEvent) {
            this.handleAgentStatus((AgentStatusEvent)event);
        } else if (event instanceof SlaveAgentRemovedEvent) {
            this.offline(event.getAgent());
        }
    }

    private void handleAgentStatus(AgentStatusEvent event) {
        Agent agent = event.getAgent();
        if (agent.isOnline()) {
            this.online(agent);
        } else {
            this.offline(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleScmChange(SCMChangeEvent event) {
        List<RecipeDispatchRequest> rejects = null;
        Scm changedScm = event.getScm();
        this.lock.lock();
        try {
            List<RecipeDispatchRequest> unfulfillable = this.checkQueueForChanges(changedScm, event, this.queuedDispatches);
            if (this.unsatisfiableTimeout == 0L) {
                this.queuedDispatches.removeAll(unfulfillable);
                rejects = unfulfillable;
            } else if (this.unsatisfiableTimeout > 0L) {
                this.updateTimeouts(unfulfillable, System.currentTimeMillis() + this.unsatisfiableTimeout);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (rejects != null) {
            this.publishUnfulfillable(rejects);
        }
    }

    private void updateTimeouts(List<RecipeDispatchRequest> requests, long timeout) {
        for (RecipeDispatchRequest request : requests) {
            if (request.hasTimeout()) continue;
            request.setTimeout(timeout);
        }
    }

    private void publishUnfulfillable(List<RecipeDispatchRequest> unfulfillable) {
        for (RecipeDispatchRequest request : unfulfillable) {
            this.eventManager.publish((Event)new RecipeErrorEvent((Object)this, request.getRequest().getId(), "No online agent is capable of executing the build stage"));
        }
    }

    private List<RecipeDispatchRequest> checkQueueForChanges(Scm changedScm, SCMChangeEvent event, List<RecipeDispatchRequest> requests) {
        LinkedList<RecipeDispatchRequest> unfulfillable = new LinkedList<RecipeDispatchRequest>();
        for (RecipeDispatchRequest request : requests) {
            Scm requestScm = request.getBuild().getProject().getScm();
            if (request.getRevision().isFixed() || requestScm.getId() != changedScm.getId()) continue;
            try {
                this.updateRevision(request, event.getNewRevision());
                if (this.requestMayBeFulfilled(request)) continue;
                unfulfillable.add(request);
            }
            catch (Exception e) {
                LOG.warning("Unable to check build revision: " + e.getMessage(), (Throwable)e);
            }
        }
        return unfulfillable;
    }

    public Class[] getHandledEvents() {
        return new Class[]{RecipeCompletedEvent.class, RecipeErrorEvent.class, SCMChangeEvent.class, AgentEvent.class};
    }

    public void setSleepInterval(int sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    public void setUnsatisfiableTimeout(long unsatisfiableTimeout) {
        this.unsatisfiableTimeout = unsatisfiableTimeout;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        long timeout = configurationManager.getAppConfig().getUnsatisfiableRecipeTimeout();
        if (timeout > 0L) {
            timeout *= 60000L;
        }
        this.unsatisfiableTimeout = timeout;
    }
}

