/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.BuildContext;
import com.zutubi.pulse.BuildService;
import com.zutubi.pulse.agent.MasterAgent;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SystemConfiguration;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.services.SlaveService;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipInputStream;
import org.mortbay.util.UrlEncoded;

public class SlaveBuildService
implements BuildService {
    private static final Logger LOG = Logger.getLogger(SlaveBuildService.class);
    private SlaveService service;
    private Slave slave;
    private MasterConfigurationManager configurationManager;
    private ResourceManager resourceManager;
    private ServiceTokenManager serviceTokenManager;

    public SlaveBuildService(SlaveService service, ServiceTokenManager serviceTokenManager, Slave slave, MasterConfigurationManager configurationManager, ResourceManager resourceManager) {
        this.service = service;
        this.serviceTokenManager = serviceTokenManager;
        this.slave = slave;
        this.configurationManager = configurationManager;
        this.resourceManager = resourceManager;
    }

    public String getUrl() {
        return this.slave.getHost() + ":" + this.slave.getPort();
    }

    public boolean hasResource(String resource, String version) {
        return this.resourceManager.getSlaveRepository(this.slave).hasResource(resource, version);
    }

    public boolean build(RecipeRequest request, BuildContext context) {
        MasterConfiguration appConfig = this.configurationManager.getAppConfig();
        SystemConfiguration systemConfig = this.configurationManager.getSystemConfig();
        String masterUrl = "http://" + MasterAgent.constructMasterLocation(appConfig, systemConfig);
        try {
            return this.service.build(this.serviceTokenManager.getToken(), masterUrl, this.slave.getId(), request, context);
        }
        catch (RuntimeException e) {
            throw this.convertException("Unable to dispatch recipe request '" + request.getId() + "' to slave '" + this.slave.getName() + "'", e);
        }
    }

    public void collectResults(String project, String spec, long recipeId, boolean incremental, File outputDest, File workDest) {
        this.collect(project, spec, recipeId, incremental, true, outputDest);
        if (workDest != null) {
            this.collect(project, spec, recipeId, incremental, false, workDest);
        }
    }

    private void collect(String project, String spec, long recipeId, boolean incremental, boolean output, File destination) {
        File tempDir;
        FileOutputStream fos;
        FileInputStream fis;
        ZipInputStream zis;
        block7: {
            zis = null;
            fis = null;
            fos = null;
            tempDir = null;
            try {
                tempDir = new File(destination.getAbsolutePath() + ".tmp");
                if (!tempDir.mkdirs()) {
                    tempDir = null;
                    throw new BuildException("Unable to create temporary directory '" + tempDir.getAbsolutePath() + "'");
                }
                URL resultUrl = new URL("http", this.slave.getHost(), this.slave.getPort(), "/download?token=" + this.serviceTokenManager.getToken() + "&project=" + UrlEncoded.encodeString((String)project) + "&spec=" + UrlEncoded.encodeString((String)spec) + "&incremental=" + incremental + "&output=" + output + "&recipe=" + recipeId);
                URLConnection urlConnection = resultUrl.openConnection();
                File zipFile = new File(destination.getAbsolutePath() + ".zip");
                fos = new FileOutputStream(zipFile);
                IOUtils.joinStreams((InputStream)urlConnection.getInputStream(), (OutputStream)fos);
                IOUtils.close((Closeable)urlConnection.getInputStream());
                IOUtils.close((Closeable)fos);
                fos = null;
                fis = new FileInputStream(zipFile);
                zis = new ZipInputStream(fis);
                FileSystemUtils.extractZip((ZipInputStream)zis, (File)tempDir);
                IOUtils.close((Closeable)fis);
                fis = null;
                IOUtils.close((Closeable)zis);
                zis = null;
                zipFile.delete();
                if (tempDir.renameTo(destination)) break block7;
                throw new BuildException("Unable to rename result directory to '" + destination.getAbsolutePath() + "'");
            }
            catch (IOException e) {
                try {
                    throw new BuildException("Error downloading results from agent '" + this.slave.getName() + ": " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.close(zis);
                    IOUtils.close(fis);
                    IOUtils.close(fos);
                    if (tempDir != null) {
                        FileSystemUtils.rmdir(tempDir);
                    }
                    throw throwable;
                }
            }
        }
        IOUtils.close((Closeable)zis);
        IOUtils.close((Closeable)fis);
        IOUtils.close((Closeable)fos);
        if (tempDir != null) {
            FileSystemUtils.rmdir((File)tempDir);
        }
    }

    public void cleanup(String project, String spec, long recipeId, boolean incremental) {
        try {
            this.service.cleanupRecipe(this.serviceTokenManager.getToken(), project, spec, recipeId, incremental);
        }
        catch (Exception e) {
            LOG.warning("Failed to cleanup recipe '" + recipeId + "' on slave '" + this.slave.getName() + "'", (Throwable)e);
        }
    }

    public void terminateRecipe(long recipeId) {
        try {
            this.service.terminateRecipe(this.serviceTokenManager.getToken(), recipeId);
        }
        catch (RuntimeException e) {
            LOG.severe("Unable to terminate recipe: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getHostName() {
        return this.slave.getName();
    }

    public Slave getSlave() {
        return this.slave;
    }

    private BuildException convertException(String context, RuntimeException e) {
        return new BuildException(context + ": " + e.getMessage(), (Throwable)e);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SlaveBuildService) {
            SlaveBuildService other = (SlaveBuildService)obj;
            return other.getSlave().equals((Object)this.slave);
        }
        return false;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

