/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.model.BuildHostRequirements;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.util.TimeStamps;

public class RecipeDispatchRequest {
    private BuildHostRequirements hostRequirements;
    private BuildRevision revision;
    private RecipeRequest request;
    private BuildResult build;
    private long queueTime;
    private long timeout = -1L;

    public RecipeDispatchRequest(BuildHostRequirements hostRequirements, BuildRevision revision, RecipeRequest request, BuildResult build) {
        this.hostRequirements = hostRequirements;
        this.revision = revision;
        this.request = request;
        this.build = build;
    }

    public BuildHostRequirements getHostRequirements() {
        return this.hostRequirements;
    }

    public RecipeRequest getRequest() {
        return this.request;
    }

    public BuildRevision getRevision() {
        return this.revision;
    }

    public BuildResult getBuild() {
        return this.build;
    }

    public void queued() {
        this.queueTime = System.currentTimeMillis();
    }

    public long getQueueTime() {
        return this.queueTime;
    }

    public String getPrettyQueueTime() {
        return TimeStamps.getPrettyTime((long)this.queueTime);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean hasTimeout() {
        return this.timeout >= 0L;
    }

    public boolean hasTimedOut(long currentTime) {
        return this.hasTimeout() && currentTime >= this.timeout;
    }

    public void clearTimeout() {
        this.timeout = -1L;
    }
}

