/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostProcessorManager {
    private static final String DISPLAY_KEY = "display";
    private static final Logger LOG = Logger.getLogger(PostProcessorManager.class);
    private MasterConfigurationManager configurationManager;

    public Map<String, String> getAvailableProcessors() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        SystemPaths systemPaths = this.configurationManager.getSystemPaths();
        for (File templateRoot : systemPaths.getTemplateRoots()) {
            File processorsDir = new File(templateRoot, FileSystemUtils.composeFilename((String[])new String[]{"pulse-file", "post-processors"}));
            String[] list = processorsDir.list();
            if (list == null) continue;
            for (String name : list) {
                if (!name.endsWith(".vm")) continue;
                this.processFile(new File(processorsDir, name), result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File file, Map<String, String> processors) {
        block6: {
            String name;
            if (!file.isFile()) break block6;
            String display = name = file.getName().substring(0, file.getName().length() - 3);
            String path = file.getAbsolutePath();
            File propertiesFile = new File(path.substring(0, path.length() - 2) + "properties");
            if (propertiesFile.isFile()) {
                FileInputStream in;
                block5: {
                    in = null;
                    try {
                        in = new FileInputStream(propertiesFile);
                        Properties properties = new Properties();
                        properties.load(in);
                        if (!properties.containsKey(DISPLAY_KEY)) break block5;
                        display = (String)properties.get(DISPLAY_KEY);
                    }
                    catch (Exception e) {
                        try {
                            LOG.warning("Unable to load properties from '" + propertiesFile.getAbsolutePath() + "': " + e.getMessage());
                        }
                        catch (Throwable throwable) {
                            IOUtils.close(in);
                            throw throwable;
                        }
                        IOUtils.close((Closeable)in);
                    }
                }
                IOUtils.close((Closeable)in);
            }
            processors.put(name, display);
        }
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

