/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.agent.AgentManager;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.model.PersistentResource;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.services.InvalidTokenException;
import com.zutubi.pulse.services.MasterService;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.services.UpgradeStatus;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterServiceImpl
implements MasterService {
    private ServiceTokenManager serviceTokenManager;
    private EventManager eventManager;
    private ResourceManager resourceManager;
    private SlaveManager slaveManager;
    private AgentManager agentManager;

    public void upgradeStatus(String token, UpgradeStatus upgradeStatus) {
        this.getServiceTokenManager().validateToken(token);
        this.agentManager.upgradeStatus(upgradeStatus);
    }

    public void handleEvent(String token, Event event) throws InvalidTokenException {
        this.getServiceTokenManager().validateToken(token);
        this.eventManager.publish(event);
    }

    public Resource getResource(String token, long slaveId, String name) throws InvalidTokenException {
        PersistentResource persistent;
        this.getServiceTokenManager().validateToken(token);
        Slave slave = this.getSlaveManager().getSlave(slaveId);
        Resource resource = null;
        if (slave != null && (persistent = this.getResourceManager().findBySlaveAndName(slave, name)) != null) {
            resource = persistent.asResource();
        }
        return resource;
    }

    public List<String> getResourceNames(String token, long slaveId) throws InvalidTokenException {
        this.getServiceTokenManager().validateToken(token);
        Slave slave = this.getSlaveManager().getSlave(slaveId);
        if (slave != null) {
            return this.getResourceManager().getSlaveRepository(slave).getResourceNames();
        }
        return null;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setSlaveManager(SlaveManager slaveManager) {
        this.slaveManager = slaveManager;
    }

    public void setServiceTokenManager(ServiceTokenManager serviceTokenManager) {
        this.serviceTokenManager = serviceTokenManager;
    }

    private SlaveManager getSlaveManager() {
        if (this.slaveManager == null) {
            ComponentContext.autowire((Object)this);
        }
        return this.slaveManager;
    }

    private ResourceManager getResourceManager() {
        if (this.slaveManager == null) {
            ComponentContext.autowire((Object)this);
        }
        return this.resourceManager;
    }

    public ServiceTokenManager getServiceTokenManager() {
        if (this.serviceTokenManager == null) {
            ComponentContext.autowire((Object)this);
        }
        return this.serviceTokenManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }
}

