/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.BuildContext;
import com.zutubi.pulse.ChainBootstrapper;
import com.zutubi.pulse.ServerBootstrapper;
import com.zutubi.pulse.ServerRecipePaths;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.Bootstrapper;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.RecipePaths;
import com.zutubi.pulse.core.RecipeProcessor;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.build.RecipeErrorEvent;
import com.zutubi.pulse.repository.FileRepository;
import com.zutubi.pulse.repository.MasterFileRepository;
import com.zutubi.pulse.util.logging.Logger;

public class MasterRecipeRunner
implements Runnable {
    private static final Logger LOG = Logger.getLogger(MasterRecipeRunner.class);
    private RecipeRequest request;
    private RecipeProcessor recipeProcessor;
    private EventManager eventManager;
    private MasterConfigurationManager configurationManager;
    private ResourceRepository resourceRepository;
    private BuildContext context;

    public MasterRecipeRunner(RecipeRequest request, RecipeProcessor recipeProcessor, EventManager eventManager, MasterConfigurationManager configurationManager, ResourceRepository resourceRepository, BuildContext context) {
        this.request = request;
        this.recipeProcessor = recipeProcessor;
        this.eventManager = eventManager;
        this.configurationManager = configurationManager;
        this.resourceRepository = resourceRepository;
        this.context = context;
    }

    public void run() {
        Bootstrapper requestBootstrapper = this.request.getBootstrapper();
        this.context.setFileRepository((FileRepository)new MasterFileRepository(this.configurationManager));
        this.request.setBootstrapper((Bootstrapper)new ChainBootstrapper(new Bootstrapper[]{new ServerBootstrapper(), requestBootstrapper}));
        ServerRecipePaths recipePaths = new ServerRecipePaths(this.request.getProject(), this.request.getSpec(), this.request.getId(), this.configurationManager.getUserPaths().getData(), this.request.isIncremental());
        try {
            this.recipeProcessor.build(this.request, (RecipePaths)recipePaths, this.resourceRepository, true, this.context);
        }
        catch (BuildException e) {
            this.eventManager.publish((Event)new RecipeErrorEvent((Object)this, this.request.getId(), e.getMessage()));
        }
        catch (Exception e) {
            LOG.severe((Throwable)e);
            this.eventManager.publish((Event)new RecipeErrorEvent((Object)this, this.request.getId(), "Unexpected error: " + e.getMessage()));
        }
    }
}

