/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.BuildContext;
import com.zutubi.pulse.MasterRecipeRunner;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.RecipeProcessor;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.Stoppable;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.util.logging.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MasterRecipeProcessor
implements Stoppable {
    private static final Logger LOG = Logger.getLogger(MasterRecipeProcessor.class);
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private RecipeProcessor recipeProcessor;
    private MasterConfigurationManager configurationManager;
    private EventManager eventManager;
    private ResourceManager resourceManager;

    public void processRecipe(RecipeRequest request, BuildContext context) {
        this.executor.execute(new MasterRecipeRunner(request, this.recipeProcessor, this.eventManager, this.configurationManager, (ResourceRepository)this.resourceManager.getMasterRepository(), context));
    }

    public void setRecipeProcessor(RecipeProcessor recipeProcessor) {
        this.recipeProcessor = recipeProcessor;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void terminateRecipe(long id) {
        try {
            this.recipeProcessor.terminateRecipe(id);
        }
        catch (InterruptedException e) {
            LOG.warning("Interrupted while terminating recipe", (Throwable)e);
        }
    }

    public void stop(boolean force) {
        this.executor.shutdownNow();
    }

    public long getBuildingRecipe() {
        return this.recipeProcessor.getBuildingRecipe();
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

