/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.RecipeController;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.util.TreeNode;
import com.zutubi.pulse.util.TreeNodeOperation;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTree
implements Iterable<RecipeController> {
    private TreeNode<RecipeController> root = new TreeNode(null);

    public TreeNode<RecipeController> getRoot() {
        return this.root;
    }

    public void prepare(final BuildResult buildResult) {
        this.apply(new TreeNodeOperation<RecipeController>(){

            public void apply(TreeNode<RecipeController> node) {
                ((RecipeController)node.getData()).prepare(buildResult);
            }
        });
    }

    public void cleanup(final BuildResult buildResult) {
        this.apply(new TreeNodeOperation<RecipeController>(){

            public void apply(TreeNode<RecipeController> node) {
                ((RecipeController)node.getData()).cleanup(buildResult);
            }
        });
    }

    public void apply(TreeNodeOperation<RecipeController> op) {
        this.apply(op, this.root);
    }

    private void apply(TreeNodeOperation<RecipeController> op, TreeNode<RecipeController> node) {
        for (TreeNode child : node) {
            op.apply(child);
            this.apply(op, (TreeNode<RecipeController>)child);
        }
    }

    @Override
    public Iterator<RecipeController> iterator() {
        ControllerAccumulator accumulator = new ControllerAccumulator();
        this.apply(accumulator);
        return accumulator.getControllers().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ControllerAccumulator
    implements TreeNodeOperation<RecipeController> {
        private List<RecipeController> controllers = new LinkedList<RecipeController>();

        private ControllerAccumulator() {
        }

        public List<RecipeController> getControllers() {
            return this.controllers;
        }

        public void apply(TreeNode<RecipeController> node) {
            this.controllers.add((RecipeController)node.getData());
        }
    }
}

