/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.events.build.AbstractBuildRequestEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueue {
    private Map<Entity, List<AbstractBuildRequestEvent>> requests = new HashMap<Entity, List<AbstractBuildRequestEvent>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildRequested(AbstractBuildRequestEvent event) {
        List<AbstractBuildRequestEvent> entityRequests;
        Entity entity = event.getOwner();
        this.checkEntity(entity);
        List<AbstractBuildRequestEvent> list = entityRequests = this.requests.get(entity);
        synchronized (list) {
            if (entityRequests.size() > 0) {
                this.enqueueRequest(entityRequests, event);
                return false;
            }
            entityRequests.add(event);
            return true;
        }
    }

    private void checkEntity(Entity entity) {
        if (!this.requests.containsKey(entity)) {
            this.requests.put(entity, new LinkedList());
        }
    }

    private void enqueueRequest(List<AbstractBuildRequestEvent> entityRequests, AbstractBuildRequestEvent event) {
        if (!event.getRevision().isFixed()) {
            for (AbstractBuildRequestEvent e : entityRequests) {
                if (e.getRevision().isFixed() || !e.getSpecification().equals((Object)event.getSpecification())) continue;
                return;
            }
        }
        entityRequests.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBuildRequestEvent buildCompleted(Entity owner) {
        List<AbstractBuildRequestEvent> entityRequests = this.requests.get(owner);
        assert (entityRequests.size() > 0);
        List<AbstractBuildRequestEvent> list = entityRequests;
        synchronized (list) {
            entityRequests.remove(0);
            if (entityRequests.size() > 0) {
                return entityRequests.get(0);
            }
            return null;
        }
    }

    public Map<Entity, List<AbstractBuildRequestEvent>> takeSnapshot() {
        HashMap<Entity, List<AbstractBuildRequestEvent>> queue = new HashMap<Entity, List<AbstractBuildRequestEvent>>();
        for (Map.Entry<Entity, List<AbstractBuildRequestEvent>> entry : this.requests.entrySet()) {
            LinkedList events = new LinkedList(entry.getValue());
            queue.put(entry.getKey(), events);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelBuild(long id) {
        for (Map.Entry<Entity, List<AbstractBuildRequestEvent>> entry : this.requests.entrySet()) {
            List<AbstractBuildRequestEvent> events;
            List<AbstractBuildRequestEvent> list = events = entry.getValue();
            synchronized (list) {
                Iterator<AbstractBuildRequestEvent> it = events.iterator();
                if (it.hasNext()) {
                    it.next();
                    while (it.hasNext()) {
                        if (it.next().getId() != id) continue;
                        it.remove();
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

