/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse;

import com.zutubi.pulse.BuildTree;
import com.zutubi.pulse.CheckoutBootstrapper;
import com.zutubi.pulse.DefaultRecipeLogger;
import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.PatchBootstrapper;
import com.zutubi.pulse.ProjectRepoBootstrapper;
import com.zutubi.pulse.RecipeController;
import com.zutubi.pulse.RecipeDispatchRequest;
import com.zutubi.pulse.RecipeQueue;
import com.zutubi.pulse.RecipeResultCollector;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.Bootstrapper;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.RecipeRequest;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.events.AsynchronousDelegatingListener;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.build.AbstractBuildRequestEvent;
import com.zutubi.pulse.events.build.BuildCommencedEvent;
import com.zutubi.pulse.events.build.BuildCompletedEvent;
import com.zutubi.pulse.events.build.BuildTerminationRequestEvent;
import com.zutubi.pulse.events.build.PersonalBuildRequestEvent;
import com.zutubi.pulse.events.build.RecipeCommencedEvent;
import com.zutubi.pulse.events.build.RecipeCompletedEvent;
import com.zutubi.pulse.events.build.RecipeDispatchedEvent;
import com.zutubi.pulse.events.build.RecipeErrorEvent;
import com.zutubi.pulse.events.build.RecipeEvent;
import com.zutubi.pulse.events.build.RecipeTimeoutEvent;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildScmDetails;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.BuildStage;
import com.zutubi.pulse.model.PostBuildAction;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.ResourceRequirement;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.model.TestManager;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.scm.FileStatus;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMServer;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.TimeStamps;
import com.zutubi.pulse.util.TreeNode;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildController
implements EventListener {
    private static final String TIMEOUT_TRIGGER_GROUP = "timeout";
    private static final Logger LOG = Logger.getLogger(BuildController.class);
    private AbstractBuildRequestEvent request;
    private Project project;
    private BuildSpecification specification;
    private EventManager eventManager;
    private ProjectManager projectManager;
    private UserManager userManager;
    private BuildManager buildManager;
    private TestManager testManager;
    private MasterConfigurationManager configurationManager;
    private RecipeQueue queue;
    private RecipeResultCollector collector;
    private BuildTree tree;
    private BuildResult buildResult;
    private AsynchronousDelegatingListener asyncListener;
    private List<TreeNode<RecipeController>> executingControllers = new LinkedList<TreeNode<RecipeController>>();
    private int pendingRecipes = 0;
    private Scheduler quartzScheduler;
    private ServiceTokenManager serviceTokenManager;
    private BuildResult previousSuccessful;
    private List<ResourceProperty> buildProperties;

    public BuildController(AbstractBuildRequestEvent event, BuildSpecification specification, EventManager eventManager, ProjectManager projectManager, UserManager userManager, BuildManager buildManager, TestManager testManager, RecipeQueue queue, RecipeResultCollector collector, Scheduler quartScheduler, MasterConfigurationManager configManager, ServiceTokenManager serviceTokenManager) {
        this.request = event;
        this.project = event.getProject();
        this.specification = specification;
        this.eventManager = eventManager;
        this.projectManager = projectManager;
        this.userManager = userManager;
        this.buildManager = buildManager;
        this.testManager = testManager;
        this.queue = queue;
        this.collector = collector;
        this.quartzScheduler = quartScheduler;
        this.asyncListener = new AsynchronousDelegatingListener((EventListener)this);
        this.configurationManager = configManager;
        this.serviceTokenManager = serviceTokenManager;
    }

    public void run() {
        this.createBuildTree();
        if (!this.buildResult.isPersistent()) {
            throw new RuntimeException("Build result must be a persistent instance.");
        }
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        File buildDir = paths.getBuildDir(this.buildResult);
        this.buildResult.setAbsoluteOutputDir(this.configurationManager.getDataDirectory(), buildDir);
        this.buildResult.queue();
        this.buildManager.save(this.buildResult);
        this.eventManager.register((EventListener)this.asyncListener);
        this.eventManager.publish((Event)new BuildCommencedEvent(this, this.buildResult));
    }

    public BuildTree createBuildTree() {
        this.tree = new BuildTree();
        TreeNode<RecipeController> root = this.tree.getRoot();
        this.buildResult = this.request.createResult(this.projectManager, this.userManager);
        this.buildManager.save(this.buildResult);
        this.previousSuccessful = this.getPreviousSuccessfulBuild();
        this.buildProperties = this.specification.copyProperties();
        this.configure(root, this.buildResult.getRoot(), this.specification, this.specification.getRoot());
        return this.tree;
    }

    private BuildResult getPreviousSuccessfulBuild() {
        BuildResult previousSuccessful = null;
        List<BuildResult> previousSuccess = this.buildManager.querySpecificationBuilds(this.project, this.specification.getPname(), new ResultState[]{ResultState.SUCCESS}, -1L, -1L, 0, 1, true, true);
        if (previousSuccess.size() > 0) {
            previousSuccessful = previousSuccess.get(0);
        }
        return previousSuccessful;
    }

    private void configure(TreeNode<RecipeController> rcNode, RecipeResultNode resultNode, BuildSpecification specification, BuildSpecificationNode specNode) {
        for (BuildSpecificationNode node : specNode.getChildren()) {
            BuildStage stage = node.getStage();
            RecipeResult recipeResult = new RecipeResult(stage.getRecipe());
            RecipeResultNode childResultNode = new RecipeResultNode(stage.getPname(), recipeResult);
            resultNode.addChild(childResultNode);
            this.buildManager.save(resultNode);
            MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
            File recipeOutputDir = paths.getOutputDir(this.buildResult, recipeResult.getId());
            recipeResult.setAbsoluteOutputDir(this.configurationManager.getDataDirectory(), recipeOutputDir);
            boolean incremental = !this.request.isPersonal() && specification.getCheckoutScheme() == BuildSpecification.CheckoutScheme.INCREMENTAL_UPDATE;
            RecipeRequest recipeRequest = new RecipeRequest(this.project.getName(), specification.getName(), recipeResult.getId(), stage.getRecipe(), incremental, this.getResourceRequirements(specification, node), this.buildProperties);
            RecipeDispatchRequest dispatchRequest = new RecipeDispatchRequest(stage.getHostRequirements(), this.request.getRevision(), recipeRequest, this.buildResult);
            DefaultRecipeLogger logger = new DefaultRecipeLogger(new File(paths.getRecipeDir(this.buildResult, recipeResult.getId()), "recipe.log"));
            RecipeResultNode previousRecipe = this.previousSuccessful == null ? null : this.previousSuccessful.findResultNode(stage.getPname());
            RecipeController rc = new RecipeController(this.buildResult, node, childResultNode, dispatchRequest, this.buildProperties, this.request.isPersonal(), incremental, previousRecipe, logger, this.collector, this.queue, this.buildManager, this.serviceTokenManager);
            TreeNode child = new TreeNode((Object)rc);
            rcNode.add(child);
            ++this.pendingRecipes;
            this.configure((TreeNode<RecipeController>)child, childResultNode, specification, node);
        }
    }

    private List<ResourceRequirement> getResourceRequirements(BuildSpecification specification, BuildSpecificationNode node) {
        LinkedList<ResourceRequirement> requirements = new LinkedList<ResourceRequirement>();
        requirements.addAll(specification.getRoot().getResourceRequirements());
        requirements.addAll(node.getResourceRequirements());
        return requirements;
    }

    public void handleEvent(Event evt) {
        try {
            if (evt instanceof BuildCommencedEvent) {
                BuildCommencedEvent e = (BuildCommencedEvent)evt;
                if (e.getResult() == this.buildResult) {
                    this.handleBuildCommenced();
                }
            } else if (evt instanceof BuildTerminationRequestEvent) {
                this.handleBuildTerminationRequest((BuildTerminationRequestEvent)evt);
            } else if (evt instanceof RecipeTimeoutEvent) {
                this.handleRecipeTimeout((RecipeTimeoutEvent)evt);
            } else if (evt instanceof RecipeEvent) {
                RecipeEvent e = (RecipeEvent)evt;
                this.handleRecipeEvent(e);
            } else {
                LOG.warning("Build controller received unexpected event of type " + evt.getClass().getName());
            }
        }
        catch (BuildException e) {
            this.buildResult.error(e);
            this.completeBuild();
        }
        catch (Exception e) {
            LOG.severe((Throwable)e);
            this.buildResult.error("Unexpected error: " + e.getMessage());
            this.completeBuild();
        }
    }

    private void handleBuildCommenced() {
        CheckoutBootstrapper initialBootstrapper;
        boolean checkoutOnly;
        this.project = this.projectManager.getProject(this.project.getId());
        this.specification = this.project.getBuildSpecification(this.specification.getId());
        if (this.specification == null) {
            throw new BuildException("Build specification deleted during build");
        }
        File buildDir = this.buildResult.getAbsoluteOutputDir(this.configurationManager.getDataDirectory());
        if (!buildDir.mkdirs()) {
            throw new BuildException("Unable to create build directory '" + buildDir.getAbsolutePath() + "'");
        }
        if (!this.buildManager.isSpaceAvailableForBuild()) {
            throw new BuildException("Insufficient database space to run build.  Consider adding more cleanup rules to remove old build information");
        }
        boolean bl = checkoutOnly = this.request.isPersonal() || this.specification.getCheckoutScheme() == BuildSpecification.CheckoutScheme.CLEAN_CHECKOUT;
        if (checkoutOnly) {
            initialBootstrapper = new CheckoutBootstrapper(this.project.getName(), this.specification.getName(), this.project.getScm(), this.request.getRevision(), false);
            if (this.request.isPersonal()) {
                initialBootstrapper = this.createPersonalBuildBootstrapper((Bootstrapper)initialBootstrapper);
            }
        } else {
            initialBootstrapper = new ProjectRepoBootstrapper(this.project.getName(), this.specification.getName(), this.project.getScm(), this.request.getRevision(), this.specification.getForceClean());
        }
        this.tree.prepare(this.buildResult);
        this.initialiseNodes((Bootstrapper)initialBootstrapper, this.tree.getRoot().getChildren());
    }

    private Bootstrapper createPersonalBuildBootstrapper(Bootstrapper initialBootstrapper) {
        PersonalBuildRequestEvent pbr = (PersonalBuildRequestEvent)this.request;
        try {
            FileStatus.EOLStyle localEOL = this.project.getScm().createServer().getEOLPolicy();
            initialBootstrapper = new PatchBootstrapper(initialBootstrapper, pbr.getUser().getId(), pbr.getNumber(), localEOL);
        }
        catch (SCMException e) {
            throw new BuildException("Unable to determine SCM end-of-line policy: " + e.getMessage(), (Throwable)e);
        }
        return initialBootstrapper;
    }

    private String getTriggerName(long recipeId) {
        return String.format("recipe-%d", recipeId);
    }

    private void handleBuildTerminationRequest(BuildTerminationRequestEvent event) {
        long id = event.getBuildId();
        if (id == this.buildResult.getId() || id == -1L) {
            this.buildResult.terminate(event.isTimeout());
            ArrayList<TreeNode<RecipeController>> completedNodes = new ArrayList<TreeNode<RecipeController>>(this.executingControllers.size());
            if (this.executingControllers.size() > 0) {
                for (TreeNode<RecipeController> controllerNode : this.executingControllers) {
                    RecipeController controller = (RecipeController)controllerNode.getData();
                    controller.terminateRecipe(event.isTimeout());
                    if (!controller.isFinished()) continue;
                    completedNodes.add(controllerNode);
                }
                this.buildManager.save(this.buildResult);
                this.executingControllers.removeAll(completedNodes);
            }
            if (this.executingControllers.size() == 0) {
                this.completeBuild();
            }
        }
    }

    private void handleRecipeTimeout(RecipeTimeoutEvent event) {
        TreeNode<RecipeController> found = null;
        for (TreeNode<RecipeController> controllerNode : this.executingControllers) {
            RecipeController controller = (RecipeController)controllerNode.getData();
            if (controller.getResult().getId() != event.getRecipeId()) continue;
            found = controllerNode;
            break;
        }
        if (found != null) {
            RecipeController controller = (RecipeController)found.getData();
            controller.terminateRecipe(true);
            if (controller.isFinished()) {
                this.executingControllers.remove(controller);
                if (this.executingControllers.size() == 0) {
                    this.completeBuild();
                }
            }
        }
    }

    private void initialiseNodes(Bootstrapper bootstrapper, List<TreeNode<RecipeController>> nodes) {
        for (TreeNode<RecipeController> node : nodes) {
            this.executingControllers.add(node);
        }
        for (TreeNode<RecipeController> node : nodes) {
            ((RecipeController)node.getData()).initialise(bootstrapper);
            this.checkNodeStatus(node);
        }
    }

    private void handleRecipeEvent(RecipeEvent e) {
        TreeNode<RecipeController> foundNode = null;
        for (TreeNode<RecipeController> node : this.executingControllers) {
            RecipeController controller = (RecipeController)node.getData();
            if (!controller.handleRecipeEvent(e)) continue;
            foundNode = node;
            break;
        }
        if (foundNode != null) {
            if (e instanceof RecipeCommencedEvent) {
                --this.pendingRecipes;
                if (this.pendingRecipes == 0) {
                    this.handleLastCommenced();
                }
                if (this.specification.getTimeout() != 0) {
                    this.scheduleTimeout(e.getRecipeId());
                }
            } else if (e instanceof RecipeDispatchedEvent) {
                if (!this.buildResult.commenced()) {
                    this.handleFirstDispatch((RecipeController)foundNode.getData());
                }
            } else if (e instanceof RecipeCompletedEvent || e instanceof RecipeErrorEvent) {
                RecipeCompletedEvent completedEvent;
                String version;
                try {
                    if (!this.quartzScheduler.isShutdown()) {
                        this.quartzScheduler.unscheduleJob(this.getTriggerName(e.getRecipeId()), TIMEOUT_TRIGGER_GROUP);
                    }
                }
                catch (SchedulerException ex) {
                    LOG.warning("Unable to unschedule timeout trigger: " + ex.getMessage(), (Throwable)ex);
                }
                if (e instanceof RecipeCompletedEvent && (version = (completedEvent = (RecipeCompletedEvent)e).getBuildVersion()) != null) {
                    this.buildResult.setVersion(version);
                    this.buildManager.save(this.buildResult);
                }
            }
            this.checkNodeStatus(foundNode);
        }
    }

    private void handleLastCommenced() {
        long longestRemaining = 0L;
        for (RecipeController controller : this.tree) {
            long remaining;
            TimeStamps stamps = controller.getResult().getStamps();
            if (!stamps.hasEstimatedEndTime() || (remaining = stamps.getEstimatedTimeRemaining()) <= longestRemaining) continue;
            longestRemaining = remaining;
        }
        TimeStamps buildStamps = this.buildResult.getStamps();
        long estimatedEnd = System.currentTimeMillis() + longestRemaining;
        if (estimatedEnd > buildStamps.getStartTime()) {
            buildStamps.setEstimatedRunningTime(estimatedEnd - buildStamps.getStartTime());
        }
    }

    private void handleFirstDispatch(RecipeController controller) {
        RecipeDispatchRequest dispatchRequest = controller.getDispatchRequest();
        RecipeRequest request = dispatchRequest.getRequest();
        try {
            FileSystemUtils.createFile((File)new File(this.buildResult.getAbsoluteOutputDir(this.configurationManager.getDataDirectory()), "pulse.xml"), (String)request.getPulseFileSource());
        }
        catch (IOException e) {
            LOG.warning("Unable to save pulse file for build: " + e.getMessage(), (Throwable)e);
        }
        if (!this.buildResult.isPersonal()) {
            this.getChanges(dispatchRequest.getRevision());
        }
        this.buildResult.commence(dispatchRequest.getRevision().getTimestamp());
        if (this.previousSuccessful != null) {
            this.buildResult.getStamps().setEstimatedRunningTime(this.previousSuccessful.getStamps().getElapsed());
        }
        this.buildManager.save(this.buildResult);
    }

    private void getChanges(BuildRevision buildRevision) {
        Revision revision = buildRevision.getRevision();
        BuildScmDetails scmDetails = new BuildScmDetails(revision);
        this.buildResult.setScmDetails(scmDetails);
        if (!this.buildResult.isUserRevision()) {
            Scm scm = this.project.getScm();
            Revision previousRevision = this.buildManager.getPreviousRevision(this.project, this.specification.getPname());
            if (previousRevision != null) {
                try {
                    SCMServer server = scm.createServer();
                    this.getChangeSince(server, previousRevision, revision);
                }
                catch (SCMException e) {
                    LOG.warning("Unable to retrieve changelist details from SCM server: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private List<Changelist> getChangeSince(SCMServer server, Revision previousRevision, Revision revision) throws SCMException {
        LinkedList<Changelist> result = new LinkedList<Changelist>();
        List scmChanges = server.getChanges(previousRevision, revision, new String[]{""});
        String uid = server.getUid();
        for (Changelist change : scmChanges) {
            Changelist alreadySaved = this.buildManager.getChangelistByRevision(uid, change.getRevision());
            if (alreadySaved != null) {
                change = alreadySaved;
            }
            change.addProjectId(this.buildResult.getProject().getId());
            change.addResultId(this.buildResult.getId());
            this.buildManager.save(change);
            result.add(change);
        }
        return result;
    }

    private void scheduleTimeout(long recipeId) {
        String name = this.getTriggerName(recipeId);
        Date time = new Date(System.currentTimeMillis() + (long)this.specification.getTimeout() * 60000L);
        SimpleTrigger timeoutTrigger = new SimpleTrigger(name, TIMEOUT_TRIGGER_GROUP, time);
        timeoutTrigger.setJobName("build");
        timeoutTrigger.setJobGroup(TIMEOUT_TRIGGER_GROUP);
        timeoutTrigger.getJobDataMap().put("BUILD_ID", this.buildResult.getId());
        timeoutTrigger.getJobDataMap().put("RECIPE_ID", recipeId);
        try {
            this.quartzScheduler.scheduleJob((Trigger)timeoutTrigger);
        }
        catch (SchedulerException e) {
            LOG.severe("Unable to schedule build timeout trigger: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkNodeStatus(TreeNode<RecipeController> node) {
        RecipeController controller = (RecipeController)node.getData();
        if (controller.isFinished()) {
            controller.collect(this.buildResult, this.specification.getRetainWorkingCopy());
            this.executingControllers.remove(node);
            RecipeResult result = controller.getResult();
            if (result.succeeded()) {
                this.initialiseNodes(controller.getChildBootstrapper(), node.getChildren());
            } else if (result.failed()) {
                this.buildResult.addFeature(Feature.Level.ERROR, "Recipe " + result.getRecipeNameSafe() + " failed");
            } else if (result.errored()) {
                this.buildResult.addFeature(Feature.Level.ERROR, "Error executing recipe " + result.getRecipeNameSafe());
            }
            this.buildManager.save(this.buildResult);
        }
        if (this.executingControllers.size() == 0) {
            this.completeBuild();
        }
    }

    private void completeBuild() {
        this.buildResult.abortUnfinishedRecipes();
        this.buildResult.setHasWorkDir(this.specification.getRetainWorkingCopy());
        this.buildResult.complete();
        if (!this.request.isPersonal()) {
            if (this.specification.getForceClean()) {
                this.specification.setForceClean(false);
                this.projectManager.save(this.specification);
            }
            for (PostBuildAction action : this.buildResult.getProject().getPostBuildActions()) {
                ComponentContext.autowire((Object)((Object)action));
                action.execute(this.buildResult, null, this.buildProperties);
            }
        }
        this.buildResult.calculateFeatureCounts();
        long start = System.currentTimeMillis();
        this.testManager.index(this.buildResult);
        long duration = System.currentTimeMillis() - start;
        if (duration > 300000L) {
            LOG.warning("Test case indexing for project %s specification %s took %f seconds", new Object[]{this.project.getName(), this.specification.getName(), (double)duration / 1000.0});
        }
        this.buildManager.save(this.buildResult);
        this.tree.cleanup(this.buildResult);
        this.eventManager.unregister((EventListener)this.asyncListener);
        this.eventManager.publish((Event)new BuildCompletedEvent(this, this.buildResult));
        this.asyncListener.stop(true);
    }

    public Class[] getHandledEvents() {
        return new Class[]{BuildCommencedEvent.class, RecipeEvent.class, BuildTerminationRequestEvent.class, RecipeTimeoutEvent.class};
    }

    public long getBuildId() {
        return this.buildResult.getId();
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

