/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.TypesContext;
import com.uwyn.rife.continuations.TypesInstruction;
import com.uwyn.rife.continuations.TypesSuccessor;
import com.uwyn.rife.continuations.asm.Label;
import java.util.ArrayList;
import java.util.Collection;

class TypesNode {
    static final int REGULAR = 0;
    static final int EXCEPTION = 1;
    private ArrayList mInstructions = new ArrayList();
    private TypesNode mFollowingNode = null;
    private boolean mIsSuccessor = false;
    private TypesSuccessor mSuccessors = null;
    private int mLevel = 0;
    private TypesContext mContext = null;
    private boolean mProcessed = false;
    private TypesNode mNextToProcess = null;
    private TypesNode mPreceeder = null;
    private int mSort = 0;

    TypesNode() {
    }

    void addInstruction(TypesInstruction instruction) {
        this.mInstructions.add(instruction);
    }

    Collection getInstructions() {
        return this.mInstructions;
    }

    void setSort(int type) {
        this.mSort = type;
    }

    int getSort() {
        return this.mSort;
    }

    void setFollowingNode(TypesNode followingNode) {
        this.mFollowingNode = followingNode;
    }

    TypesNode getFollowingNode() {
        return this.mFollowingNode;
    }

    void addSuccessor(Label label) {
        TypesSuccessor successor = new TypesSuccessor();
        successor.setLabel(label);
        successor.setNextSuccessor(this.getSuccessors());
        this.setSuccessors(successor);
    }

    void setSuccessors(TypesSuccessor successors) {
        this.mSuccessors = successors;
    }

    TypesSuccessor getSuccessors() {
        return this.mSuccessors;
    }

    void setNextToProcess(TypesNode nextNode) {
        this.mNextToProcess = nextNode;
    }

    TypesNode getNextToProcess() {
        return this.mNextToProcess;
    }

    void setPreceeder(boolean isSuccessor, TypesNode preceeder) {
        this.mIsSuccessor = isSuccessor;
        this.mPreceeder = preceeder;
        this.mLevel = this.mIsSuccessor ? this.mPreceeder.getLevel() + 1 : this.mPreceeder.getLevel();
    }

    TypesNode getPreceeder() {
        return this.mPreceeder;
    }

    boolean getIsSuccessor() {
        return this.mIsSuccessor;
    }

    void setProcessed(boolean processed) {
        this.mProcessed = processed;
    }

    boolean isProcessed() {
        return this.mProcessed;
    }

    void setContext(TypesContext previousContext) {
        this.mContext = previousContext;
    }

    TypesContext getContext() {
        return this.mContext;
    }

    int getLevel() {
        return this.mLevel;
    }
}

