/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ContinuationDebug;
import com.uwyn.rife.continuations.MetricsMethodVisitor;
import com.uwyn.rife.continuations.asm.AnnotationVisitor;
import com.uwyn.rife.continuations.asm.Attribute;
import com.uwyn.rife.continuations.asm.ClassVisitor;
import com.uwyn.rife.continuations.asm.FieldVisitor;
import com.uwyn.rife.continuations.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.logging.Level;

class MetricsClassVisitor
implements ClassVisitor {
    private String mClassName = null;
    private String mEntryMethod = null;
    private int mMaxLocals = -1;
    private int mPauseCount = -1;
    private ArrayList mExceptionTypes = null;

    public MetricsClassVisitor(String className, String entryMethod) {
        this.mClassName = className;
        this.mEntryMethod = entryMethod;
    }

    void setMaxLocals(int maxLocals) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("maxlocals = " + maxLocals);
        }
        this.mMaxLocals = maxLocals;
    }

    int getMaxLocals() {
        return this.mMaxLocals;
    }

    void setPauseCount(int pauseCount) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("pauseCount = " + pauseCount);
        }
        this.mPauseCount = pauseCount;
    }

    void setExceptionTypes(ArrayList exceptionTypes) {
        this.mExceptionTypes = exceptionTypes;
    }

    String nextExceptionType() {
        return (String)this.mExceptionTypes.remove(0);
    }

    int getPauseCount() {
        return this.mPauseCount;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.mEntryMethod.equals(name + desc)) {
            return new MetricsMethodVisitor(this, this.mClassName);
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitEnd() {
    }
}

