/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.CallState;
import com.uwyn.rife.continuations.ContinuableObject;
import com.uwyn.rife.continuations.ContinuationStack;
import com.uwyn.rife.continuations.exceptions.LocalVariableUncloneableException;
import com.uwyn.rife.continuations.util.UniqueIDGenerator;

public class ContinuationContext
implements Cloneable {
    private static ThreadLocal sContext = new ThreadLocal();
    private ContinuableObject mContinuable = null;
    private CallState mCreatedCallState = null;
    private CallState mActiveCallState = null;
    private Object mCallAnswer = null;
    private String mId = null;
    private String result;
    private long mStart = -1L;
    private int mLabel = -1;
    private ContinuationStack mLocalVars = null;
    private ContinuationStack mLocalStack = null;

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public static ContinuationContext getContext() {
        ContinuationContext context = (ContinuationContext)sContext.get();
        if (null == context) {
            System.err.println("BAD");
        } else {
            context.resetStart();
        }
        return context;
    }

    public static ContinuationContext createInstance(ContinuableObject initialContinuable) {
        ContinuationContext context = new ContinuationContext(initialContinuable);
        sContext.set(context);
        return context;
    }

    static String getActiveContextId() {
        ContinuationContext context = (ContinuationContext)sContext.get();
        if (null == context) {
            return null;
        }
        return context.getId();
    }

    static ContinuationContext currentContext() {
        return (ContinuationContext)sContext.get();
    }

    public static void setContext(ContinuationContext context) {
        sContext.set(context);
    }

    private ContinuationContext(ContinuableObject element) {
        this.mContinuable = element;
        this.resetId();
        this.resetStart();
        this.mLabel = -1;
        this.mLocalVars = new ContinuationStack().initialize();
        this.mLocalStack = new ContinuationStack().initialize();
    }

    public void remove() {
    }

    public Object getCallAnswer() {
        return this.mCallAnswer;
    }

    public void setLabel(int label) {
        this.mLabel = label;
    }

    public int getLabel() {
        return this.mLabel;
    }

    public ContinuationStack getLocalVars() {
        return this.mLocalVars;
    }

    public ContinuationStack getLocalStack() {
        return this.mLocalStack;
    }

    boolean isCorrespondingElement(Object elementInfo) {
        return false;
    }

    private void resetStart() {
        this.mStart = System.currentTimeMillis();
    }

    void resetId() {
        this.mId = UniqueIDGenerator.generate().toString();
    }

    public String getId() {
        return this.mId;
    }

    public ContinuableObject getContinuable() {
        return this.mContinuable;
    }

    void setCreatedCallState(CallState createdCallState) {
        this.mCreatedCallState = createdCallState;
    }

    CallState getCreatedCallState() {
        return this.mCreatedCallState;
    }

    void setActiveCallState(CallState callState) {
        this.mActiveCallState = callState;
    }

    CallState getActiveCallState() {
        return this.mActiveCallState;
    }

    long getStart() {
        return this.mStart;
    }

    void setCallAnswer(Object answer) {
        this.mCallAnswer = answer;
    }

    public Object clone() throws CloneNotSupportedException {
        ContinuationContext new_continuationcontext = null;
        try {
            new_continuationcontext = (ContinuationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        new_continuationcontext.mContinuable = (ContinuableObject)this.mContinuable.clone();
        new_continuationcontext.mCallAnswer = null;
        new_continuationcontext.mId = UniqueIDGenerator.generate().toString();
        try {
            new_continuationcontext.mLocalVars = this.mLocalVars.clone(new_continuationcontext.mContinuable);
            new_continuationcontext.mLocalStack = this.mLocalStack.clone(new_continuationcontext.mContinuable);
        }
        catch (CloneNotSupportedException e) {
            throw new LocalVariableUncloneableException(this.mContinuable.getClass().getName(), e.getMessage(), e);
        }
        return new_continuationcontext;
    }
}

