/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ContinuationInstrumentor;
import com.uwyn.rife.continuations.util.ClassByteUtil;
import java.io.IOException;

public class ClassLoaderTests
extends ClassLoader {
    private ClassLoader mParent;
    private String mName;

    public ClassLoaderTests(ClassLoader parent, String name) {
        super(parent);
        this.mParent = parent;
        this.mName = name;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.mName.equals(name) && this.findLoadedClass(name) == null) {
            try {
                byte[] bytes = ClassByteUtil.getBytes(name, this.mParent);
                if (bytes == null) {
                    return super.loadClass(name);
                }
                byte[] resume_bytes = ContinuationInstrumentor.instrument(bytes, name, false);
                if (resume_bytes != null) {
                    bytes = resume_bytes;
                }
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.loadClass(name);
    }
}

