/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.hsqldb.util.ZaurusChoice;
import org.hsqldb.util.ZaurusComponent;
import org.hsqldb.util.ZaurusEditor;
import org.hsqldb.util.ZaurusTextField;

public class ZaurusTableForm
extends ScrollPane
implements TextListener,
ItemListener,
ActionListener {
    Connection cConn;
    DatabaseMetaData dbmeta;
    String tableName;
    ZaurusComponent[] komponente;
    String[] columns;
    short[] columnTypes;
    String[] primaryKeys;
    int[] pkColIndex;
    String[][] importedKeys;
    int[][] imColIndex;
    String[] refTables;
    String[][] refColumns;
    int[][] refColIndex;
    Object[][] resultRowPKs;
    int numberOfResult;
    PreparedStatement pStmt;
    int aktRowNr;

    public ZaurusTableForm(String name, Connection con) {
        this.tableName = name;
        this.cConn = con;
        this.fetchColumns();
        this.fetchPrimaryKeys();
        this.fetchImportedKeys();
        this.initGUI();
    }

    public void cancelChanges() {
        this.showAktRow();
    }

    public int deleteRow() {
        int actionCode;
        String deleteString = "DELETE FROM " + this.tableName + this.generatePKWhere();
        try {
            PreparedStatement ps = this.cConn.prepareStatement(deleteString);
            ps.clearParameters();
            for (int j = 0; j < this.primaryKeys.length; ++j) {
                ps.setObject(j + 1, this.resultRowPKs[this.aktRowNr][j]);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            ZaurusEditor.printStatus("SQL Exception: " + e.getMessage());
            return 0;
        }
        --this.numberOfResult;
        for (int i = this.aktRowNr; i < this.numberOfResult; ++i) {
            for (int j = 0; j < this.primaryKeys.length; ++j) {
                this.resultRowPKs[i][j] = this.resultRowPKs[i + 1][j];
            }
        }
        if (this.numberOfResult == 0) {
            actionCode = 1;
            ZaurusEditor.printStatus("Last row was deleted.");
            return actionCode;
        }
        if (this.numberOfResult == this.aktRowNr) {
            --this.aktRowNr;
            actionCode = this.aktRowNr == 0 ? 2 : 4;
        } else {
            actionCode = this.numberOfResult >= 2 && this.aktRowNr < this.numberOfResult - 1 ? 4 : 3;
        }
        this.showAktRow();
        ZaurusEditor.printStatus("Row was deleted.");
        return actionCode;
    }

    public String getPrimaryKeysString() {
        String result = "";
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            if (result != "") {
                result = result + ", ";
            }
            result = result + this.primaryKeys[i];
        }
        return result;
    }

    public void insertNewRow() {
        int i;
        for (i = 0; i < this.komponente.length; ++i) {
            this.komponente[i].clearContent();
        }
        for (i = 0; i < this.primaryKeys.length; ++i) {
            this.komponente[this.pkColIndex[i]].setEditable(true);
        }
        ZaurusEditor.printStatus("enter a new row for table " + this.tableName);
    }

    public boolean nextRow() {
        if (this.aktRowNr + 1 == this.numberOfResult) {
            return false;
        }
        ++this.aktRowNr;
        this.showAktRow();
        return this.aktRowNr + 1 < this.numberOfResult;
    }

    public boolean prevRow() {
        if (this.aktRowNr == 0) {
            return false;
        }
        --this.aktRowNr;
        this.showAktRow();
        return this.aktRowNr > 0;
    }

    public boolean saveChanges() {
        int[] changedColumns = new int[this.columns.length];
        int countChanged = 0;
        String updateString = "";
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.komponente[i].hasChanged()) continue;
            if (updateString != "") {
                updateString = updateString + ", ";
            }
            updateString = updateString + this.columns[i] + "=?";
            changedColumns[countChanged++] = i;
        }
        if (countChanged > 0) {
            updateString = "UPDATE " + this.tableName + " SET " + updateString + this.generatePKWhere();
            try {
                int i;
                PreparedStatement ps = this.cConn.prepareStatement(updateString);
                ps.clearParameters();
                for (i = 0; i < countChanged; ++i) {
                    ps.setObject(i + 1, this.komponente[changedColumns[i]].getContent());
                }
                for (int j = 0; j < this.primaryKeys.length; ++j) {
                    ps.setObject(i + j + 1, this.resultRowPKs[this.aktRowNr][j]);
                }
                ps.executeUpdate();
                ZaurusEditor.printStatus("changed row was saved to table " + this.tableName);
                return true;
            }
            catch (SQLException e) {
                ZaurusEditor.printStatus("SQL Exception: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean saveNewRow() {
        int tmp;
        boolean onePKempty = false;
        for (tmp = 0; tmp < this.primaryKeys.length; ++tmp) {
            if (!this.komponente[this.pkColIndex[tmp]].getContent().equals("")) continue;
            onePKempty = true;
            break;
        }
        if (onePKempty) {
            this.komponente[this.pkColIndex[tmp]].requestFocus();
            ZaurusEditor.printStatus("no value for primary key " + this.primaryKeys[tmp]);
            return false;
        }
        String insertString = "INSERT INTO " + this.tableName + " VALUES(";
        for (int j = 0; j < this.columns.length; ++j) {
            if (j > 0) {
                insertString = insertString + ", ";
            }
            insertString = insertString + "?";
        }
        insertString = insertString + ")";
        try {
            PreparedStatement ps = this.cConn.prepareStatement(insertString);
            ps.clearParameters();
            for (int i = 0; i < this.columns.length; ++i) {
                ps.setObject(i + 1, this.komponente[i].getContent());
            }
            ps.executeUpdate();
            ZaurusEditor.printStatus("new row was saved to table " + this.tableName);
            return true;
        }
        catch (SQLException e) {
            ZaurusEditor.printStatus("SQL Exception: " + e.getMessage());
            return false;
        }
    }

    public int searchRows(String[] words, boolean allWords, boolean ignoreCase, boolean noMatchWhole) {
        String where = this.generateWhere(words, allWords, ignoreCase, noMatchWhole);
        Vector<Object[]> temp = new Vector<Object[]>(20);
        try {
            Statement stmt = this.cConn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT " + this.getPrimaryKeysString() + " FROM " + this.tableName + where);
            while (rs.next()) {
                Object[] pkValues = new Object[this.primaryKeys.length];
                for (int i = 0; i < this.primaryKeys.length; ++i) {
                    pkValues[i] = rs.getObject(this.pkColIndex[i] + 1);
                }
                temp.addElement(pkValues);
            }
            rs.close();
        }
        catch (SQLException e) {
            ZaurusEditor.printStatus("SQL Exception: " + e.getMessage());
            return -1;
        }
        this.resultRowPKs = new Object[temp.size()][this.primaryKeys.length];
        this.numberOfResult = temp.size();
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            for (int j = 0; j < temp.size(); ++j) {
                this.resultRowPKs[j][i] = ((Object[])temp.elementAt(j))[i];
            }
        }
        String stmtString = "SELECT * FROM " + this.tableName;
        try {
            this.pStmt = this.cConn.prepareStatement(stmtString + this.generatePKWhere());
        }
        catch (SQLException e) {
            System.out.println("SQL Exception: " + e.getMessage());
        }
        if (this.numberOfResult > 0) {
            this.disablePKFields();
            this.aktRowNr = 0;
            this.showAktRow();
        }
        return this.numberOfResult;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void textValueChanged(TextEvent e) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.komponente[i] != e.getSource()) continue;
            this.komponente[i].setChanged();
            break;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.komponente[i] != e.getSource()) continue;
            this.komponente[i].setChanged();
            break;
        }
    }

    private void disablePKFields() {
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            this.komponente[this.pkColIndex[i]].setEditable(false);
        }
    }

    private void fillZChoice(ZaurusChoice zc, String tab, String col) {
        try {
            if (this.cConn == null) {
                return;
            }
            Statement stmt = this.cConn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tab + " ORDER BY " + col);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            int colIndex = rs.findColumn(col);
            while (rs.next()) {
                String tmp = "";
                for (int i = 1; i <= numberOfColumns; ++i) {
                    if (i > 1) {
                        tmp = tmp + "; ";
                    }
                    tmp = tmp + rs.getString(i);
                }
                zc.add(tmp, rs.getString(colIndex));
            }
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("SQL Exception: " + e.getMessage());
        }
    }

    private void fetchColumns() {
        Vector<String> temp = new Vector<String>(20);
        Vector<Short> tempType = new Vector<Short>(20);
        try {
            if (this.cConn == null) {
                return;
            }
            if (this.dbmeta == null) {
                this.dbmeta = this.cConn.getMetaData();
            }
            ResultSet colList = this.dbmeta.getColumns(null, null, this.tableName, "%");
            while (colList.next()) {
                temp.addElement(colList.getString("COLUMN_NAME"));
                tempType.addElement(new Short(colList.getShort("DATA_TYPE")));
            }
            colList.close();
        }
        catch (SQLException e) {
            ZaurusEditor.printStatus("SQL Exception: " + e.getMessage());
        }
        this.columns = new String[temp.size()];
        temp.copyInto(this.columns);
        this.columnTypes = new short[temp.size()];
        for (int i = 0; i < this.columnTypes.length; ++i) {
            this.columnTypes[i] = (Short)tempType.elementAt(i);
        }
    }

    private void fetchImportedKeys() {
        Vector imKeys = new Vector(20);
        Vector<String> imKeyNames = null;
        Vector<String> refTabs = new Vector<String>(20);
        Vector refCols = new Vector(20);
        Vector<String> refColNames = null;
        try {
            if (this.cConn == null) {
                return;
            }
            if (this.dbmeta == null) {
                this.dbmeta = this.cConn.getMetaData();
            }
            ResultSet colList = this.dbmeta.getImportedKeys(null, null, this.tableName);
            while (colList.next()) {
                String pkTable = colList.getString("PKTABLE_NAME");
                String pkColumn = colList.getString("PKCOLUMN_NAME");
                String fkColumn = colList.getString("FKCOLUMN_NAME");
                int keySeq = colList.getInt("KEY_SEQ");
                if (keySeq == 1) {
                    if (imKeyNames != null) {
                        imKeys.addElement(imKeyNames);
                        refCols.addElement(refColNames);
                    }
                    imKeyNames = new Vector<String>(20);
                    refColNames = new Vector<String>(20);
                    refTabs.addElement(pkTable);
                }
                imKeyNames.addElement(fkColumn);
                refColNames.addElement(pkColumn);
            }
            if (imKeyNames != null) {
                imKeys.addElement(imKeyNames);
                refCols.addElement(refColNames);
            }
            colList.close();
        }
        catch (SQLException e) {
            ZaurusEditor.printStatus("SQL Exception: " + e.getMessage());
        }
        int numberOfConstraints = imKeys.size();
        this.importedKeys = new String[numberOfConstraints][];
        this.imColIndex = new int[numberOfConstraints][];
        this.refTables = new String[numberOfConstraints];
        this.refColumns = new String[numberOfConstraints][];
        this.refColIndex = new int[numberOfConstraints][];
        for (int i = 0; i < numberOfConstraints; ++i) {
            Vector keys = (Vector)imKeys.elementAt(i);
            Vector cols = (Vector)refCols.elementAt(i);
            int numberOfKeys = keys.size();
            this.importedKeys[i] = new String[numberOfKeys];
            this.imColIndex[i] = new int[numberOfKeys];
            this.refColumns[i] = new String[numberOfKeys];
            this.refColIndex[i] = new int[numberOfKeys];
            this.refTables[i] = (String)refTabs.elementAt(i);
            for (int j = 0; j < numberOfKeys; ++j) {
                this.importedKeys[i][j] = (String)keys.elementAt(j);
                this.imColIndex[i][j] = this.getColIndex(this.importedKeys[i][j]);
                this.refColumns[i][j] = (String)cols.elementAt(j);
                this.refColIndex[i][j] = this.getColIndex(this.refColumns[i][j], this.refTables[i]);
            }
        }
    }

    private void fetchPrimaryKeys() {
        Vector<String> temp = new Vector<String>(20);
        try {
            if (this.cConn == null) {
                return;
            }
            if (this.dbmeta == null) {
                this.dbmeta = this.cConn.getMetaData();
            }
            ResultSet colList = this.dbmeta.getPrimaryKeys(null, null, this.tableName);
            while (colList.next()) {
                temp.addElement(colList.getString("COLUMN_NAME"));
            }
            colList.close();
        }
        catch (SQLException e) {
            ZaurusEditor.printStatus("SQL Exception: " + e.getMessage());
        }
        this.primaryKeys = new String[temp.size()];
        temp.copyInto(this.primaryKeys);
        this.pkColIndex = new int[this.primaryKeys.length];
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            this.pkColIndex[i] = this.getColIndex(this.primaryKeys[i]);
        }
    }

    private String generatePKWhere() {
        String stmtString = " WHERE ";
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            if (i > 0) {
                stmtString = stmtString + " AND ";
            }
            stmtString = stmtString + this.primaryKeys[i] + "=?";
        }
        return stmtString;
    }

    private String generateWhere(String[] words, boolean allWords, boolean ignoreCase, boolean noMatchWhole) {
        String result = "";
        String join = allWords ? " AND " : " OR ";
        for (int wordInd = 0; wordInd < words.length; ++wordInd) {
            String oneCondition = "";
            for (int col = 0; col < this.columns.length; ++col) {
                if (oneCondition != "") {
                    oneCondition = oneCondition + " OR ";
                }
                if (ignoreCase) {
                    if (noMatchWhole) {
                        oneCondition = oneCondition + "LOWER(" + this.columns[col] + ") LIKE '%" + words[wordInd].toLowerCase() + "%'";
                        continue;
                    }
                    oneCondition = oneCondition + "LOWER(" + this.columns[col] + ") LIKE '" + words[wordInd].toLowerCase() + "'";
                    continue;
                }
                oneCondition = noMatchWhole ? oneCondition + this.columns[col] + " LIKE '%" + words[wordInd] + "%'" : oneCondition + this.columns[col] + " LIKE '" + words[wordInd] + "'";
            }
            if (result != "") {
                result = result + join;
            }
            result = result + "(" + oneCondition + ")";
        }
        if (result != "") {
            result = " WHERE " + result;
        }
        return result;
    }

    private int getColIndex(String name) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!name.equals(this.columns[i])) continue;
            return i;
        }
        return -1;
    }

    private int getColIndex(String colName, String tabName) {
        int ordPos = 0;
        try {
            if (this.cConn == null) {
                return -1;
            }
            if (this.dbmeta == null) {
                this.dbmeta = this.cConn.getMetaData();
            }
            ResultSet colList = this.dbmeta.getColumns(null, null, tabName, colName);
            colList.next();
            ordPos = colList.getInt("ORDINAL_POSITION");
            colList.close();
        }
        catch (SQLException e) {
            System.out.println("SQL Exception: " + e.getMessage());
        }
        return ordPos - 1;
    }

    private int getConstraintIndex(int colIndex) {
        for (int i = 0; i < this.imColIndex.length; ++i) {
            for (int j = 0; j < this.imColIndex[i].length; ++j) {
                if (colIndex != this.imColIndex[i][j]) continue;
                return i;
            }
        }
        return -1;
    }

    private void initGUI() {
        Panel pEntry = new Panel();
        pEntry.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.anchor = 17;
        this.komponente = new ZaurusComponent[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Component tmp;
            c.gridy = i;
            c.gridx = 0;
            pEntry.add((Component)new Label(this.columns[i]), c);
            c.gridx = 1;
            int constraint = this.getConstraintIndex(i);
            if (constraint >= 0 && this.imColIndex[constraint].length == 1) {
                tmp = new ZaurusChoice();
                this.fillZChoice((ZaurusChoice)tmp, this.refTables[constraint], this.refColumns[constraint][0]);
                ((Choice)tmp).addItemListener(this);
                this.komponente[i] = tmp;
                pEntry.add(tmp, c);
            } else if (this.columnTypes[i] == 91) {
                tmp = new ZaurusTextField(8);
                ((TextComponent)tmp).addTextListener(this);
                pEntry.add(tmp, c);
                this.komponente[i] = tmp;
            } else {
                tmp = new ZaurusTextField(5);
                ((TextComponent)tmp).addTextListener(this);
                pEntry.add(tmp, c);
                this.komponente[i] = tmp;
            }
            this.komponente[i].setEditable(true);
        }
        this.add(pEntry);
    }

    private void showAktRow() {
        try {
            this.pStmt.clearParameters();
            for (int i = 0; i < this.primaryKeys.length; ++i) {
                this.pStmt.setObject(i + 1, this.resultRowPKs[this.aktRowNr][i]);
            }
            ResultSet rs = this.pStmt.executeQuery();
            rs.next();
            for (int i = 0; i < this.columns.length; ++i) {
                this.komponente[i].setContent(rs.getString(i + 1));
            }
            rs.close();
        }
        catch (SQLException e) {
            ZaurusEditor.printStatus("SQL Exception: " + e.getMessage());
        }
        for (int i = 0; i < this.columns.length; ++i) {
            this.komponente[i].clearChanges();
        }
    }
}

