/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.hsqldb.util.SqlToolError;

public class SqlFile {
    private static final int DEFAULT_HISTORY_SIZE = 20;
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String chunkPrompt = "raw> ";
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private boolean htmlMode = false;
    private HashMap userVars = null;
    private String[] statementHistory = null;
    private boolean chunking = false;
    private String csvNullRep = null;
    BooleanBucket possiblyUncommitteds = new BooleanBucket();
    private static final int SEP_LEN = 2;
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String SPACES = "                                                                                                                                  ";
    private static String revnum = null;
    private static String BANNER;
    private static final String BUFFER_HELP_TEXT = "BUFFER Commands (only \":;\" is available for non-interactive use).\n    :?                Help\n    :;                Execute current buffer as an SQL Statement\n    :a[text]          Enter append mode with a copy of the buffer\n    :l                List current contents of buffer\n    :s/from/to        Substitute \"to\" for first occurrence of \"from\"\n    :s/from/to/[i;g2] Substitute \"to\" for occurrence(s) of \"from\"\n                from:  '$'s represent line breaks\n                to:    If empty, from's will be deleted (e.g. \":s/x//\").\n                       '$'s represent line breaks\n                       You can't use ';' in order to execute the SQL (use\n                       the ';' switch for this purpose, as explained below).\n                /:     Can actually be any character which occurs in\n                       neither \"to\" string nor \"from\" string.\n                SUBSTITUTION MODE SWITCHES:\n                       i:  case Insensitive\n                       ;:  execute immediately after substitution\n                       g:  Global (substitute ALL occurrences of \"from\" string)\n                       2:  Narrows substitution to specified buffer line number\n                           (Use any line number in place of '2').\n";
    private static final String HELP_TEXT = "SPECIAL Commands.\n* commands only available for interactive use.\nIn place of \"3\" below, you can use nothing for the previous command, or\nan integer \"X\" to indicate the Xth previous command.\nFilter substrings are cases-sensitive!  Use \"SCHEMANAME.\" to narrow schema.\n    \\?                   Help\n    \\p [line to print]   Print string to stdout\n    \\w file/path.sql     Append current buffer to file\n    \\i file/path.sql     Include/execute commands from external file\n    \\d{tvsiSanur*} [substr]  List objects of specified type:\n  (Tbls/Views/Seqs/Indexes/SysTbls/Aliases/schemaNames/Users/Roles/table-like)\n    \\d OBJECTNAME [subs] Describe table or view columns\n    \\o [file/path.html]  Tee (or stop teeing) query output to specified file\n    \\H                   Toggle HTML output mode\n    \\! COMMAND ARGS      Execute external program (no support for stdin)\n    \\c [true|false]      Continue upon errors (a.o.t. abort upon error)\n    \\a [true|false]      Auto-commit JDBC DML commands\n    \\b                   save next result to Binary buffer (no display)\n    \\bd file/path.bin    Dump Binary buffer to file\n    \\bl file/path.bin    Load file into Binary buffer\n    \\bp                  Use ? in next SQL statement to upload Bin. buffer\n    \\.                   Enter raw SQL.  End with line containing only \".\"\n    \\s                   * Show previous commands (i.e. SQL command history)\n    \\-[3][;]             * reload a command to buffer (opt. exec. w/ \":;\"))\n    \\x {TABLE|SELECT...} eXport table or query to CSV text file\n    \\m file/path.csv     iMport CSV text file records into a table\n    \\q [abort message]   Quit (or end input like Ctrl-Z or Ctrl-D)\n";
    private static final String PL_HELP_TEXT = "PROCEDURAL LANGUAGE Commands.\n    *?                            Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value\n    * VARNAME =                   Unset variable\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * VARNAME _                   Same as * VARNAME _, except the query is\n                                  done silently (i.e, no rows to screen)\n    * list[value] [VARNAME1...]   List variable(s) (defaults to all)\n    * load VARNAME path.txt       Load variable value from text file\n    * dump VARNAME path.txt       Dump variable value to text file\n    * prepare VARNAME             Use ? in next SQL statement to upload val.\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may use /VARNAME instead iff /VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n'* VARNAME ~' or '* VARNAME _' sets the variable value according to the very\nnext SQL statement (~ will echo the value, _ will do it silently):\n    Query:  The value of the first field of the first row returned.\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n";
    public boolean recursed = false;
    private String curCommand = null;
    private int curLinenum = -1;
    private int curHist = -1;
    private PrintStream psStd = null;
    private PrintStream psErr = null;
    private PrintWriter pwQuery = null;
    private PrintWriter pwCsv = null;
    StringBuffer stringBuffer = new StringBuffer();
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private BufferedReader br = null;
    private String charset = null;
    private boolean doPrepare = false;
    private String prepareVar = null;
    private String csvColDelim = null;
    private String csvRowDelim = null;
    private static final String CSV_SYNTAX_MSG = "Export syntax:  x table_or_view_anme [column_delimiter [record_delimiter]]";
    private static final char[] nonVarChars;
    public boolean plMode = false;
    private String fetchingVar = null;
    private boolean silentFetch = false;
    private boolean fetchBinary = false;
    private static final String DEFAULT_NULL_REP = "[null]";
    private static final String DEFAULT_ROW_DELIM;
    private static final String DEFAULT_COL_DELIM = "|";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas = false;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR;
    private static final String PRE_TD;
    byte[] binBuffer = null;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    public SqlFile(File inFile, boolean inInteractive, HashMap inVars) throws IOException {
        this.file = inFile;
        this.interactive = inInteractive;
        this.userVars = inVars;
        try {
            this.statementHistory = new String[this.interactive ? Integer.parseInt(System.getProperty("sqltool.historyLength")) : 1];
        }
        catch (Throwable t) {
            this.statementHistory = null;
        }
        if (this.statementHistory == null) {
            this.statementHistory = new String[20];
        }
        if (this.file != null && !this.file.canRead()) {
            throw new IOException("Can't read SQL file '" + this.file + "'");
        }
    }

    public SqlFile(boolean inInteractive, HashMap inVars) throws IOException {
        this(null, inInteractive, inVars);
    }

    public void execute(Connection conn, Boolean coeOverride) throws IOException, SqlToolError, SQLException {
        this.execute(conn, System.out, System.err, coeOverride);
    }

    public void execute(Connection conn, boolean coeOverride) throws IOException, SqlToolError, SQLException {
        this.execute(conn, System.out, System.err, new Boolean(coeOverride));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Connection conn, PrintStream stdIn, PrintStream errIn, Boolean coeOverride) throws IOException, SqlToolError, SQLException {
        String specifiedCharSet;
        this.psStd = stdIn;
        this.psErr = errIn;
        this.curConn = conn;
        this.curLinenum = -1;
        boolean inComment = false;
        boolean gracefulExit = false;
        boolean bl = this.continueOnError = coeOverride == null ? this.interactive : coeOverride;
        if (this.userVars != null && this.userVars.size() > 0) {
            this.plMode = true;
        }
        this.charset = (specifiedCharSet = System.getProperty("sqlfile.charset")) == null ? DEFAULT_CHARSET : specifiedCharSet;
        try {
            this.br = new BufferedReader(new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file), this.charset));
            this.curLinenum = 0;
            if (this.interactive) {
                this.stdprintln(BANNER);
            }
            while (true) {
                block51: {
                    String msg;
                    int postCommentIndex;
                    String inputLine;
                    if (this.interactive) {
                        this.psStd.print(this.stringBuffer.length() == 0 ? (this.chunking ? this.chunkPrompt : this.primaryPrompt) : this.contPrompt);
                    }
                    if ((inputLine = this.br.readLine()) == null) {
                        if (!this.interactive) break;
                        this.psStd.println();
                        break;
                    }
                    ++this.curLinenum;
                    if (this.chunking) {
                        if (inputLine.equals(".")) {
                            this.chunking = false;
                            this.setBuf(this.stringBuffer.toString());
                            this.stringBuffer.setLength(0);
                            if (!this.interactive) continue;
                            this.stdprintln("Raw SQL chunk moved into buffer.  Run \":;\" to execute the chunk.");
                            continue;
                        }
                        if (this.stringBuffer.length() > 0) {
                            this.stringBuffer.append('\n');
                        }
                        this.stringBuffer.append(inputLine);
                        continue;
                    }
                    if (inComment) {
                        postCommentIndex = inputLine.indexOf("*/") + 2;
                        if (postCommentIndex <= 1) continue;
                        inputLine = inputLine.substring(postCommentIndex);
                        this.stringBuffer.setLength(0);
                        inComment = false;
                    }
                    String trimmedInput = inputLine.trim();
                    try {
                        if (this.stringBuffer.length() == 0) {
                            if (trimmedInput.startsWith("/*")) {
                                postCommentIndex = trimmedInput.indexOf("*/", 2) + 2;
                                if (postCommentIndex > 1) {
                                    inputLine = inputLine.substring(postCommentIndex + inputLine.length() - trimmedInput.length());
                                    trimmedInput = inputLine.trim();
                                } else {
                                    this.stringBuffer.append("COMMENT");
                                    inComment = true;
                                    continue;
                                }
                            }
                            if (trimmedInput.length() == 0) continue;
                            if (trimmedInput.charAt(0) == '*' && (trimmedInput.length() < 2 || trimmedInput.charAt(1) != '{')) {
                                try {
                                    this.processPL(trimmedInput.length() == 1 ? "" : trimmedInput.substring(1).trim());
                                    continue;
                                }
                                catch (BadSpecial bs) {
                                    this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + inputLine + "\"\n" + bs.getMessage());
                                    if (this.continueOnError) continue;
                                    throw new SqlToolError(bs);
                                }
                            }
                            if (trimmedInput.charAt(0) == '\\') {
                                try {
                                    this.processSpecial(trimmedInput.substring(1));
                                    continue;
                                }
                                catch (BadSpecial bs) {
                                    this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + inputLine + "\"\n" + bs.getMessage());
                                    if (this.continueOnError) continue;
                                    throw new SqlToolError(bs);
                                }
                            }
                            if (trimmedInput.charAt(0) == ':' && (this.interactive || trimmedInput.charAt(1) == ';')) {
                                try {
                                    this.processBuffer(trimmedInput.substring(1));
                                    continue;
                                }
                                catch (BadSpecial bs) {
                                    this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + inputLine + "\"\n" + bs.getMessage());
                                    if (this.continueOnError) continue;
                                    throw new SqlToolError(bs);
                                }
                            }
                            String ucased = trimmedInput.toUpperCase();
                            if (ucased.startsWith("DECLARE") || ucased.startsWith("BEGIN")) {
                                this.chunking = true;
                                this.stringBuffer.append(inputLine);
                                if (!this.interactive) continue;
                                this.stdprintln("Enter RAW SQL.  No \\, :, * commands.  End with a line containing only \".\":");
                                continue;
                            }
                        }
                        if (trimmedInput.length() == 0) {
                            if (!this.interactive || inComment) continue;
                            this.setBuf(this.stringBuffer.toString());
                            this.stringBuffer.setLength(0);
                            this.stdprintln("Current input moved into buffer.");
                            continue;
                        }
                        String deTerminated = SqlFile.deTerminated(inputLine);
                        if (!trimmedInput.equals(";")) {
                            if (this.stringBuffer.length() > 0) {
                                this.stringBuffer.append('\n');
                            }
                            this.stringBuffer.append(deTerminated == null ? inputLine : deTerminated);
                        }
                        if (deTerminated == null) continue;
                        this.curCommand = this.stringBuffer.toString();
                        String trimmedCommand = this.curCommand.trim();
                        if (trimmedCommand.length() == 0) {
                            throw new SQLException("Empty SQL Statement");
                        }
                        this.setBuf(this.curCommand);
                        this.processSQL();
                    }
                    catch (SQLException se) {
                        this.errprintln("SQL Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + this.curCommand + "\"\n" + se.getMessage());
                        if (!this.continueOnError) {
                            throw se;
                        }
                    }
                    catch (BreakException be) {
                        msg = be.getMessage();
                        if (!this.recursed && msg != null && !msg.equals("file")) {
                            this.errprintln("Unsatisfied break statement" + (msg == null ? "" : " (type " + msg + ')') + '.');
                        } else {
                            gracefulExit = true;
                        }
                        if (this.recursed || !this.continueOnError) {
                            throw be;
                        }
                    }
                    catch (ContinueException ce) {
                        msg = ce.getMessage();
                        if (!this.recursed) {
                            this.errprintln("Unsatisfied continue statement" + (msg == null ? "" : " (type " + msg + ')') + '.');
                        } else {
                            gracefulExit = true;
                        }
                        if (this.recursed || !this.continueOnError) {
                            throw ce;
                        }
                    }
                    catch (QuitNow qn) {
                        throw qn;
                    }
                    catch (SqlToolError ste) {
                        if (this.continueOnError) break block51;
                        throw ste;
                    }
                }
                this.stringBuffer.setLength(0);
            }
            if (inComment || this.stringBuffer.length() != 0) {
                this.errprintln("Unterminated input:  [" + this.stringBuffer + ']');
                throw new SqlToolError("Unterminated input:  [" + this.stringBuffer + ']');
            }
            gracefulExit = true;
        }
        catch (QuitNow qn) {
            boolean bl2 = gracefulExit = qn.getMessage() == null;
            if (!this.recursed && !gracefulExit) {
                this.errprintln("Aborting: " + qn.getMessage());
            }
            if (this.recursed || !gracefulExit) {
                throw qn;
            }
            return;
        }
        finally {
            this.closeQueryOutputStream();
            if (this.fetchingVar != null) {
                this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                gracefulExit = false;
            }
            if (this.br != null) {
                this.br.close();
            }
            if (!gracefulExit && this.possiblyUncommitteds.get()) {
                this.errprintln("Rolling back SQL transaction.");
                this.curConn.rollback();
                this.possiblyUncommitteds.set(false);
            }
        }
    }

    private static String deTerminated(String inString) {
        int index = inString.lastIndexOf(59);
        if (index < 0) {
            return null;
        }
        for (int i = index + 1; i < inString.length(); ++i) {
            if (Character.isWhitespace(inString.charAt(i))) continue;
            return null;
        }
        return inString.substring(0, index);
    }

    private void processBuffer(String inString) throws BadSpecial, SQLException {
        boolean index = false;
        int commandChar = 105;
        String other = null;
        if (inString.length() > 0) {
            commandChar = inString.charAt(0);
            other = inString.substring(1);
            if (other.trim().length() == 0) {
                other = null;
            }
        }
        switch (commandChar) {
            case 59: {
                this.curCommand = this.commandFromHistory(0);
                this.stdprintln("Executing command from buffer:\n" + this.curCommand + '\n');
                this.processSQL();
                return;
            }
            case 65: 
            case 97: {
                this.stringBuffer.append(this.commandFromHistory(0));
                if (other != null) {
                    String deTerminated = SqlFile.deTerminated(other);
                    if (!other.equals(";")) {
                        this.stringBuffer.append(deTerminated == null ? other : deTerminated);
                    }
                    if (deTerminated != null) {
                        this.curCommand = this.stringBuffer.toString();
                        this.setBuf(this.curCommand);
                        this.stdprintln("Executing:\n" + this.curCommand + '\n');
                        this.processSQL();
                        this.stringBuffer.setLength(0);
                        return;
                    }
                }
                this.stdprintln("Appending to:\n" + this.stringBuffer);
                return;
            }
            case 76: 
            case 108: {
                this.stdprintln("Current Buffer:\n" + this.commandFromHistory(0));
                return;
            }
            case 83: 
            case 115: {
                boolean modeIC = false;
                boolean modeGlobal = false;
                boolean modeExecute = false;
                int modeLine = 0;
                try {
                    int i;
                    String fromHist = this.commandFromHistory(0);
                    StringBuffer sb = new StringBuffer(fromHist);
                    if (other == null) {
                        throw new BadSwitch(0);
                    }
                    String delim = other.substring(0, 1);
                    StringTokenizer toker = new StringTokenizer(other, delim, true);
                    if (toker.countTokens() < 4 || !toker.nextToken().equals(delim)) {
                        throw new BadSwitch(1);
                    }
                    String from = toker.nextToken().replace('$', '\n');
                    if (!toker.nextToken().equals(delim)) {
                        throw new BadSwitch(2);
                    }
                    String to = toker.nextToken().replace('$', '\n');
                    if (to.equals(delim)) {
                        to = "";
                    } else if (toker.countTokens() > 0 && !toker.nextToken().equals(delim)) {
                        throw new BadSwitch(3);
                    }
                    if (toker.countTokens() > 0) {
                        String opts = toker.nextToken("");
                        block15: for (int j = 0; j < opts.length(); ++j) {
                            switch (opts.charAt(j)) {
                                case 'i': {
                                    modeIC = true;
                                    continue block15;
                                }
                                case ';': {
                                    modeExecute = true;
                                    continue block15;
                                }
                                case 'g': {
                                    modeGlobal = true;
                                    continue block15;
                                }
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    modeLine = Character.digit(opts.charAt(j), 10);
                                    continue block15;
                                }
                                default: {
                                    throw new BadSpecial("Unknown Substitution option: " + opts.charAt(j));
                                }
                            }
                        }
                    }
                    if (modeIC) {
                        fromHist = fromHist.toUpperCase();
                        from = from.toUpperCase();
                    }
                    int lineStart = 0;
                    int lineStop = -1;
                    if (modeLine > 0) {
                        for (int j = 1; j < modeLine; ++j) {
                            if ((lineStart = fromHist.indexOf(10, lineStart) + 1) >= 1) continue;
                            throw new BadSpecial("There are not " + modeLine + " lines in the buffer.");
                        }
                        lineStop = fromHist.indexOf(10, lineStart);
                    }
                    if (lineStop < 0) {
                        lineStop = fromHist.length();
                    }
                    if (modeGlobal) {
                        i = lineStop;
                        while ((i = fromHist.lastIndexOf(from, i - 1)) >= lineStart) {
                            sb.replace(i, i + from.length(), to);
                        }
                    } else {
                        i = fromHist.indexOf(from, lineStart);
                        if (i > -1 && i < lineStop) {
                            sb.replace(i, i + from.length(), to);
                        }
                    }
                    this.curCommand = sb.toString();
                    this.setBuf(this.curCommand);
                    this.stdprintln((modeExecute ? "Executing" : "Current Buffer") + ":\n" + this.curCommand);
                    if (modeExecute) {
                        this.stdprintln();
                    }
                }
                catch (BadSwitch badswitch) {
                    throw new BadSpecial("Substitution syntax:  \":s/from this/to that/i;g2\".  Use '$' for line separations.  [" + badswitch.getMessage() + ']');
                }
                if (modeExecute) {
                    this.processSQL();
                    this.stringBuffer.setLength(0);
                }
                return;
            }
            case 63: {
                this.stdprintln(BUFFER_HELP_TEXT);
                return;
            }
        }
        throw new BadSpecial("Unknown Buffer Command");
    }

    private void processSpecial(String inString) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        boolean index = false;
        String other = null;
        if (inString.length() < 1) {
            throw new BadSpecial("Null special command");
        }
        if (this.plMode) {
            inString = this.dereference(inString, false);
        }
        StringTokenizer toker = new StringTokenizer(inString);
        String arg1 = toker.nextToken();
        if (toker.hasMoreTokens()) {
            other = toker.nextToken("").trim();
        }
        switch (arg1.charAt(0)) {
            case 'q': {
                if (other != null) {
                    throw new QuitNow(other);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.htmlMode = !this.htmlMode;
                this.stdprintln("HTML Mode is now set to: " + this.htmlMode);
                return;
            }
            case 'm': {
                if (arg1.length() != 1 || other == null) {
                    throw new BadSpecial();
                }
                this.csvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
                this.csvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
                this.csvNullRep = (String)this.userVars.get("*CSV_NULL_REP");
                if (this.csvColDelim == null) {
                    this.csvColDelim = DEFAULT_COL_DELIM;
                }
                if (this.csvRowDelim == null) {
                    this.csvRowDelim = DEFAULT_ROW_DELIM;
                }
                if (this.csvNullRep == null) {
                    this.csvNullRep = DEFAULT_NULL_REP;
                }
                try {
                    this.importCsv(other);
                }
                catch (IOException ioe) {
                    System.err.println("Failed to read in CSV file:  " + ioe);
                }
                return;
            }
            case 'x': {
                try {
                    if (arg1.length() != 1 || other == null) {
                        throw new BadSpecial();
                    }
                    String tableName = other.indexOf(32) > 0 ? null : other;
                    this.csvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
                    this.csvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
                    this.csvNullRep = (String)this.userVars.get("*CSV_NULL_REP");
                    String csvFilepath = (String)this.userVars.get("*CSV_FILEPATH");
                    if (csvFilepath == null && tableName == null) {
                        throw new BadSpecial("You must set PL variable '*CSV_FILEPATH' in order to use the query variant of \\x");
                    }
                    File csvFile = new File(csvFilepath == null ? tableName + ".csv" : csvFilepath);
                    if (this.csvColDelim == null) {
                        this.csvColDelim = DEFAULT_COL_DELIM;
                    }
                    if (this.csvRowDelim == null) {
                        this.csvRowDelim = DEFAULT_ROW_DELIM;
                    }
                    if (this.csvNullRep == null) {
                        this.csvNullRep = DEFAULT_NULL_REP;
                    }
                    this.pwCsv = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), this.charset));
                    this.displayResultSet(null, this.curConn.createStatement().executeQuery(tableName == null ? other : "SELECT * FROM " + tableName), null, null);
                    this.pwCsv.flush();
                    this.stdprintln("Wrote " + csvFile.length() + " characters to file '" + csvFile + "'");
                }
                catch (Exception e) {
                    if (e instanceof BadSpecial) {
                        if (e.getMessage() == null) {
                            throw new BadSpecial(CSV_SYNTAX_MSG);
                        }
                        throw (BadSpecial)e;
                    }
                    throw new BadSpecial("Failed to write to file '" + other + "':  " + e);
                }
                finally {
                    if (this.pwCsv != null) {
                        this.pwCsv.close();
                    }
                    this.pwCsv = null;
                    this.csvColDelim = null;
                    this.csvRowDelim = null;
                }
                return;
            }
            case 'd': {
                if (arg1.length() == 2) {
                    this.listTables(arg1.charAt(1), other);
                    return;
                }
                if (arg1.length() == 1 && other != null) {
                    int space = other.indexOf(32);
                    if (space < 0) {
                        this.describe(other, null);
                    } else {
                        this.describe(other.substring(0, space), other.substring(space + 1).trim());
                    }
                    return;
                }
                throw new BadSpecial("Describe commands must be like '\\dX' or like '\\d OBJECTNAME'.");
            }
            case 'o': {
                if (other == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial("There is no query output file to close");
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln("Closing current query output file and opening new one");
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(other, true), this.charset));
                    this.pwQuery.println((this.htmlMode ? "<HTML>\n<!--" : "#") + " " + new Date() + ".  Query output from " + this.getClass().getName() + (this.htmlMode ? ". -->\n\n<BODY>" : ".\n"));
                    this.pwQuery.flush();
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to write to file '" + other + "':  " + e);
                }
                return;
            }
            case 'w': {
                if (other == null) {
                    throw new BadSpecial("You must supply a destination file name");
                }
                if (this.commandFromHistory(0).length() == 0) {
                    throw new BadSpecial("Empty command in buffer");
                }
                try {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(other, true), this.charset));
                    pw.println(this.commandFromHistory(0) + ';');
                    pw.flush();
                    pw.close();
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to append to file '" + other + "':  " + e);
                }
                return;
            }
            case 'i': {
                if (other == null) {
                    throw new BadSpecial("You must supply an SQL file name");
                }
                try {
                    SqlFile sf = new SqlFile(new File(other), false, this.userVars);
                    sf.recursed = true;
                    sf.possiblyUncommitteds = this.possiblyUncommitteds;
                    sf.plMode = this.plMode;
                    sf.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException ce) {
                    throw ce;
                }
                catch (BreakException be) {
                    String beMessage = be.getMessage();
                    if (beMessage != null && !beMessage.equals("file")) {
                        throw be;
                    }
                }
                catch (QuitNow qe) {
                    throw qe;
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to execute SQL from file '" + other + "':  " + e.getMessage());
                }
                return;
            }
            case 'p': {
                if (other == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(other, true);
                }
                return;
            }
            case 'a': {
                if (other != null) {
                    this.curConn.setAutoCommit(Boolean.valueOf(other));
                }
                this.stdprintln("Auto-commit is set to: " + this.curConn.getAutoCommit());
                return;
            }
            case 'b': {
                if (arg1.length() == 1) {
                    this.fetchBinary = true;
                    return;
                }
                if (arg1.charAt(1) == 'p') {
                    this.doPrepare = true;
                    return;
                }
                if (arg1.charAt(1) != 'd' && arg1.charAt(1) != 'l' || other == null) {
                    throw new BadSpecial("Malformatted binary command");
                }
                File file = new File(other);
                try {
                    if (arg1.charAt(1) == 'd') {
                        this.dump(file);
                    } else {
                        this.load(file);
                    }
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to load/dump binary  data to file '" + other + "'");
                }
                return;
            }
            case '*': 
            case 'c': {
                if (other != null) {
                    this.continueOnError = Boolean.valueOf(other);
                }
                this.stdprintln("Continue-on-error is set to: " + this.continueOnError);
                return;
            }
            case 's': {
                this.showHistory();
                return;
            }
            case '-': {
                String numStr;
                boolean executeMode;
                int commandsAgo = 0;
                boolean bl = executeMode = arg1.charAt(arg1.length() - 1) == ';';
                if (executeMode) {
                    arg1 = arg1.substring(0, arg1.length() - 1);
                }
                String string = numStr = arg1.length() == 1 ? null : arg1.substring(1, arg1.length());
                if (numStr == null) {
                    commandsAgo = 0;
                } else {
                    try {
                        commandsAgo = Integer.parseInt(numStr);
                    }
                    catch (NumberFormatException nfe) {
                        throw new BadSpecial("Malformatted command number");
                    }
                }
                this.setBuf(this.commandFromHistory(commandsAgo));
                if (executeMode) {
                    this.processBuffer(";");
                } else {
                    this.stdprintln("RESTORED following command to buffer.  Enter \":?\" to see buffer commands:\n" + this.commandFromHistory(0));
                }
                return;
            }
            case '?': {
                this.stdprintln(HELP_TEXT);
                return;
            }
            case '!': {
                byte[] ba = new byte[1024];
                String extCommand = (arg1.length() == 1 ? "" : arg1.substring(1)) + (arg1.length() > 1 && other != null ? " " : "") + (other == null ? "" : other);
                try {
                    int i;
                    Process proc = Runtime.getRuntime().exec(extCommand);
                    proc.getOutputStream().close();
                    InputStream stream = proc.getInputStream();
                    while ((i = stream.read(ba)) > 0) {
                        this.stdprint(new String(ba, 0, i));
                    }
                    stream.close();
                    stream = proc.getErrorStream();
                    while ((i = stream.read(ba)) > 0) {
                        this.errprint(new String(ba, 0, i));
                    }
                    stream.close();
                    if (proc.waitFor() != 0) {
                        throw new BadSpecial("External command failed: '" + extCommand + "'");
                    }
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to execute command '" + extCommand + "':  " + e);
                }
                return;
            }
            case '.': {
                this.chunking = true;
                if (this.interactive) {
                    this.stdprintln("Enter RAW SQL.  No \\, :, * commands.  End with a line containing only \".\":");
                }
                return;
            }
        }
        throw new BadSpecial("Unknown Special Command");
    }

    static int pastName(String inString, int startIndex) {
        String workString = inString.substring(startIndex);
        int e = inString.length();
        for (int i = 0; i < nonVarChars.length; ++i) {
            int nonVarIndex = workString.indexOf(nonVarChars[i]);
            if (nonVarIndex <= -1 || nonVarIndex >= e) continue;
            e = nonVarIndex;
        }
        return startIndex + e;
    }

    private String dereference(String inString, boolean permitAlias) throws SQLException {
        String s;
        int b;
        String varName;
        int e;
        StringBuffer expandBuffer = new StringBuffer(inString);
        if (permitAlias && inString.trim().charAt(0) == '/') {
            int slashIndex = inString.indexOf(47);
            e = SqlFile.pastName(inString.substring(slashIndex + 1), 0);
            if (e < 1) {
                throw new SQLException("Malformed PL alias use");
            }
            varName = inString.substring(slashIndex + 1, slashIndex + 1 + e);
            String varValue = (String)this.userVars.get(varName);
            if (varValue == null) {
                throw new SQLException("Undefined PL variable:  " + varName);
            }
            expandBuffer.replace(slashIndex, slashIndex + 1 + e, (String)this.userVars.get(varName));
        }
        while ((b = (s = expandBuffer.toString()).indexOf("*{")) >= 0) {
            e = s.indexOf(125, b + 2);
            if (e == b + 2) {
                throw new SQLException("Empty PL variable name");
            }
            if (e < 0) {
                throw new SQLException("Unterminated PL variable name");
            }
            varName = s.substring(b + 2, e);
            if (!this.userVars.containsKey(varName)) {
                throw new SQLException("Use of undefined PL variable: " + varName);
            }
            expandBuffer.replace(b, e + 1, (String)this.userVars.get(varName));
        }
        return expandBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPL(String inString) throws BadSpecial, SqlToolError, SQLException {
        block72: {
            block73: {
                if (inString.length() < 1) {
                    this.plMode = true;
                    this.stdprintln("PL variable expansion mode is now on");
                    return;
                }
                if (inString.charAt(0) == '?') {
                    this.stdprintln("PROCEDURAL LANGUAGE Commands.\n    *?                            Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value\n    * VARNAME =                   Unset variable\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * VARNAME _                   Same as * VARNAME _, except the query is\n                                  done silently (i.e, no rows to screen)\n    * list[value] [VARNAME1...]   List variable(s) (defaults to all)\n    * load VARNAME path.txt       Load variable value from text file\n    * dump VARNAME path.txt       Dump variable value to text file\n    * prepare VARNAME             Use ? in next SQL statement to upload val.\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may use /VARNAME instead iff /VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n'* VARNAME ~' or '* VARNAME _' sets the variable value according to the very\nnext SQL statement (~ will echo the value, _ will do it silently):\n    Query:  The value of the first field of the first row returned.\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n");
                    return;
                }
                if (this.plMode) {
                    inString = this.dereference(inString, false);
                }
                toker = new StringTokenizer(inString);
                arg1 = toker.nextToken();
                tokenArray = null;
                this.plMode = true;
                if (this.userVars == null) {
                    this.userVars = new HashMap<K, V>();
                }
                if (arg1.equals("end")) {
                    throw new BadSpecial("PL end statements may only occur inside of a PL block");
                }
                if (arg1.equals("continue")) {
                    if (toker.hasMoreTokens() == false) throw new ContinueException();
                    s = toker.nextToken("").trim();
                    if (s.equals("foreach") != false) throw new ContinueException(s);
                    if (s.equals("while") == false) throw new BadSpecial("Bad continue statement.You may use no argument or one of 'foreach', 'while'");
                    throw new ContinueException(s);
                }
                if (arg1.equals("break")) {
                    if (toker.hasMoreTokens() == false) throw new BreakException();
                    s = toker.nextToken("").trim();
                    if (s.equals("foreach") != false) throw new BreakException(s);
                    if (s.equals("if") != false) throw new BreakException(s);
                    if (s.equals("while") != false) throw new BreakException(s);
                    if (s.equals("file") == false) throw new BadSpecial("Bad break statement.You may use no argument or one of 'foreach', 'if', 'while', 'file'");
                    throw new BreakException(s);
                }
                if (!arg1.equals("list") && !arg1.equals("listvalue")) break block73;
                doValues = arg1.equals("listvalue");
                if (toker.countTokens() == 0) {
                    this.stdprint(SqlFile.formatNicely(this.userVars, doValues));
                    return;
                }
                tokenArray = SqlFile.getTokenArray(toker.nextToken(""));
                if (doValues) {
                    this.stdprintln("The outermost parentheses are not part of the values.");
                    break block72;
                } else {
                    this.stdprintln("Showing variable names and length of values (use 'listvalue' to see values).");
                }
                break block72;
            }
            if (arg1.equals("dump") || arg1.equals("load")) {
                if (toker.countTokens() != 2) {
                    throw new BadSpecial("Malformatted PL dump/load command");
                }
                varName = toker.nextToken();
                file = new File(toker.nextToken());
                try {
                    if (arg1.equals("dump")) {
                        this.dump(varName, file);
                        return;
                    }
                    this.load(varName, file);
                    return;
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to dump/load variable '" + varName + "' to file '" + file + "'");
                }
            }
            if (arg1.equals("prepare")) {
                if (toker.countTokens() != 1) {
                    throw new BadSpecial("Malformatted prepare command");
                }
                s = toker.nextToken();
                if (this.userVars.get(s) == null) {
                    throw new SQLException("Use of unset PL variable: " + s);
                }
                this.prepareVar = s;
                this.doPrepare = true;
                return;
            }
            if (arg1.equals("foreach")) {
                if (toker.countTokens() < 2) {
                    throw new BadSpecial("Malformatted PL foreach command (1)");
                }
                varName = toker.nextToken();
                parenExpr = toker.nextToken("").trim();
                if (parenExpr.length() < 2) throw new BadSpecial("Malformatted PL foreach command (2)");
                if (parenExpr.charAt(0) != '(') throw new BadSpecial("Malformatted PL foreach command (2)");
                if (parenExpr.charAt(parenExpr.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL foreach command (2)");
                }
                values = SqlFile.getTokenArray(parenExpr.substring(1, parenExpr.length() - 1));
                tmpFile = null;
                try {
                    tmpFile = this.plBlockFile("foreach");
                }
                catch (IOException ioe) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + ioe);
                }
                origval = (String)this.userVars.get(varName);
                try {
                    for (i = 0; i < values.length; ++i) {
                        try {
                            varVal = values[i];
                            this.userVars.put(varName, varVal);
                            sf = new SqlFile(tmpFile, false, this.userVars);
                            sf.plMode = true;
                            sf.recursed = true;
                            sf.possiblyUncommitteds = this.possiblyUncommitteds;
                            sf.execute(this.curConn, this.continueOnError);
                            continue;
                        }
                        catch (ContinueException ce) {
                            ceMessage = ce.getMessage();
                            if (ceMessage == null || ceMessage.equals("foreach")) continue;
                            throw ce;
                        }
                    }
                }
                catch (BreakException be) {
                    beMessage = be.getMessage();
                    if (beMessage != null && !beMessage.equals("foreach")) {
                        throw be;
                    }
                }
                catch (QuitNow qe) {
                    throw qe;
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + e.getMessage());
                }
                if (origval == null) {
                    this.userVars.remove(varName);
                } else {
                    this.userVars.put(varName, origval);
                }
                if (tmpFile == null) return;
                if (tmpFile.delete() != false) return;
                throw new BadSpecial("Error occurred while trying to remove temp file '" + tmpFile + "'");
            }
            if (arg1.equals("if")) {
                if (toker.countTokens() < 1) {
                    throw new BadSpecial("Malformatted PL if command (1)");
                }
                parenExpr = toker.nextToken("").trim();
                if (parenExpr.length() < 2) throw new BadSpecial("Malformatted PL if command (2)");
                if (parenExpr.charAt(0) != '(') throw new BadSpecial("Malformatted PL if command (2)");
                if (parenExpr.charAt(parenExpr.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL if command (2)");
                }
                values = SqlFile.getTokenArray(parenExpr.substring(1, parenExpr.length() - 1));
                tmpFile = null;
                try {
                    tmpFile = this.plBlockFile("if");
                }
                catch (IOException ioe) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + ioe);
                }
                try {
                    if (this.eval(values)) {
                        sf = new SqlFile(tmpFile, false, this.userVars);
                        sf.plMode = true;
                        sf.recursed = true;
                        sf.possiblyUncommitteds = this.possiblyUncommitteds;
                        sf.execute(this.curConn, this.continueOnError);
                    }
                }
                catch (BreakException be) {
                    beMessage = be.getMessage();
                    if (beMessage == null) throw be;
                    if (!beMessage.equals("if")) {
                        throw be;
                    }
                }
                catch (ContinueException ce) {
                    throw ce;
                }
                catch (QuitNow qe) {
                    throw qe;
                }
                catch (BadSpecial bs) {
                    throw new BadSpecial("Malformatted PL if command (3): " + bs);
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + e.getMessage());
                }
                if (tmpFile == null) return;
                if (tmpFile.delete() != false) return;
                throw new BadSpecial("Error occurred while trying to remove temp file '" + tmpFile + "'");
            }
            if (arg1.equals("while")) {
                if (toker.countTokens() < 1) {
                    throw new BadSpecial("Malformatted PL while command (1)");
                }
                parenExpr = toker.nextToken("").trim();
                if (parenExpr.length() < 2) throw new BadSpecial("Malformatted PL while command (2)");
                if (parenExpr.charAt(0) != '(') throw new BadSpecial("Malformatted PL while command (2)");
                if (parenExpr.charAt(parenExpr.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL while command (2)");
                }
                values = SqlFile.getTokenArray(parenExpr.substring(1, parenExpr.length() - 1));
                tmpFile = null;
                try {
                    tmpFile = this.plBlockFile("while");
                }
                catch (IOException ioe) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + ioe);
                }
                ** try [egrp 7[TRYBLOCK] [14, 15, 16, 17 : 1722->1818)] { 
lbl174:
                // 1 sources

            } else {
                toker = null;
                index = SqlFile.pastName(inString, 0);
                inLength = inString.length();
                varName = inString.substring(0, index);
                while (index + 1 < inLength && (inString.charAt(index) == ' ' || inString.charAt(index) == '\t')) {
                    ++index;
                }
                if (index + 1 > inLength) {
                    throw new BadSpecial("Unterminated PL variable definition");
                }
                operator = inString.charAt(index);
                remainder = inString.substring(index + 1);
                switch (inString.charAt(index)) {
                    case '_': {
                        this.silentFetch = true;
                    }
                    case '~': {
                        if (remainder.length() > 0) {
                            throw new BadSpecial("PL ~/_ set commands take no other args");
                        }
                        this.userVars.remove(varName);
                        this.fetchingVar = varName;
                        return;
                    }
                    case '=': {
                        if (this.fetchingVar != null && this.fetchingVar.equals(varName)) {
                            this.fetchingVar = null;
                        }
                        if (remainder.length() > 0) {
                            this.userVars.put(varName, inString.substring(index + 1).trim());
                            return;
                        }
                        this.userVars.remove(varName);
                        return;
                    }
                }
                throw new BadSpecial("Unknown PL command (3)");
            }
        }
        i = 0;
        while (i < tokenArray.length) {
            s = (String)this.userVars.get(tokenArray[i]);
            this.stdprintln("    " + tokenArray[i] + ": " + (doValues != false ? "(" + s + ')' : Integer.toString(s.length())));
            ++i;
        }
        return;
        {
            while (this.eval(values)) {
                try {
                    sf = new SqlFile(tmpFile, false, this.userVars);
                    sf.recursed = true;
                    sf.possiblyUncommitteds = this.possiblyUncommitteds;
                    sf.plMode = true;
                    sf.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException ce) {
                    ceMessage = ce.getMessage();
                    if (ceMessage == null || ceMessage.equals("while")) continue;
                    throw ce;
                }
            }
        }
lbl228:
        // 1 sources

        catch (BreakException be) {
            beMessage = be.getMessage();
            if (beMessage != null && !beMessage.equals("while")) {
                throw be;
            }
        }
lbl233:
        // 1 sources

        catch (QuitNow qe) {
            throw qe;
        }
lbl235:
        // 1 sources

        catch (BadSpecial bs) {
            throw new BadSpecial("Malformatted PL while command (3): " + bs);
        }
lbl237:
        // 1 sources

        catch (Exception e) {
            throw new BadSpecial("Failed to execute SQL from PL block.  " + e.getMessage());
        }
        if (tmpFile == null) return;
        if (tmpFile.delete() != false) return;
        throw new BadSpecial("Error occurred while trying to remove temp file '" + tmpFile + "'");
    }

    private File plBlockFile(String type) throws IOException, SqlToolError {
        int nestlevel = 1;
        if (type == null || !type.equals("foreach") && !type.equals("if") && !type.equals("while")) {
            throw new RuntimeException("Assertion failed.  Unsupported PL block type:  " + type);
        }
        File tmpFile = File.createTempFile("sqltool-", ".sql");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), this.charset));
        pw.println("/* " + new Date() + ". " + this.getClass().getName() + " PL block. */\n");
        while (true) {
            String s;
            if ((s = this.br.readLine()) == null) {
                this.errprintln("Unterminated '" + type + "' PL block");
                throw new SqlToolError("Unterminated '" + type + "' PL block");
            }
            ++this.curLinenum;
            if (s.trim().length() > 1 && s.trim().charAt(0) == '*') {
                StringTokenizer toker = new StringTokenizer(s.trim().substring(1));
                String curPlCommand = toker.nextToken();
                if (curPlCommand.equals(type)) {
                    ++nestlevel;
                } else if (curPlCommand.equals("end")) {
                    if (toker.countTokens() < 1) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (1)");
                        throw new SqlToolError("PL end statement requires arg  of 'foreach' or 'if' or 'while' (1)");
                    }
                    String inType = toker.nextToken();
                    if (inType.equals(type) && --nestlevel < 1) break;
                    if (!(inType.equals("foreach") || inType.equals("if") || inType.equals("while"))) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                        throw new SqlToolError("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                    }
                }
            }
            pw.println(s);
        }
        pw.flush();
        pw.close();
        return tmpFile;
    }

    private void stdprintln() {
        this.stdprintln(false);
    }

    private void stdprint(String s) {
        this.stdprint(s, false);
    }

    private void stdprintln(String s) {
        this.stdprintln(s, false);
    }

    private void stdprintln(boolean queryOutput) {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
        if (queryOutput && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprint(String s) {
        this.psErr.print(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + s + "</DIV>" : s);
    }

    private void errprintln(String s) {
        this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + s + "</DIV>" : s);
    }

    private void stdprint(String s, boolean queryOutput) {
        this.psStd.print(this.htmlMode ? "<P>" + s + "</P>" : s);
        if (queryOutput && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + s + "</P>" : s);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String s, boolean queryOutput) {
        this.psStd.println(this.htmlMode ? "<P>" + s + "</P>" : s);
        if (queryOutput && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + s + "</P>" : s);
            this.pwQuery.flush();
        }
    }

    private void listTables(char c, String inFilter) throws BadSpecial {
        String schema = null;
        int[] listSet = null;
        String[] types = null;
        String[] additionalSchemas = null;
        Statement statement = null;
        ResultSet rs = null;
        String narrower = "";
        String filter = inFilter;
        try {
            DatabaseMetaData md = this.curConn.getMetaData();
            String dbProductName = md.getDatabaseProductName();
            Object excludePrefix = null;
            types = new String[1];
            switch (c) {
                case '*': {
                    types = null;
                    break;
                }
                case 'S': {
                    if (dbProductName.indexOf("Oracle") > -1) {
                        System.err.println("*** WARNING:\n*** Listing tables in system-supplied schemas since\n*** Oracle(TM) doesn't return a JDBC system table list.");
                        types[0] = "TABLE";
                        schema = "SYS";
                        additionalSchemas = oracleSysSchemas;
                        break;
                    }
                    types[0] = "SYSTEM TABLE";
                    break;
                }
                case 's': {
                    if (dbProductName.indexOf("HSQL") > -1) {
                        if (filter != null && filter.charAt(filter.length() - 1) == '.') {
                            narrower = "\nWHERE sequence_schema = '" + filter.substring(0, filter.length() - 1) + "'";
                            filter = null;
                        }
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT sequence_schema, sequence_name FROM information_schema.system_sequences" + narrower);
                        break;
                    }
                    types[0] = "SEQUENCE";
                    break;
                }
                case 'r': {
                    if (dbProductName.indexOf("HSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT authorization_name FROM information_schema.system_authorizations\nWHERE authorization_type = 'ROLE'\nORDER BY authorization_name");
                        break;
                    }
                    if (dbProductName.indexOf("Adaptive Server Enterprise") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT name FROM syssrvroles ORDER BY name");
                        break;
                    }
                    throw new BadSpecial("SqlFile does not yet support \\dr for your database vendor");
                }
                case 'u': {
                    if (dbProductName.indexOf("HSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT user, admin FROM information_schema.system_users\nORDER BY user");
                        break;
                    }
                    if (dbProductName.indexOf("Oracle") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT username, created FROM all_users ORDER BY username");
                        break;
                    }
                    if (dbProductName.indexOf("PostgreSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT usename, usesuper FROM pg_catalog.pg_user ORDER BY usename");
                        break;
                    }
                    if (dbProductName.indexOf("Adaptive Server Enterprise") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT name, accdate, fullname FROM syslogins ORDER BY name");
                        break;
                    }
                    throw new BadSpecial("SqlFile does not yet support \\du for your database vendor");
                }
                case 'a': {
                    if (dbProductName.indexOf("HSQL") > -1) {
                        if (filter != null && filter.charAt(filter.length() - 1) == '.') {
                            narrower = "\nWHERE alias_schem = '" + filter.substring(0, filter.length() - 1) + "'";
                            filter = null;
                        }
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT alias_schem, alias FROM information_schema.system_aliases" + narrower);
                        break;
                    }
                    types[0] = "ALIAS";
                    break;
                }
                case 't': {
                    this.excludeSysSchemas = dbProductName.indexOf("Oracle") > -1;
                    types[0] = "TABLE";
                    break;
                }
                case 'v': {
                    types[0] = "VIEW";
                    break;
                }
                case 'n': {
                    rs = md.getSchemas();
                    if (rs == null) {
                        throw new BadSpecial("Failed to get metadata from database");
                    }
                    this.displayResultSet(null, rs, listMDSchemaCols, filter);
                    return;
                }
                case 'i': {
                    schema = null;
                    String table = null;
                    if (filter != null) {
                        int dotat = filter.indexOf(46);
                        String string = schema = dotat > 0 ? filter.substring(0, dotat) : null;
                        if (dotat < filter.length() - 1) {
                            table = dotat > 0 ? filter.substring(dotat + 1) : filter;
                        }
                        filter = null;
                    }
                    if ((rs = md.getIndexInfo(null, schema, table, false, true)) == null) {
                        throw new BadSpecial("Failed to get metadata from database");
                    }
                    this.displayResultSet(null, rs, listMDIndexCols, null);
                    return;
                }
                default: {
                    throw new BadSpecial("Unknown describe option: '" + c + "'");
                }
            }
            if (statement == null) {
                listSet = dbProductName.indexOf("HSQL") > -1 ? listMDTableCols[1] : (dbProductName.indexOf("Oracle") > -1 ? listMDTableCols[2] : listMDTableCols[0]);
                if (schema == null && filter != null && filter.charAt(filter.length() - 1) == '.') {
                    schema = filter.substring(0, filter.length() - 1);
                    filter = null;
                }
            }
            ResultSet resultSet = rs = statement == null ? md.getTables(null, schema, null, types) : statement.getResultSet();
            if (rs == null) {
                throw new BadSpecial("Failed to get metadata from database");
            }
            this.displayResultSet(null, rs, listSet, filter);
            if (additionalSchemas != null) {
                for (int i = 1; i < additionalSchemas.length; ++i) {
                    rs = md.getTables(null, additionalSchemas[i], null, types);
                    if (rs == null) {
                        throw new BadSpecial("Failed to get metadata from database for '" + additionalSchemas[i] + "'");
                    }
                    if (!rs.next()) continue;
                    this.displayResultSet(null, md.getTables(null, additionalSchemas[i], null, types), listSet, filter);
                }
            }
        }
        catch (SQLException se) {
            throw new BadSpecial("Failure getting MetaData: " + se);
        }
        catch (NullPointerException npe) {
            throw new BadSpecial("Failure getting MetaData (NPE)");
        }
        finally {
            this.excludeSysSchemas = false;
            if (rs != null) {
                rs = null;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {}
                statement = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSQL() throws SQLException {
        String sql = this.plMode ? this.dereference(this.curCommand, true) : this.curCommand;
        Statement statement = null;
        if (this.doPrepare) {
            if (sql.indexOf(63) < 1) {
                throw new SQLException("Prepared statements must contain one '?'");
            }
            this.doPrepare = false;
            PreparedStatement ps = this.curConn.prepareStatement(sql);
            if (this.prepareVar == null) {
                if (this.binBuffer == null) {
                    throw new SQLException("Binary SqlFile buffer is empty");
                }
                ps.setBytes(1, this.binBuffer);
            } else {
                String val = (String)this.userVars.get(this.prepareVar);
                if (val == null) {
                    throw new SQLException("PL Variable '" + this.prepareVar + "' is empty");
                }
                this.prepareVar = null;
                ps.setString(1, val);
            }
            ps.executeUpdate();
            statement = ps;
        } else {
            statement = this.curConn.createStatement();
            statement.execute(sql);
        }
        this.possiblyUncommitteds.set(true);
        try {
            this.displayResultSet(statement, statement.getResultSet(), null, null);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private void displayResultSet(Statement statement, ResultSet r, int[] incCols, String filter) throws SQLException {
        int updateCount = statement == null ? -1 : statement.getUpdateCount();
        boolean silent = this.silentFetch;
        boolean binary = this.fetchBinary;
        this.silentFetch = false;
        this.fetchBinary = false;
        if (this.excludeSysSchemas) {
            this.stdprintln("*** WARNING:\n*** Omitting tables from system-supplied schemas\n*** (because Oracle(TM) doesn't differentiate them to JDBC).");
        }
        switch (updateCount) {
            case -1: {
                int j;
                int i;
                String[] fieldArray;
                boolean skip;
                if (r == null) {
                    this.stdprintln("No result", true);
                    break;
                }
                ResultSetMetaData m = r.getMetaData();
                int cols = m.getColumnCount();
                int incCount = incCols == null ? cols : incCols.length;
                ArrayList<String[]> rows = new ArrayList<String[]>();
                String[] headerArray = null;
                int[] maxWidth = new int[incCount];
                if (!this.htmlMode) {
                    for (int i2 = 0; i2 < maxWidth.length; ++i2) {
                        maxWidth[i2] = 0;
                    }
                }
                boolean[] rightJust = new boolean[incCount];
                int[] dataType = new int[incCount];
                boolean[] autonulls = new boolean[incCount];
                int insi = -1;
                headerArray = new String[incCount];
                for (int i3 = 1; i3 <= cols; ++i3) {
                    if (incCols != null) {
                        skip = true;
                        for (int j2 = 0; j2 < incCols.length; ++j2) {
                            if (i3 != incCols[j2]) continue;
                            skip = false;
                        }
                        if (skip) continue;
                    }
                    headerArray[++insi] = m.getColumnLabel(i3);
                    dataType[insi] = m.getColumnType(i3);
                    rightJust[insi] = false;
                    autonulls[insi] = true;
                    switch (dataType[insi]) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            rightJust[insi] = true;
                            break;
                        }
                        case -3: 
                        case 12: {
                            autonulls[insi] = false;
                        }
                    }
                    if (this.htmlMode || headerArray[insi].length() <= maxWidth[insi]) continue;
                    maxWidth[insi] = headerArray[insi].length();
                }
                while (r.next()) {
                    fieldArray = new String[incCount];
                    insi = -1;
                    boolean filteredOut = filter != null;
                    for (i = 1; i <= cols; ++i) {
                        if (incCols != null) {
                            skip = true;
                            for (j = 0; j < incCols.length; ++j) {
                                if (i != incCols[j]) continue;
                                skip = false;
                            }
                            if (skip) continue;
                        }
                        if (!SqlFile.canDisplayType(dataType[++insi])) {
                            binary = true;
                        }
                        String val = null;
                        if (!binary) {
                            if (dataType[insi] == 93) {
                                Timestamp ts = r.getTimestamp(i);
                                val = ts == null ? null : ts.toString();
                            } else {
                                val = r.getString(i);
                                if (val == null) {
                                    try {
                                        val = this.streamToString(r.getAsciiStream(i));
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        if (binary || val == null && !r.wasNull()) {
                            if (this.pwCsv != null) {
                                throw new SQLException("Table has a binary column.  CSV files are text, not binary, files");
                            }
                            try {
                                this.binBuffer = this.streamToBytes(r.getBinaryStream(i));
                            }
                            catch (IOException ioe) {
                                throw new SQLException("Failed to read value using stream");
                            }
                            this.stdprintln("Read " + this.binBuffer.length + " bytes from field '" + headerArray[insi] + "' (type " + SqlFile.sqlTypeToString(dataType[insi]) + ") into binary buffer");
                            return;
                        }
                        if (this.excludeSysSchemas && i == 2) {
                            for (int z = 0; z < oracleSysSchemas.length; ++z) {
                                if (!val.equals(oracleSysSchemas[z])) continue;
                                filteredOut = true;
                                break;
                            }
                        }
                        if (this.fetchingVar != null) {
                            this.userVars.put(this.fetchingVar, val);
                            this.fetchingVar = null;
                        }
                        if (silent) {
                            return;
                        }
                        if (filter != null && (val == null || val.indexOf(filter) > -1)) {
                            filteredOut = false;
                        }
                        fieldArray[insi] = val == null && this.pwCsv == null ? (dataType[insi] == 12 ? (this.htmlMode ? "<I>null</I>" : DEFAULT_NULL_REP) : "") : val;
                        if (this.htmlMode || this.pwCsv != null || fieldArray[insi].length() <= maxWidth[insi]) continue;
                        maxWidth[insi] = fieldArray[insi].length();
                    }
                    if (filteredOut) continue;
                    rows.add(fieldArray);
                }
                if (this.pwCsv == null) {
                    this.condlPrintln("<TABLE border='1'>", true);
                    if (incCount > 1) {
                        this.condlPrint(SqlFile.htmlRow(0) + '\n' + PRE_TD, true);
                        for (i = 0; i < headerArray.length; ++i) {
                            this.condlPrint("<TD>" + headerArray[i] + "</TD>", true);
                            this.condlPrint((i > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(headerArray[i], maxWidth[i], rightJust[i], i < headerArray.length - 1 || rightJust[i]), false);
                        }
                        this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        if (!this.htmlMode) {
                            for (i = 0; i < headerArray.length; ++i) {
                                this.condlPrint((i > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(maxWidth[i]), false);
                            }
                            this.condlPrintln("", false);
                        }
                    }
                    for (i = 0; i < rows.size(); ++i) {
                        this.condlPrint(SqlFile.htmlRow(i % 2 == 0 ? 2 : 1) + '\n' + PRE_TD, true);
                        fieldArray = (String[])rows.get(i);
                        for (j = 0; j < fieldArray.length; ++j) {
                            this.condlPrint("<TD>" + fieldArray[j] + "</TD>", true);
                            this.condlPrint((j > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(fieldArray[j], maxWidth[j], rightJust[j], j < fieldArray.length - 1 || rightJust[j]), false);
                        }
                        this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                    }
                    this.condlPrintln("</TABLE>", true);
                    if (rows.size() != 1) {
                        this.stdprintln("\n" + rows.size() + " rows", true);
                    }
                    this.condlPrintln("<HR>", true);
                    break;
                }
                if (incCount > 0) {
                    for (i = 0; i < headerArray.length; ++i) {
                        this.csvSafe(headerArray[i]);
                        this.pwCsv.print(headerArray[i]);
                        if (i >= headerArray.length - 1) continue;
                        this.pwCsv.print(this.csvColDelim);
                    }
                    this.pwCsv.print(this.csvRowDelim);
                }
                for (i = 0; i < rows.size(); ++i) {
                    fieldArray = (String[])rows.get(i);
                    for (j = 0; j < fieldArray.length; ++j) {
                        this.csvSafe(fieldArray[j]);
                        this.pwCsv.print(fieldArray[j] == null ? (autonulls[j] ? "" : this.csvNullRep) : fieldArray[j]);
                        if (j >= fieldArray.length - 1) continue;
                        this.pwCsv.print(this.csvColDelim);
                    }
                    this.pwCsv.print(this.csvRowDelim);
                }
                this.stdprintln(Integer.toString(rows.size()) + " rows read from DB");
                break;
            }
            default: {
                if (this.fetchingVar != null) {
                    this.userVars.put(this.fetchingVar, Integer.toString(updateCount));
                    this.fetchingVar = null;
                }
                if (updateCount == 0) break;
                this.stdprintln(Integer.toString(updateCount) + " row" + (updateCount == 1 ? "" : "s") + " updated");
            }
        }
    }

    private static String htmlRow(int colType) {
        switch (colType) {
            case 0: {
                return PRE_TR + "<TR style='font-weight: bold;'>";
            }
            case 1: {
                return PRE_TR + "<TR style='background: #94d6ef; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return PRE_TR + "<TR style='background: silver; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int len) {
        return len > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, len);
    }

    private static String spaces(int len) {
        return len > SPACES.length() ? SPACES : SPACES.substring(0, len);
    }

    private static String pad(String inString, int fulllen, boolean rightJustify, boolean doPad) {
        if (!doPad) {
            return inString;
        }
        int len = fulllen - inString.length();
        if (len < 1) {
            return inString;
        }
        String pad = SqlFile.spaces(len);
        return (rightJustify ? pad : "") + inString + (rightJustify ? "" : pad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showHistory() {
        ctr = -1;
        reversedList = new String[this.statementHistory.length];
        try {
            block20: {
                block19: {
                    for (i = this.curHist; i >= 0; --i) {
                        s = this.statementHistory[i];
                        if (s == null) {
                            if (ctr < 0) {
                                this.stdprintln("<<<    No history yet    >>>");
                                return;
                            }
                            break block19;
                        }
                        reversedList[++ctr] = s;
                    }
                    break block20;
                }
                i = ctr;
                while (true) {
                    if (i < 0) {
                        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                        return;
                    }
                    this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + reversedList[i]);
                    --i;
                }
            }
            for (i = this.statementHistory.length - 1; i > this.curHist; --i) {
                block21: {
                    s = this.statementHistory[i];
                    if (s != null) break block21;
                    if (ctr < 0) {
                        this.stdprintln("<<<    No history yet    >>>");
                        return;
                    }
                    i = ctr;
                    ** GOTO lbl45
                }
                reversedList[++ctr] = s;
            }
        }
        catch (Throwable var6_7) {
            block22: {
                if (ctr < 0) {
                    this.stdprintln("<<<    No history yet    >>>");
                    return;
                }
                break block22;
lbl45:
                // 1 sources

                while (true) {
                    if (i < 0) {
                        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                        return;
                    }
                    this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + reversedList[i]);
                    --i;
                }
lbl52:
                // 1 sources

                while (true) {
                    if (i < 0) {
                        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                        return;
                    }
                    this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + reversedList[i]);
                    --i;
                }
            }
            i = ctr;
            while (true) {
                if (i < 0) {
                    this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                    throw var6_7;
                }
                this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + reversedList[i]);
                --i;
            }
        }
        if (ctr < 0) {
            this.stdprintln("<<<    No history yet    >>>");
            return;
        }
        i = ctr;
        ** GOTO lbl52
    }

    private String commandFromHistory(int commandsAgo) throws BadSpecial {
        if (commandsAgo >= this.statementHistory.length) {
            throw new BadSpecial("History can only hold up to " + this.statementHistory.length + " commands");
        }
        String s = this.statementHistory[(this.statementHistory.length + this.curHist - commandsAgo) % this.statementHistory.length];
        if (s == null) {
            throw new BadSpecial("History doesn't go back that far");
        }
        return s;
    }

    private void setBuf(String inString) {
        ++this.curHist;
        if (this.curHist == this.statementHistory.length) {
            this.curHist = 0;
        }
        this.statementHistory[this.curHist] = inString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describe(String tableName, String inFilter) throws SQLException {
        String filter = inFilter;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String[] headerArray = new String[]{"name", "datatype", "width", "no-nulls"};
        int[] maxWidth = new int[]{0, 0, 0, 0};
        boolean[] rightJust = new boolean[]{false, false, true, false};
        for (int i = 0; i < headerArray.length; ++i) {
            if (this.htmlMode || headerArray[i].length() <= maxWidth[i]) continue;
            maxWidth[i] = headerArray[i].length();
        }
        Statement statement = this.curConn.createStatement();
        ResultSet r = null;
        try {
            int j;
            String[] fieldArray;
            int i;
            statement.execute("SELECT * FROM " + tableName + " WHERE 1 = 2");
            r = statement.getResultSet();
            ResultSetMetaData m = r.getMetaData();
            int cols = m.getColumnCount();
            for (i = 0; i < cols; ++i) {
                fieldArray = new String[4];
                fieldArray[0] = m.getColumnName(i + 1);
                if (filter != null && fieldArray[0].indexOf(filter) < 0) continue;
                fieldArray[1] = m.getColumnTypeName(i + 1);
                fieldArray[2] = Integer.toString(m.getColumnDisplaySize(i + 1));
                fieldArray[3] = m.isNullable(i + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : "*";
                rows.add(fieldArray);
                for (j = 0; j < fieldArray.length; ++j) {
                    if (fieldArray[j].length() <= maxWidth[j]) continue;
                    maxWidth[j] = fieldArray[j].length();
                }
            }
            this.condlPrint("<TABLE border='1'>\n" + SqlFile.htmlRow(0) + '\n' + PRE_TD, true);
            for (i = 0; i < headerArray.length; ++i) {
                this.condlPrint("<TD>" + headerArray[i] + "</TD>", true);
                this.condlPrint((i > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(headerArray[i], maxWidth[i], rightJust[i], i < headerArray.length - 1 || rightJust[i]), false);
            }
            this.condlPrintln("\n" + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            if (!this.htmlMode) {
                for (i = 0; i < headerArray.length; ++i) {
                    this.condlPrint((i > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(maxWidth[i]), false);
                }
                this.condlPrintln("", false);
            }
            for (i = 0; i < rows.size(); ++i) {
                this.condlPrint(SqlFile.htmlRow(i % 2 == 0 ? 2 : 1) + '\n' + PRE_TD, true);
                fieldArray = (String[])rows.get(i);
                for (j = 0; j < fieldArray.length; ++j) {
                    this.condlPrint("<TD>" + fieldArray[j] + "</TD>", true);
                    this.condlPrint((j > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(fieldArray[j], maxWidth[j], rightJust[j], j < fieldArray.length - 1 || rightJust[j]), false);
                }
                this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
            }
            this.condlPrintln("\n</TABLE>\n<HR>", true);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                    r = null;
                }
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static String[] getTokenArray(String inString) {
        String[] mtString = new String[]{};
        if (inString == null) {
            return mtString;
        }
        StringTokenizer toker = new StringTokenizer(inString);
        String[] sa = new String[toker.countTokens()];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = toker.nextToken();
        }
        return sa;
    }

    private boolean eval(String[] inTokens) throws BadSpecial {
        boolean negate = inTokens.length > 0 && inTokens[0].equals("!");
        String[] tokens = new String[negate ? inTokens.length - 1 : inTokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String string = inTokens[i + (negate ? 1 : 0)].length() > 1 && inTokens[i + (negate ? 1 : 0)].charAt(0) == '*' ? (String)this.userVars.get(inTokens[i + (negate ? 1 : 0)].substring(1)) : (tokens[i] = inTokens[i + (negate ? 1 : 0)]);
            if (tokens[i] != null) continue;
            tokens[i] = "";
        }
        if (tokens.length == 1) {
            return (tokens[0].length() > 0 && !tokens[0].equals("0")) ^ negate;
        }
        if (tokens.length == 3) {
            if (tokens[1].equals("==")) {
                return tokens[0].equals(tokens[2]) ^ negate;
            }
            if (tokens[1].equals("!=") || tokens[1].equals("<>") || tokens[1].equals("><")) {
                return !tokens[0].equals(tokens[2]) ^ negate;
            }
            if (tokens[1].equals(">")) {
                return (tokens[0].length() > tokens[2].length() || tokens[0].length() == tokens[2].length() && tokens[0].compareTo(tokens[2]) > 0) ^ negate;
            }
            if (tokens[1].equals("<")) {
                return (tokens[2].length() > tokens[0].length() || tokens[2].length() == tokens[0].length() && tokens[2].compareTo(tokens[0]) > 0) ^ negate;
            }
        }
        throw new BadSpecial("Unrecognized logical operation");
    }

    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        if (this.htmlMode) {
            this.pwQuery.println("</BODY></HTML>");
            this.pwQuery.flush();
        }
        this.pwQuery.close();
        this.pwQuery = null;
    }

    private void condlPrintln(String s, boolean printHtml) {
        if (printHtml && !this.htmlMode || this.htmlMode && !printHtml) {
            return;
        }
        this.psStd.println(s);
        if (this.pwQuery != null) {
            this.pwQuery.println(s);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String s, boolean printHtml) {
        if (printHtml && !this.htmlMode || this.htmlMode && !printHtml) {
            return;
        }
        this.psStd.print(s);
        if (this.pwQuery != null) {
            this.pwQuery.print(s);
            this.pwQuery.flush();
        }
    }

    private static String formatNicely(Map map, boolean withValues) {
        StringBuffer sb = new StringBuffer();
        Iterator it = new TreeMap(map).keySet().iterator();
        if (withValues) {
            sb.append("The outermost parentheses are not part of the values.\n");
        } else {
            sb.append("Showing variable names and length of values (use 'listvalue' to see values).\n");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            String s = (String)map.get(key);
            sb.append("    " + key + ": " + (withValues ? "(" + s + ')' : Integer.toString(s.length())) + '\n');
        }
        return sb.toString();
    }

    private void dump(String varName, File dumpFile) throws IOException, BadSpecial {
        char lastChar;
        String val = (String)this.userVars.get(varName);
        if (val == null) {
            throw new BadSpecial("Variable '" + varName + "' has no value set");
        }
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), this.charset);
        osw.write(val);
        boolean terminated = false;
        if (val.length() > 0 && (lastChar = val.charAt(val.length() - 1)) != '\n' && lastChar != '\r') {
            terminated = true;
            osw.write(10);
        }
        osw.flush();
        osw.close();
        this.stdprintln("Saved " + dumpFile.length() + " characters to '" + dumpFile + "'");
    }

    private void dump(File dumpFile) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial("Binary SqlFile buffer is currently empty");
        }
        FileOutputStream fos = new FileOutputStream(dumpFile);
        fos.write(this.binBuffer);
        int len = this.binBuffer.length;
        this.binBuffer = null;
        fos.flush();
        fos.close();
        this.stdprintln("Saved " + len + " bytes to '" + dumpFile + "'");
    }

    private String streamToString(InputStream is) throws IOException {
        int i;
        char[] xferBuffer = new char[10240];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader isr = new InputStreamReader(is, this.charset);
        while ((i = isr.read(xferBuffer)) > 0) {
            stringWriter.write(xferBuffer, 0, i);
        }
        return stringWriter.toString();
    }

    private byte[] streamToBytes(InputStream is) throws IOException {
        int i;
        byte[] xferBuffer = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read(xferBuffer)) > 0) {
            baos.write(xferBuffer, 0, i);
        }
        return baos.toByteArray();
    }

    private void load(String varName, File asciiFile) throws IOException {
        int i;
        char[] xferBuffer = new char[10240];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(asciiFile), this.charset);
        while ((i = isr.read(xferBuffer)) > 0) {
            stringWriter.write(xferBuffer, 0, i);
        }
        isr.close();
        this.userVars.put(varName, stringWriter.toString());
    }

    private void load(File binFile) throws IOException {
        int i;
        byte[] xferBuffer = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(binFile);
        while ((i = fis.read(xferBuffer)) > 0) {
            baos.write(xferBuffer, 0, i);
        }
        fis.close();
        this.binBuffer = baos.toByteArray();
        this.stdprintln("Loaded " + this.binBuffer.length + " bytes into Binary buffer");
    }

    public static boolean canDisplayType(int i) {
        switch (i) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int i) {
        switch (i) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown type " + i;
    }

    public void csvSafe(String s) throws SQLException {
        if (this.pwCsv == null || this.csvColDelim == null || this.csvRowDelim == null || this.csvNullRep == null) {
            throw new RuntimeException("Assertion failed.  \ncsvSafe called when CSV settings are incomplete");
        }
        if (s == null) {
            return;
        }
        if (s.indexOf(this.csvColDelim) > 0) {
            throw new SQLException("Table data contains our column delimiter '" + this.csvColDelim + "'");
        }
        if (s.indexOf(this.csvRowDelim) > 0) {
            throw new SQLException("Table data contains our row delimiter '" + this.csvRowDelim + "'");
        }
        if (s.indexOf(this.csvNullRep) > 0) {
            throw new SQLException("Table data contains our null representation '" + this.csvNullRep + "'");
        }
    }

    public static String convertEscapes(String inString) {
        if (inString == null) {
            return null;
        }
        String workString = new String(inString);
        int i = 0;
        while ((i = workString.indexOf("\\n", i)) > -1 && i < workString.length() - 1) {
            workString = workString.substring(0, i) + '\n' + workString.substring(i + 2);
        }
        i = 0;
        while ((i = workString.indexOf("\\r", i)) > -1 && i < workString.length() - 1) {
            workString = workString.substring(0, i) + '\r' + workString.substring(i + 2);
        }
        i = 0;
        while ((i = workString.indexOf("\\t", i)) > -1 && i < workString.length() - 1) {
            workString = workString.substring(0, i) + '\t' + workString.substring(i + 2);
        }
        return workString;
    }

    public void importCsv(String filePath) throws IOException, BadSpecial {
        int i;
        char[] bfr = null;
        File file = new File(filePath);
        if (!file.canRead()) {
            throw new IOException("Can't read file '" + file + "'");
        }
        int fileLength = (int)file.length();
        try {
            bfr = new char[fileLength];
        }
        catch (RuntimeException re) {
            throw new IOException("SqlFile can only read in your CSV file in one chunk at this time.\nPlease run the program with more RAM (try Java -Xm* switches).");
        }
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
        int retval = isr.read(bfr, 0, bfr.length);
        isr.close();
        if (retval != bfr.length) {
            throw new IOException("Didn't read all characters.  Read in " + retval + " characters");
        }
        String string = null;
        try {
            string = new String(bfr);
        }
        catch (RuntimeException re) {
            throw new IOException("SqlFile converts your entire CSV file to a String at this time.\nPlease run the program with more RAM (try Java -Xm* switches).");
        }
        ArrayList<String> headerList = new ArrayList<String>();
        int recStart = 0;
        int recEnd = string.indexOf(this.csvRowDelim, recStart);
        if (recEnd < 0) {
            recEnd = string.length();
        }
        int colStart = recStart;
        int colEnd = -1;
        while (colEnd != recEnd) {
            colEnd = string.indexOf(this.csvColDelim, colStart);
            if (colEnd < 0 || colEnd > recEnd) {
                colEnd = recEnd;
            }
            if (colEnd - colStart < 1) {
                throw new IOException("No column header for column " + (headerList.size() + 1));
            }
            headerList.add(string.substring(colStart, colEnd));
            colStart = colEnd + this.csvColDelim.length();
        }
        String[] headers = headerList.toArray(new String[0]);
        boolean[] autonulls = new boolean[headers.length];
        String tableName = (String)this.userVars.get("*CSV_TABLENAME");
        if (tableName == null && (i = (tableName = file.getName()).lastIndexOf(46)) > 0) {
            tableName = tableName.substring(0, i);
        }
        StringBuffer tmpSb = new StringBuffer();
        for (int i2 = 0; i2 < headers.length; ++i2) {
            if (i2 > 0) {
                tmpSb.append(", ");
            }
            tmpSb.append(headers[i2]);
        }
        StringBuffer sb = new StringBuffer("INSERT INTO " + tableName + " (" + tmpSb + ") VALUES (");
        StringBuffer typeQuerySb = new StringBuffer("SELECT " + tmpSb + " FROM " + tableName + " WHERE 1 = 2");
        try {
            ResultSetMetaData rsmd = this.curConn.createStatement().executeQuery(typeQuerySb.toString()).getMetaData();
            if (rsmd.getColumnCount() != autonulls.length) {
                throw new BadSpecial("Metadata mismatch for columns");
            }
            for (int i3 = 0; i3 < autonulls.length; ++i3) {
                int ctype = rsmd.getColumnType(i3 + 1);
                autonulls[i3] = ctype != -3 && ctype != 12;
            }
        }
        catch (SQLException se) {
            throw new BadSpecial("Failed to get metadata for query: " + se.getMessage());
        }
        for (int i4 = 0; i4 < headers.length; ++i4) {
            if (i4 > 0) {
                sb.append(", ");
            }
            sb.append('?');
        }
        try {
            PreparedStatement ps = this.curConn.prepareStatement(sb.toString() + ')');
            String[] dataVals = new String[headers.length];
            int recCount = 0;
            while ((recStart = recEnd + this.csvRowDelim.length()) < string.length()) {
                recEnd = string.indexOf(this.csvRowDelim, recStart);
                if (recEnd < 0) {
                    recEnd = string.length();
                }
                colStart = recStart;
                colEnd = -1;
                int colCount = 0;
                ++recCount;
                while (colEnd != recEnd) {
                    colEnd = string.indexOf(this.csvColDelim, colStart);
                    if (colEnd < 0 || colEnd > recEnd) {
                        colEnd = recEnd;
                    }
                    if (colCount == dataVals.length) {
                        throw new IOException("Header has " + headers.length + " columns.  CSV record " + recCount + " has too many column values.");
                    }
                    dataVals[colCount++] = string.substring(colStart, colEnd);
                    colStart = colEnd + this.csvColDelim.length();
                }
                if (colCount != dataVals.length) {
                    throw new IOException("Header has " + headers.length + " columns.  CSV record " + recCount + " has " + colCount + " column values.");
                }
                for (int i5 = 0; i5 < dataVals.length; ++i5) {
                    ps.setString(i5 + 1, dataVals[i5].length() < 1 && autonulls[i5] || dataVals[i5].equals(this.csvNullRep) ? null : dataVals[i5]);
                }
                retval = ps.executeUpdate();
                if (retval != 1) {
                    this.curConn.rollback();
                    throw new BadSpecial("Insert of row " + recCount + " failed.  " + retval + " rows modified");
                }
                this.possiblyUncommitteds.set(true);
            }
            this.stdprintln("Successfully inserted " + recCount + " rows into table '" + tableName + "'");
        }
        catch (SQLException se) {
            try {
                this.curConn.rollback();
            }
            catch (SQLException se2) {
                // empty catch block
            }
            throw new BadSpecial("SQL error encountered when inserting CSV data: " + se);
        }
    }

    static {
        revnum = "$Revision: 1.135 $".substring("$Revision: ".length(), "$Revision: 1.135 $".length() - 2);
        BANNER = "(SqlFile processor v. " + revnum + ")\n" + "Distribution is permitted under the terms of the HSQLDB license.\n" + "(c) 2004-2005 Blaine Simpson and the HSQLDB Development Group.\n\n" + "    \\q    to Quit.\n" + "    \\?    lists Special Commands.\n" + "    :?    lists Buffer/Editing commands.\n" + "    *?    lists PL commands (including alias commands).\n\n" + "SPECIAL Commands begin with '\\' and execute when you hit ENTER.\n" + "BUFFER Commands begin with ':' and execute when you hit ENTER.\n" + "COMMENTS begin with '/*' and end with the very next '*/'.\n" + "PROCEDURAL LANGUAGE commands begin with '*' and end when you hit ENTER.\n" + "All other lines comprise SQL Statements.\n" + "  SQL Statements are terminated by either a blank line (which moves the\n" + "  statement into the buffer without executing) or a line ending with ';'\n" + "  (which executes the statement).\n" + "  SQL Statements may begin with '/PLVARNAME' and/or contain *{PLVARNAME}s.\n";
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r'};
        DEFAULT_ROW_DELIM = System.getProperty("line.separator");
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        PRE_TR = SqlFile.spaces(4);
        PRE_TD = SqlFile.spaces(8);
    }

    private class BadSwitch
    extends Exception {
        private BadSwitch(int i) {
            super(Integer.toString(i));
        }
    }

    private class ContinueException
    extends SqlToolError {
        public ContinueException() {
        }

        public ContinueException(String s) {
            super(s);
        }
    }

    private class BreakException
    extends SqlToolError {
        public BreakException() {
        }

        public BreakException(String s) {
            super(s);
        }
    }

    private class QuitNow
    extends SqlToolError {
        public QuitNow(String s) {
            super(s);
        }

        public QuitNow() {
        }
    }

    private class BadSpecial
    extends Exception {
        private BadSpecial() {
        }

        private BadSpecial(String s) {
            super(s);
        }
    }

    private static class BooleanBucket {
        private boolean bPriv = false;

        private BooleanBucket() {
        }

        public void set(boolean bIn) {
            this.bPriv = bIn;
        }

        public boolean get() {
            return this.bPriv;
        }
    }
}

