/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class RCData {
    public static final String DEFAULT_JDBC_DRIVER = "org.hsqldb.jdbcDriver";
    String id = null;
    String url = null;
    String username = null;
    String password = null;
    String driver = null;
    String charset = null;
    String truststore = null;

    public void report() {
        System.err.println("urlid: " + this.id + ", url: " + this.url + ", username: " + this.username + ", password: " + this.password);
    }

    public RCData(File file, String dbKey) throws Exception {
        String s;
        if (file == null) {
            throw new IllegalArgumentException("RC file name not specified");
        }
        if (!file.canRead()) {
            throw new IOException("Please set up authentication file '" + file + "'");
        }
        StringTokenizer tokenizer = null;
        boolean thisone = false;
        int linenum = 0;
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((s = br.readLine()) != null) {
            String value;
            String keyword;
            ++linenum;
            if ((s = s.trim()).length() == 0 || s.charAt(0) == '#') continue;
            tokenizer = new StringTokenizer(s);
            if (tokenizer.countTokens() == 1) {
                keyword = tokenizer.nextToken();
                value = "";
            } else if (tokenizer.countTokens() > 1) {
                keyword = tokenizer.nextToken();
                value = tokenizer.nextToken("").trim();
            } else {
                try {
                    br.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw new Exception("Corrupt line " + linenum + " in '" + file + "':  " + s);
            }
            if (dbKey == null) {
                if (!keyword.equals("urlid")) continue;
                System.out.println(value);
                continue;
            }
            if (keyword.equals("urlid")) {
                if (value.equals(dbKey)) {
                    if (this.id == null) {
                        this.id = dbKey;
                        thisone = true;
                        continue;
                    }
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw new Exception("Key '" + dbKey + " redefined at" + " line " + linenum + " in '" + file);
                }
                thisone = false;
                continue;
            }
            if (!thisone) continue;
            if (keyword.equals("url")) {
                this.url = value;
                continue;
            }
            if (keyword.equals("username")) {
                this.username = value;
                continue;
            }
            if (keyword.equals("driver")) {
                this.driver = value;
                continue;
            }
            if (keyword.equals("charset")) {
                this.charset = value;
                continue;
            }
            if (keyword.equals("truststore")) {
                this.truststore = value;
                continue;
            }
            if (keyword.equals("password")) {
                this.password = value;
                continue;
            }
            try {
                br.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new Exception("Bad line " + linenum + " in '" + file + "':  " + s);
        }
        try {
            br.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (dbKey == null) {
            return;
        }
        if (this.url == null || this.username == null || this.password == null) {
            throw new Exception("url or username or password not set for '" + dbKey + "' in file '" + file + "'");
        }
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String truststore) throws Exception {
        this.id = id;
        this.url = url;
        this.username = username;
        this.password = password;
        this.driver = driver;
        this.charset = charset;
        this.truststore = truststore;
        if (id == null || url == null || username == null || password == null) {
            throw new Exception("id, url, username, or password was not set");
        }
    }

    public Connection getConnection() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        return this.getConnection(null, null, null);
    }

    public Connection getConnection(String curDriver, String curCharset, String curTrustStore) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Properties sysProps = System.getProperties();
        if (curDriver == null) {
            String string = curDriver = this.driver == null ? DEFAULT_JDBC_DRIVER : this.driver;
        }
        if (curCharset == null && this.charset != null) {
            curCharset = this.charset;
        }
        if (curTrustStore == null && this.truststore != null) {
            curTrustStore = this.truststore;
        }
        if (curCharset == null) {
            sysProps.remove("sqlfile.charset");
        } else {
            sysProps.put("sqlfile.charset", curCharset);
        }
        if (curTrustStore == null) {
            sysProps.remove("javax.net.ssl.trustStore");
        } else {
            sysProps.put("javax.net.ssl.trustStore", curTrustStore);
        }
        Class.forName(curDriver).newInstance();
        return DriverManager.getConnection(this.url, this.username, this.password);
    }
}

