/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.logging;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class FileConfig {
    private static final String PULSE_HOME = "pulse.home";
    private static final String FILE_NAME = "pulse%u.%g.log";
    private static final int APPROX_FILESIZE_LIMIT = 1000000;
    private static final int FILE_ROLL_COUNT = 20;
    private static final boolean APPEND = true;

    public FileConfig() throws IOException {
        if (!System.getProperties().containsKey(PULSE_HOME)) {
            return;
        }
        String pulseHomeProperty = System.getProperty(PULSE_HOME);
        File pulseHome = new File(pulseHomeProperty);
        File logRoot = new File(pulseHome, "logs");
        if (!logRoot.exists() && !logRoot.mkdirs()) {
            throw new IOException();
        }
        if (logRoot.exists() && !logRoot.isDirectory()) {
            throw new IOException();
        }
        String pattern = logRoot.getCanonicalPath() + File.separator + FILE_NAME;
        FileHandler fileHandler = new FileHandler(pattern, 1000000, 20, true);
        fileHandler.setLevel(Level.ALL);
        fileHandler.setFormatter(new SimpleFormatter());
        Logger rootLogger = Logger.getLogger("");
        rootLogger.addHandler(fileHandler);
    }
}

