/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PulseCtl {
    public static final String PULSE_HOME = "pulse.home";
    public static final String VERSION_HOME = "pulse.version.home";
    private static final String DEBUG = "debug";
    private static final int CONFIGURATION_ERROR = 1;
    private static final int UNEXPECTED_ERROR = 2;
    private static final int INVOCATION_ERROR = 3;

    public int process(String[] argv) {
        try {
            File pulseHome = this.getPulseHome();
            String activeVersion = this.getActiveVersion(this.getPulseHome());
            File versionHome = this.checkVersionHome(pulseHome, activeVersion);
            System.setProperty(VERSION_HOME, versionHome.getAbsolutePath());
            ClassLoader classpath = PulseCtl.makeClassLoader(versionHome);
            HashMap<String, Command> commands = this.loadCommands(versionHome, classpath);
            Map<String, Command> aliasedCommands = this.aliasCommands(commands);
            BootContext context = new BootContext(commands, argv, pulseHome, versionHome, activeVersion);
            if (argv.length == 0) {
                return this.runDefaultCommand(commands, context);
            }
            String commandName = argv[0];
            if (!aliasedCommands.containsKey(commandName)) {
                this.printError("Unknown command: " + commandName);
                this.runDefaultCommand(commands, context);
                return 3;
            }
            Thread.currentThread().setContextClassLoader(classpath);
            Command command = aliasedCommands.get(commandName);
            return command.execute(context);
        }
        catch (Exception e) {
            this.printError(e);
            return 2;
        }
    }

    private int runDefaultCommand(Map<String, Command> commands, BootContext context) throws Exception {
        for (Command command : commands.values()) {
            if (!command.isDefault()) continue;
            return command.execute(context);
        }
        this.printError("Unrecognised command, and no default command specified");
        return 3;
    }

    private File checkVersionHome(File pulseHome, String version) {
        File versionHome = PulseCtl.getVersionHome(pulseHome, version);
        if (!versionHome.exists()) {
            this.printError("Active version directory '" + versionHome.getAbsolutePath() + "' does not exist.");
            System.exit(1);
        }
        return versionHome;
    }

    private File getPulseHome() {
        File pulseHome;
        String pulseHomeStr = System.getProperty(PULSE_HOME);
        if (pulseHomeStr == null) {
            this.printError("Require property 'pulse.home' not set");
            System.exit(1);
        }
        if (!(pulseHome = new File(pulseHomeStr)).isDirectory()) {
            this.printError("Invalid Pulse home '" + pulseHome.getAbsolutePath() + "'");
            System.exit(1);
        }
        return pulseHome;
    }

    private String getActiveVersion(File pulseHome) throws IOException {
        File activeVersion = PulseCtl.getActiveVersionFile(pulseHome);
        if (!activeVersion.exists()) {
            this.printError("Active version file '" + activeVersion + "' does not exist");
            System.exit(1);
        }
        return PulseCtl.fileToString(activeVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Command> loadCommands(File versionHome, ClassLoader classpath) {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        Properties commandClasses = new Properties();
        File commandsDir = new File(versionHome, "boot");
        if (commandsDir.isDirectory()) {
            String[] propertiesFiles;
            for (String propertiesFile : propertiesFiles = commandsDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".commands.properties");
                }
            })) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(new File(commandsDir, propertiesFile));
                    commandClasses.load(in);
                }
                catch (IOException e) {
                    try {
                        this.printError(e);
                        System.exit(2);
                    }
                    catch (Throwable throwable) {
                        PulseCtl.close(in);
                        throw throwable;
                    }
                    PulseCtl.close(in);
                    continue;
                }
                PulseCtl.close(in);
            }
        }
        for (Map.Entry<Object, Object> entry : commandClasses.entrySet()) {
            this.addCommand(commands, classpath, (String)entry.getKey(), (String)entry.getValue());
        }
        return commands;
    }

    private Map<String, Command> aliasCommands(Map<String, Command> commands) {
        HashMap<String, Command> aliased = new HashMap<String, Command>(commands);
        for (Command command : commands.values()) {
            List<String> aliases = command.getAliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                aliased.put(alias, command);
            }
        }
        return aliased;
    }

    private void addCommand(HashMap<String, Command> commands, ClassLoader classpath, String name, String className) {
        try {
            Command command = (Command)classpath.loadClass(className).newInstance();
            commands.put(name, command);
        }
        catch (Exception e) {
            this.printError("Unable to load command '" + name + "'");
            this.printError(e);
            System.exit(1);
        }
    }

    private void printError(String msg) {
        System.err.println("Error: " + msg);
    }

    private void printError(Exception e) {
        e.printStackTrace(System.err);
        System.err.println("Error: " + e.getMessage());
    }

    private static boolean isDebugEnabled() {
        return Boolean.getBoolean(DEBUG);
    }

    public static void main(String[] argv) {
        int exitStatus = new PulseCtl().process(argv);
        if (exitStatus != 0) {
            System.exit(exitStatus);
        }
    }

    private static ClassLoader makeClassLoader(File versionHome) throws Exception {
        String line;
        File classpathFile;
        ClassLoader parent = PulseCtl.class.getClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if (!(classpathFile = new File(versionHome, PulseCtl.asPath("boot", "classpath.txt"))).exists()) {
            throw new Exception("Classpath file '" + classpathFile.getAbsolutePath() + "' does not exist");
        }
        LinkedList<URL> classpath = new LinkedList<URL>();
        BufferedReader reader = new BufferedReader(new FileReader(classpathFile));
        while ((line = reader.readLine()) != null) {
            PulseCtl.addToClasspath(versionHome, line, classpath);
        }
        PulseCtl.addToolsJar(classpath);
        URL[] urls = classpath.toArray(new URL[classpath.size()]);
        if (PulseCtl.isDebugEnabled()) {
            System.err.println("Pulse Classpath:");
            for (URL url : urls) {
                System.err.println(" - " + url);
            }
        }
        return new URLClassLoader(urls, parent);
    }

    private static void addToClasspath(File pulseHome, String entry, List<URL> classpath) throws Exception {
        if ((entry = entry.trim()).length() == 0) {
            return;
        }
        if (entry.endsWith("/")) {
            classpath.add(new File(pulseHome, PulseCtl.normaliseSeparators(entry)).toURL());
        } else {
            String[] files;
            int index = entry.lastIndexOf(47);
            File dir = index > 0 ? new File(pulseHome, PulseCtl.normaliseSeparators(entry.substring(0, index))) : pulseHome;
            if (index >= entry.length() - 1) {
                throw new Exception("Invalid classpath entry '" + entry + "'");
            }
            String pattern = entry.substring(index + 1);
            final Pattern regex = Pattern.compile(pattern);
            for (String file : files = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return regex.matcher(name).matches();
                }
            })) {
                classpath.add(new File(dir, file).toURL());
            }
        }
    }

    private static String normaliseSeparators(String entry) {
        return entry.replace('/', File.separatorChar);
    }

    private static String asPath(String ... elements) {
        StringBuffer buffer = new StringBuffer();
        String sep = "";
        for (String element : elements) {
            buffer.append(sep);
            buffer.append(element);
            sep = File.separator;
        }
        return buffer.toString();
    }

    private static void addToolsJar(List<URL> jarUrls) throws MalformedURLException {
        File javaHome = new File(System.getProperty("java.home"));
        File tools = new File(javaHome, PulseCtl.asPath("lib", "tools.jar"));
        if (tools.isFile()) {
            jarUrls.add(tools.toURL());
            return;
        }
        tools = new File(javaHome, PulseCtl.asPath("..", "lib", "tools.jar"));
        if (tools.isFile()) {
            jarUrls.add(tools.toURL());
        }
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void joinStreams(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[1024];
        while ((n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
    }

    public static void joinStreams(InputStream input, OutputStream output, boolean close) throws IOException {
        PulseCtl.joinStreams(input, output);
        if (close) {
            PulseCtl.close(input);
            PulseCtl.close(output);
        }
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PulseCtl.joinStreams(is, os);
        return os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(File file) throws IOException {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            string = PulseCtl.inputStreamToString(is);
        }
        catch (Throwable throwable) {
            PulseCtl.close(is);
            throw throwable;
        }
        PulseCtl.close(is);
        return string;
    }

    public static File getVersionRoot(File pulseHome) {
        return new File(pulseHome, "versions");
    }

    public static File getVersionHome(File pulseHome, String build) {
        return new File(PulseCtl.getVersionRoot(pulseHome), build);
    }

    public static File getActiveVersionFile(File pulseHome) {
        return new File(pulseHome, "active-version.txt");
    }
}

