/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.server;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.services.server.AbstractSkeleton;
import com.caucho.services.server.ServiceContext;
import com.caucho.util.CharBuffer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianSkeleton
extends AbstractSkeleton {
    private static final Logger log = Logger.getLogger(HessianSkeleton._resin_compat_class_0().getName());
    private Object _service;
    private static Class _resin_compat_class_0;

    public HessianSkeleton(Object service, Class apiClass) {
        super(apiClass);
        this._service = service;
        if (!apiClass.isAssignableFrom(service.getClass())) {
            throw new IllegalArgumentException(new CharBuffer().append("Service ").append(service).append(" must be an instance of ").append(apiClass.getName()).toString());
        }
    }

    public void invoke(HessianInput in, HessianOutput out) throws Throwable {
        String header;
        in.readCall();
        ServiceContext context = ServiceContext.getContext();
        while ((header = in.readHeader()) != null) {
            Object value = in.readObject();
            context.addHeader(header, value);
        }
        String methodName = in.readMethod();
        Method method = this.getMethod(methodName);
        if (method == null) {
            if ("_hessian_getAttribute".equals(methodName)) {
                String attrName = in.readString();
                in.completeCall();
                String value = null;
                if ("java.api.class".equals(attrName)) {
                    value = this.getAPIClassName();
                } else if ("java.home.class".equals(attrName)) {
                    value = this.getHomeClassName();
                } else if ("java.object.class".equals(attrName)) {
                    value = this.getObjectClassName();
                }
                out.startReply();
                out.writeObject(value);
                out.completeReply();
                return;
            }
            if (method == null) {
                out.startReply();
                out.writeFault("NoSuchMethodException", new CharBuffer().append("The service has no method named: ").append(in.getMethod()).toString(), null);
                out.completeReply();
                return;
            }
        }
        Class<?>[] args = method.getParameterTypes();
        Object[] values = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = in.readObject(args[i]);
        }
        in.completeCall();
        Object result = null;
        try {
            result = method.invoke(this._service, values);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
            return;
        }
        out.startReply();
        out.writeObject(result);
        out.completeReply();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.hessian.server.HessianSkeleton");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

