/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitegraph.model;

import com.opensymphony.webwork.sitegraph.model.IndentWriter;
import com.opensymphony.webwork.sitegraph.model.Link;
import com.opensymphony.webwork.sitegraph.model.SiteGraphNode;
import com.opensymphony.webwork.sitegraph.model.SubGraph;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Graph
extends SubGraph {
    private Set links = new TreeSet();
    public static Map nodeMap = new TreeMap();

    public Graph() {
        super("");
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void render(IndentWriter writer) throws IOException {
        writer.write("digraph mygraph {", true);
        writer.write("fontsize=10;");
        writer.write("fontname=helvetica;");
        writer.write("node [fontsize=10, fontname=helvetica, style=filled, shape=rectangle]");
        writer.write("edge [fontsize=10, fontname=helvetica]");
        Iterator iterator = this.subGraphs.iterator();
        while (iterator.hasNext()) {
            SubGraph subGraph = (SubGraph)iterator.next();
            subGraph.render(new IndentWriter(writer));
        }
        iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            SiteGraphNode siteGraphNode = (SiteGraphNode)iterator.next();
            siteGraphNode.render(writer);
        }
        iterator = this.links.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            link.render(writer);
        }
        writer.write("}", true);
    }

    public SiteGraphNode findNode(String location, SiteGraphNode ref) {
        if (location.startsWith("/")) {
            location = location.substring(1);
        } else {
            String prefix = null;
            if (ref.getParent() != null) {
                prefix = ref.getParent().getPrefix();
                location = prefix + "_" + location;
            }
        }
        location = location.replaceAll("[\\.\\/\\-\\$\\{\\}]", "_");
        return (SiteGraphNode)nodeMap.get(location);
    }
}

