/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitegraph;

import com.opensymphony.webwork.sitegraph.XWorkConfigRetriever;
import com.opensymphony.webwork.sitegraph.renderers.DOTRenderer;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteGraph {
    private static final Log LOG = LogFactory.getLog((Class)SiteGraph.class);
    private String configDir;
    private String views;
    private String output;
    private String namespace;
    private Writer writer;

    public SiteGraph(String configDir, String views, String output, String namespace) {
        this.configDir = configDir;
        this.views = views;
        this.output = output;
        this.namespace = namespace;
    }

    public static void main(String[] args) throws IOException {
        LOG.info((Object)"SiteGraph starting...");
        if (args.length != 8 && args.length != 6) {
            InputStream is = SiteGraph.class.getResourceAsStream("sitegraph-usage.txt");
            byte[] buffer = new byte[2048];
            int length = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            is.close();
            baos.close();
            String usage = baos.toString();
            System.out.println(usage.replaceAll("//.*", ""));
            return;
        }
        String configDir = SiteGraph.getArg(args, "config");
        String views = SiteGraph.getArg(args, "views");
        String output = SiteGraph.getArg(args, "output");
        String namespace = SiteGraph.getArg(args, "ns");
        SiteGraph siteGraph = new SiteGraph(configDir, views, output, namespace);
        siteGraph.prepare();
        siteGraph.render();
    }

    private static String getArg(String[] args, String arg) {
        for (int i = 0; i < args.length; ++i) {
            if (!("-" + arg).equals(args[i]) || i + 1 >= args.length) continue;
            return args[i + 1];
        }
        return "";
    }

    public void prepare() {
        if (this.writer == null) {
            try {
                this.writer = new FileWriter(this.output + "/out.dot");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        XWorkConfigRetriever.setConfiguration(this.configDir, this.views.split("[, ]+"));
        DOTRenderer renderer = new DOTRenderer(this.writer);
        renderer.render(this.namespace);
    }

    public void render() {
        try {
            Runtime.getRuntime().exec("dot -o" + this.output + "/out.gif -Tgif " + this.output + "/out.dot");
        }
        catch (IOException e) {
            LOG.error((Object)"Could not invoke dot", (Throwable)e);
        }
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

