/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.webwork.RequestUtils;
import com.opensymphony.webwork.WebWorkStatics;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.ActionContextCleanUp;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapper;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapperFactory;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.xwork.interceptor.component.ComponentConfiguration;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.DefaultComponentManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterDispatcher
implements Filter,
WebWorkStatics {
    private static final Log LOG = LogFactory.getLog((Class)FilterDispatcher.class);
    protected FilterConfig filterConfig;
    protected String[] pathPrefixes;

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String param = filterConfig.getInitParameter("packages");
        String packages = "com.opensymphony.webwork.static template";
        if (param != null) {
            packages = param + " " + packages;
        }
        this.pathPrefixes = this.parse(packages);
        DispatcherUtils.initialize(filterConfig.getServletContext());
    }

    protected String[] parse(String packages) {
        if (packages == null) {
            return null;
        }
        ArrayList<String> pathPrefixes = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(packages, ", \n\t");
        while (st.hasMoreTokens()) {
            String pathPrefix = st.nextToken().replace('.', '/');
            if (!pathPrefix.endsWith("/")) {
                pathPrefix = pathPrefix + "/";
            }
            pathPrefixes.add(pathPrefix);
        }
        return pathPrefixes.toArray(new String[pathPrefixes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        DispatcherUtils du = DispatcherUtils.getInstance();
        du.prepare(request, response);
        ActionMapper mapper = ActionMapperFactory.getMapper();
        ActionMapping mapping = mapper.getMapping(request);
        if (mapping == null) {
            String servletPath = RequestUtils.getServletPath(request);
            if (servletPath.startsWith("/webwork")) {
                String name = servletPath.substring("/webwork".length());
                this.findStaticResource(name, response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            return;
        }
        Object o = null;
        ServletContext servletContext = this.filterConfig.getServletContext();
        try {
            this.setupContainer(request);
            o = this.beforeActionInvocation(request, servletContext);
            try {
                request = du.wrapRequest(request, servletContext);
            }
            catch (IOException e) {
                String message = "Could not wrap servlet request with MultipartRequestWrapper!";
                LOG.error((Object)message, (Throwable)e);
                throw new ServletException(message, (Throwable)e);
            }
            du.serviceAction(request, response, servletContext, mapping);
            this.afterActionInvocation(request, servletContext, o);
        }
        catch (Throwable throwable) {
            this.afterActionInvocation(request, servletContext, o);
            ActionContextCleanUp.cleanUp(req);
            throw throwable;
        }
        ActionContextCleanUp.cleanUp(req);
    }

    protected void afterActionInvocation(HttpServletRequest request, Object o, Object o1) {
    }

    protected Object beforeActionInvocation(HttpServletRequest request, ServletContext servletContext) {
        return null;
    }

    protected void setupContainer(HttpServletRequest request) {
        ComponentConfiguration config;
        DefaultComponentManager container = null;
        HttpSession session = request.getSession(false);
        ComponentManager fallback = null;
        if (session != null) {
            fallback = (ComponentManager)session.getAttribute("DefaultComponentManager");
        }
        ServletContext servletContext = this.getServletContext(session);
        if (fallback == null) {
            fallback = (ComponentManager)servletContext.getAttribute("DefaultComponentManager");
        }
        if (fallback != null) {
            container = this.createComponentManager();
            container.setFallback(fallback);
        }
        if ((config = (ComponentConfiguration)servletContext.getAttribute("ComponentConfiguration")) != null) {
            if (container == null) {
                container = this.createComponentManager();
            }
            config.configure((ComponentManager)container, "request");
            request.setAttribute("DefaultComponentManager", (Object)container);
        }
    }

    protected ServletContext getServletContext(HttpSession session) {
        return this.filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findStaticResource(String name, HttpServletResponse response) throws IOException {
        if (!name.endsWith(".class")) {
            for (int i = 0; i < this.pathPrefixes.length; ++i) {
                InputStream is = this.findInputStream(name, this.pathPrefixes[i]);
                if (is == null) continue;
                try {
                    this.copy(is, (OutputStream)response.getOutputStream());
                }
                finally {
                    is.close();
                }
                return;
            }
        }
        response.sendError(404);
    }

    protected void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    protected InputStream findInputStream(String name, String packagePrefix) throws IOException {
        String resourcePath = packagePrefix.endsWith("/") && name.startsWith("/") ? packagePrefix + name.substring(1) : packagePrefix + name;
        String enc = (String)Configuration.get("webwork.i18n.encoding");
        resourcePath = URLDecoder.decode(resourcePath, enc);
        return ClassLoaderUtil.getResourceAsStream((String)resourcePath, this.getClass());
    }

    protected boolean checkUrl(URL url, String rawResourcePath) {
        if (url.getPath().endsWith("/")) {
            return false;
        }
        return url.toExternalForm().indexOf(rawResourcePath) != -1;
    }

    protected DefaultComponentManager createComponentManager() {
        return new DefaultComponentManager();
    }
}

