/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ActionContextCleanUp
implements Filter {
    private static final String CLEANUP_PRESENT = "__cleanup_present";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            req.setAttribute(CLEANUP_PRESENT, (Object)Boolean.TRUE);
            chain.doFilter(req, res);
        }
        finally {
            req.setAttribute(CLEANUP_PRESENT, (Object)Boolean.FALSE);
            ActionContextCleanUp.cleanUp(req);
        }
    }

    protected static void cleanUp(ServletRequest req) {
        Boolean dontClean = (Boolean)req.getAttribute(CLEANUP_PRESENT);
        if (dontClean != null && dontClean.booleanValue()) {
            return;
        }
        ComponentManager componentManager = (ComponentManager)req.getAttribute("DefaultComponentManager");
        if (componentManager != null) {
            componentManager.dispose();
        }
        ActionContext.setContext(null);
    }

    public void destroy() {
    }
}

