/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation.validators;

import com.zutubi.validation.ValidationException;
import com.zutubi.validation.validators.FieldValidatorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexValidator
extends FieldValidatorSupport {
    private String pattern = ".";
    private boolean caseSensitive = true;

    public RegexValidator() {
        this.setDefaultMessageKey(".invalid");
        this.setMessageKey("${fieldName}.invalid");
    }

    public void validate(Object obj) throws ValidationException {
        String fieldName = this.getFieldName();
        Object fieldValue = this.getFieldValue(fieldName, obj);
        if (fieldValue == null) {
            return;
        }
        if (!(fieldValue instanceof String)) {
            throw new ValidationException();
        }
        String value = (String)fieldValue;
        if ((value = value.trim()).length() == 0) {
            return;
        }
        Pattern pattern = this.isCaseSensitive() ? Pattern.compile(this.getPattern()) : Pattern.compile(this.getPattern(), 2);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            this.validationContext.addFieldError(this.getFieldName(), this.getMessage());
        }
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

