/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation.validators;

import com.zutubi.validation.ValidationException;
import com.zutubi.validation.validators.FieldValidatorSupport;

public class NumericValidator
extends FieldValidatorSupport {
    public static final String MIN = ".min";
    public static final String MAX = ".max";
    private int max = Integer.MAX_VALUE;
    private int min = Integer.MIN_VALUE;

    public void setMax(int max) {
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public void validate(Object obj) throws ValidationException {
        Object value = this.getFieldValue(this.getFieldName(), obj);
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            if (integerValue < this.min) {
                this.validationContext.addFieldError(this.getFieldName(), this.getFieldName() + MIN);
            }
            if (this.max < integerValue) {
                this.validationContext.addFieldError(this.getFieldName(), this.getFieldName() + MAX);
            }
        }
    }
}

