/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation.validators;

import com.zutubi.validation.DelegatingValidationContext;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.ValidationException;
import com.zutubi.validation.ValidationManager;
import com.zutubi.validation.validators.FieldValidatorSupport;
import java.util.Collection;

public class DelegateValidator
extends FieldValidatorSupport {
    private ValidationManager validationManager;

    public void validate(Object obj) throws ValidationException {
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, obj);
        if (value != null) {
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                Object[] array = coll.toArray();
                this.validateArrayElements(array, fieldName);
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                this.validateArrayElements(array, fieldName);
            } else {
                this.validateObject(value, fieldName);
            }
        }
    }

    private void validateArrayElements(Object[] array, String fieldName) throws ValidationException {
        for (int i = 0; i < array.length; ++i) {
            this.validateObject(array[i], fieldName + "[" + i + "]");
        }
    }

    private void validateObject(Object value, String fieldName) throws ValidationException {
        this.validationManager.validate(value, new AppendingValidationContext(this.validationContext, value, fieldName));
    }

    public void setValidationManager(ValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    private class AppendingValidationContext
    extends DelegatingValidationContext {
        private String fieldName;

        public AppendingValidationContext(ValidationContext parent, Object obj, String field) {
            this.validationAware = parent;
            this.textProvider = this.makeTextPovider(obj);
            this.fieldName = field;
        }

        public void addActionError(String error) {
            super.addFieldError(this.fieldName, error);
        }

        public void addFieldError(String field, String error) {
            super.addFieldError(this.getFullFieldName(field), error);
        }

        public String getFullFieldName(String field) {
            return this.fieldName + "." + field;
        }
    }
}

