/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation.providers;

import com.zutubi.validation.FieldValidator;
import com.zutubi.validation.Validator;
import com.zutubi.validation.ValidatorProvider;
import com.zutubi.validation.annotations.Constraint;
import com.zutubi.validation.bean.AnnotationUtils;
import com.zutubi.validation.bean.DefaultObjectFactory;
import com.zutubi.validation.bean.ObjectFactory;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationValidatorProvider
implements ValidatorProvider {
    private ObjectFactory objectFactory = new DefaultObjectFactory();

    @Override
    public List<Validator> getValidators(Object obj) {
        return this.traverse(obj.getClass(), new HashSet<Class>());
    }

    public List<Validator> traverse(Class clazz, Set<Class> checked) {
        LinkedList<Validator> validators = new LinkedList<Validator>();
        if (checked.contains(clazz) || clazz.equals(Object.class)) {
            return validators;
        }
        if (clazz.isInterface()) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                validators.addAll(this.traverse(interfaceClass, checked));
            }
        } else {
            validators.addAll(this.traverse(clazz.getSuperclass(), checked));
        }
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            if (checked.contains(interfaceClass)) continue;
            validators.addAll(this.traverse(interfaceClass, checked));
        }
        if (!checked.contains(clazz)) {
            validators.addAll(this.analyze(clazz));
            checked.add(clazz);
        }
        return validators;
    }

    public List<Validator> analyze(Class clazz) {
        LinkedList<Validator> validators = new LinkedList<Validator>();
        try {
            Class stopClass = clazz.getSuperclass();
            for (PropertyDescriptor descriptor : Introspector.getBeanInfo(clazz, stopClass).getPropertyDescriptors()) {
                Method read = descriptor.getReadMethod();
                if (read == null) continue;
                LinkedList<Annotation> constraints = new LinkedList<Annotation>();
                constraints.addAll(this.constraintsOnMethod(read));
                Method write = descriptor.getWriteMethod();
                if (write != null) {
                    constraints.addAll(this.constraintsOnMethod(write));
                }
                validators.addAll(this.validatorsFromConstraints(constraints, descriptor));
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return validators;
    }

    private Collection<Annotation> constraintsOnMethod(Method method) {
        if (method == null) {
            return Collections.EMPTY_SET;
        }
        LinkedList<Annotation> constraints = new LinkedList<Annotation>();
        for (Annotation annotation : method.getAnnotations()) {
            if (!this.isConstraint(annotation)) continue;
            constraints.add(annotation);
        }
        return constraints;
    }

    private boolean isConstraint(Annotation annotation) {
        return annotation.annotationType().getAnnotation(Constraint.class) != null;
    }

    private List<Validator> validatorsFromConstraints(List<Annotation> constraints, PropertyDescriptor descriptor) {
        LinkedList<Validator> validators = new LinkedList<Validator>();
        for (Annotation annotation : constraints) {
            Constraint constraint = annotation.annotationType().getAnnotation(Constraint.class);
            for (Class<? extends Validator> validatorClass : constraint.value()) {
                try {
                    Validator validator = (Validator)this.objectFactory.buildBean(validatorClass);
                    AnnotationUtils.setPropertiesFromAnnotation(annotation, validator);
                    if (validator instanceof FieldValidator) {
                        ((FieldValidator)validator).setFieldName(descriptor.getName());
                    }
                    validators.add(validator);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return validators;
    }
}

