/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation.bean;

import com.zutubi.validation.bean.BeanUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    private static final Set<String> internalMethods = new HashSet<String>();

    public static boolean isDefault(Annotation annotation, Method annotationMethod) {
        try {
            Field defaultField = annotation.getClass().getField("DEFAULT_" + annotationMethod.getName());
            return defaultField != null && annotationMethod.invoke((Object)annotation, new Object[0]).equals(defaultField.get(annotation));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void setPropertiesFromAnnotation(Annotation annotation, Object target) {
        for (Method annotationMethod : annotation.getClass().getMethods()) {
            try {
                if (AnnotationUtils.isDefault(annotation, annotationMethod)) continue;
                BeanUtils.setProperty(annotationMethod.getName(), annotationMethod.invoke((Object)annotation, new Object[0]), target);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Map<String, Object> collectPropertiesFromAnnotation(Annotation annotation) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Method annotationMethod : annotation.getClass().getDeclaredMethods()) {
            try {
                if (!AnnotationUtils.isUserDeclared(annotationMethod) || AnnotationUtils.isDefault(annotation, annotationMethod)) continue;
                properties.put(annotationMethod.getName(), annotationMethod.invoke((Object)annotation, new Object[0]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return properties;
    }

    public static final boolean isUserDeclared(Method annotationMethod) {
        return !internalMethods.contains(annotationMethod.getName());
    }

    static {
        internalMethods.add("toString");
        internalMethods.add("hashCode");
        internalMethods.add("annotationType");
        internalMethods.add("equals");
    }
}

