/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.validation;

import com.zutubi.validation.ValidationAware;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationAwareSupport
implements ValidationAware {
    private Collection<String> actionErrors;
    private Collection<String> actionMessages;
    private Map<String, List<String>> fieldErrors;

    @Override
    public void addActionError(String error) {
        this.internalGetActionErrors().add(error);
    }

    @Override
    public void addActionMessage(String message) {
        this.internalGetActionMessages().add(message);
    }

    @Override
    public void addFieldError(String field, String error) {
        Map<String, List<String>> errors = this.internalGetFieldErrors();
        if (!errors.containsKey(field)) {
            errors.put(field, new LinkedList());
        }
        List<String> aFieldsErrors = errors.get(field);
        aFieldsErrors.add(error);
    }

    @Override
    public Collection<String> getActionErrors() {
        return new LinkedList<String>(this.internalGetActionErrors());
    }

    @Override
    public Collection<String> getActionMessages() {
        return new LinkedList<String>(this.internalGetActionMessages());
    }

    @Override
    public List<String> getFieldErrors(String field) {
        return this.internalGetFieldErrors().get(field);
    }

    @Override
    public boolean hasErrors() {
        return this.hasActionErrors() || this.hasFieldErrors();
    }

    @Override
    public boolean hasFieldErrors() {
        return this.internalGetFieldErrors().size() > 0;
    }

    @Override
    public boolean hasActionErrors() {
        return this.internalGetActionErrors().size() > 0;
    }

    @Override
    public boolean hasActionMessages() {
        return this.internalGetActionErrors().size() > 0;
    }

    @Override
    public boolean hasFieldError(String field) {
        List<String> errors = this.getFieldErrors(field);
        return errors != null && errors.size() > 0;
    }

    @Override
    public Map<String, List<String>> getFieldErrors() {
        return new HashMap<String, List<String>>(this.internalGetFieldErrors());
    }

    @Override
    public void setActionMessages(Collection<String> messages) {
        this.actionMessages = messages;
    }

    @Override
    public void setActionErrors(Collection<String> errors) {
        this.actionErrors = errors;
    }

    @Override
    public void setFieldErrors(Map<String, List<String>> errors) {
        this.fieldErrors = errors;
    }

    private Collection<String> internalGetActionMessages() {
        if (this.actionMessages == null) {
            this.actionMessages = new LinkedList<String>();
        }
        return this.actionMessages;
    }

    private Collection<String> internalGetActionErrors() {
        if (this.actionErrors == null) {
            this.actionErrors = new LinkedList<String>();
        }
        return this.actionErrors;
    }

    private Map<String, List<String>> internalGetFieldErrors() {
        if (this.fieldErrors == null) {
            this.fieldErrors = new HashMap<String, List<String>>();
        }
        return this.fieldErrors;
    }
}

