/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.xstream;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.zutubi.pulse.scm.FileStatus;
import java.util.Map;

public class FileStatusConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        FileStatus status = (FileStatus)source;
        writer.startNode("path");
        context.convertAnother((Object)status.getPath());
        writer.endNode();
        writer.startNode("targetPath");
        context.convertAnother((Object)status.getTargetPath());
        writer.endNode();
        writer.startNode("state");
        writer.setValue(status.getState().toString());
        writer.endNode();
        writer.startNode("directory");
        context.convertAnother((Object)status.isDirectory());
        writer.endNode();
        writer.startNode("outOfDate");
        context.convertAnother((Object)status.isOutOfDate());
        writer.endNode();
        for (Map.Entry<String, String> property : status.getProperties().entrySet()) {
            writer.startNode("property");
            writer.startNode("name");
            context.convertAnother((Object)property.getKey());
            writer.endNode();
            writer.startNode("value");
            context.convertAnother((Object)property.getValue());
            writer.endNode();
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        FileStatus result = new FileStatus(null, null, false);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String fieldName = reader.getNodeName();
            if (fieldName.equals("path")) {
                result.setPath((String)context.convertAnother((Object)result, String.class));
            } else if (fieldName.equals("targetPath")) {
                result.setTargetPath((String)context.convertAnother((Object)result, String.class));
            } else if (fieldName.equals("state")) {
                String state = reader.getValue();
                try {
                    result.setState(FileStatus.State.valueOf(state));
                }
                catch (IllegalArgumentException e) {
                    throw new ConversionException("Unrecognised file state '" + state + "'");
                }
            } else if (fieldName.equals("directory")) {
                result.setDirectory((Boolean)context.convertAnother((Object)result, Boolean.TYPE));
            } else if (fieldName.equals("outOfDate")) {
                result.setOutOfDate((Boolean)context.convertAnother((Object)result, Boolean.TYPE));
            } else if (fieldName.equals("property")) {
                if (!reader.hasMoreChildren()) {
                    throw new ConversionException("Property has no child elements");
                }
                reader.moveDown();
                String name = reader.getValue();
                reader.moveUp();
                if (!reader.hasMoreChildren()) {
                    throw new ConversionException("Property has no value element");
                }
                reader.moveDown();
                String value = reader.getValue();
                reader.moveUp();
                result.setProperty(name, value);
            } else {
                throw new ConversionException("Unrecognised field '" + fieldName + "'");
            }
            reader.moveUp();
        }
        if (result.getPath() == null) {
            throw new ConversionException("Incomplete file status: missing path");
        }
        if (result.getState() == null) {
            throw new ConversionException("Incomplete file status: missing state");
        }
        return result;
    }

    public boolean canConvert(Class type) {
        return type == FileStatus.class;
    }
}

