/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.xmlrpc;

import com.zutubi.pulse.scm.SCMConfiguration;
import com.zutubi.pulse.xmlrpc.PulseXmlRpcException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;

public class PulseXmlRpcClient {
    private XmlRpcClient client;

    public PulseXmlRpcClient(String url) throws MalformedURLException {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + "xmlrpc";
        this.client = new XmlRpcClient(url);
    }

    public int getVersion() {
        return (Integer)this.execute("RemoteApi.getVersion", new String[0]);
    }

    public String login(String username, String password) {
        return (String)this.execute("RemoteApi.login", username, password);
    }

    public boolean logout(String token) {
        return (Boolean)this.execute("RemoteApi.logout", token);
    }

    public void failSafeLogout(String token) {
        if (token != null) {
            try {
                this.logout(token);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SCMConfiguration preparePersonalBuild(String token, String projectName, String buildSpecification) {
        if (buildSpecification == null) {
            buildSpecification = "";
        }
        Hashtable result = (Hashtable)this.execute("RemoteApi.preparePersonalBuild", token, projectName, buildSpecification);
        SCMConfiguration config = new SCMConfiguration((String)result.get("type"));
        for (Map.Entry entry : result.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("type")) continue;
            config.addProperty(key, (String)entry.getValue());
        }
        return config;
    }

    private Object execute(String method, String ... args) {
        Vector<String> v = new Vector<String>(args.length);
        for (String arg : args) {
            v.add(arg);
        }
        try {
            return this.client.execute(method, v);
        }
        catch (Exception e) {
            throw new PulseXmlRpcException(e.getMessage(), e);
        }
    }
}

