/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util.logging;

import java.util.logging.Filter;
import java.util.logging.Level;

public class Logger {
    private java.util.logging.Logger delegate;
    private String sourceClass;
    private String sourceMethod;

    protected Logger(java.util.logging.Logger delegate) {
        this.delegate = delegate;
    }

    public static Logger getLogger(Class cls) {
        return Logger.getLogger(cls.getName());
    }

    public static Logger getLogger(String name) {
        return new Logger(java.util.logging.Logger.getLogger(name));
    }

    public void setUseParentHandlers(boolean b) {
        this.delegate.setUseParentHandlers(b);
    }

    public void severe(Throwable t) {
        this.severe(t.getMessage(), t);
    }

    public void severe(String msg) {
        this.severe(msg, null);
    }

    public void severe(String msg, Throwable t) {
        if (!this.isLoggable(Level.SEVERE)) {
            return;
        }
        this.inferCaller();
        this.delegate.logp(Level.SEVERE, this.sourceClass, this.sourceMethod, msg, t);
    }

    public void info(Throwable t) {
        this.info(t.getMessage(), t);
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(String msg, Throwable t) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        this.inferCaller();
        this.delegate.logp(Level.INFO, this.sourceClass, this.sourceMethod, msg, t);
    }

    public void warning(Throwable t) {
        this.warning(t.getMessage(), t);
    }

    public void warning(String msg) {
        this.warning(msg, null);
    }

    public void warning(String msg, Object ... args) {
        this.warning(String.format(msg, args), null);
    }

    public void warning(String msg, Throwable t) {
        if (!this.isLoggable(Level.WARNING)) {
            return;
        }
        this.inferCaller();
        this.delegate.logp(Level.WARNING, this.sourceClass, this.sourceMethod, msg, t);
    }

    public void fine(Throwable t) {
        this.fine(t.getMessage(), t);
    }

    public void fine(String msg) {
        this.fine(msg, null);
    }

    public void fine(String msg, Throwable t) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        this.inferCaller();
        this.delegate.logp(Level.FINE, this.sourceClass, this.sourceMethod, msg, t);
    }

    public void finer(Throwable t) {
        this.finer(t.getMessage(), t);
    }

    public void finer(String msg) {
        this.finer(msg, null);
    }

    public void finer(String msg, Throwable t) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        this.inferCaller();
        this.delegate.logp(Level.FINER, this.sourceClass, this.sourceMethod, msg, t);
    }

    public void finest(String msg) {
        this.finest(msg, null);
    }

    public void finest(Throwable t) {
        this.finest(t.getMessage(), t);
    }

    public void finest(String msg, Throwable t) {
        if (!this.isLoggable(Level.FINEST)) {
            return;
        }
        this.inferCaller();
        this.delegate.logp(Level.FINEST, this.sourceClass, this.sourceMethod, msg, t);
    }

    public void log(Level level, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.inferCaller();
        this.delegate.log(level, msg);
    }

    public void debug(String msg) {
        this.finest(msg);
    }

    public void debug(Throwable t) {
        this.finest(t);
    }

    public void debug(String msg, Throwable t) {
        this.finest(msg, t);
    }

    public void error(String msg) {
        this.severe(msg);
    }

    public void error(Throwable t) {
        this.severe(t);
    }

    public void error(String msg, Throwable t) {
        this.severe(msg, t);
    }

    public boolean isLoggable(Level level) {
        return this.delegate.isLoggable(level);
    }

    public void entering() {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        this.inferCaller();
        this.entering(this.sourceClass, this.sourceMethod);
    }

    public void entering(String source, String method) {
        this.delegate.entering(this.sourceClass, this.sourceMethod);
    }

    public void exiting() {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        this.inferCaller();
        this.delegate.exiting(this.sourceClass, this.sourceMethod);
    }

    public void exiting(Object result) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        this.inferCaller();
        this.delegate.exiting(this.sourceClass, this.sourceMethod, result);
    }

    private void inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        this.sourceClass = null;
        this.sourceMethod = null;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String myClassName = this.getClass().getName();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(myClassName); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(myClassName)) {
                this.sourceClass = cname;
                this.sourceMethod = frame.getMethodName();
                return;
            }
            ++ix;
        }
    }

    public void setFilter(Filter filter) {
        this.delegate.setFilter(filter);
    }

    public java.util.logging.Logger getDelegate() {
        return this.delegate;
    }
}

