/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class TimeStamps
implements Serializable {
    public static final long UNINITIALISED_TIME = -1L;
    private long queueTime;
    private long startTime;
    private long endTime;
    private long estimatedRunningTime = -1L;

    public TimeStamps() {
        this.queueTime = -1L;
        this.startTime = -1L;
        this.endTime = -1L;
    }

    public TimeStamps(long queueTime, long startTime, long endTime) {
        this.queueTime = queueTime;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public TimeStamps(long queueTime, long startTime, long endTime, long estimatedRunningTime) {
        this.queueTime = queueTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.estimatedRunningTime = estimatedRunningTime;
    }

    public TimeStamps(TimeStamps other) {
        this.queueTime = other.queueTime;
        this.startTime = other.startTime;
        this.endTime = other.endTime;
        this.estimatedRunningTime = other.estimatedRunningTime;
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public long getQueueTime() {
        return this.queueTime;
    }

    public void setQueueTime(long queueTime) {
        this.queueTime = queueTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long t) {
        this.startTime = t;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private boolean hasEndTime() {
        return this.endTime != -1L;
    }

    public long getEstimatedEndTime() {
        return this.startTime + this.estimatedRunningTime;
    }

    public boolean hasEstimatedEndTime() {
        return this.estimatedRunningTime != -1L;
    }

    public boolean hasEstimatedTimeRemaining() {
        return this.hasEstimatedEndTime() && !this.hasEndTime();
    }

    public long getEstimatedTimeRemaining() {
        long estimatedEndTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime < (estimatedEndTime = this.getEstimatedEndTime())) {
            return estimatedEndTime - currentTime;
        }
        return 0L;
    }

    public String getPrettyEstimatedTimeRemaining() {
        if (this.hasEstimatedTimeRemaining()) {
            return TimeStamps.getPrettyElapsed(this.getEstimatedTimeRemaining());
        }
        return "n/a";
    }

    public int getEstimatedPercentComplete() {
        long remaining = this.getEstimatedTimeRemaining();
        if (this.hasEstimatedTimeRemaining() && remaining > 0L) {
            double percentRemaining = 100.0 * (double)remaining / (double)this.estimatedRunningTime;
            return (int)(100.0 - percentRemaining);
        }
        return 100;
    }

    public void setEndTime(long t) {
        this.endTime = t;
    }

    public long getEstimatedRunningTime() {
        return this.estimatedRunningTime;
    }

    public void setEstimatedRunningTime(long estimatedRunningTime) {
        this.estimatedRunningTime = estimatedRunningTime;
    }

    public long getElapsed() {
        if (!this.started()) {
            return -1L;
        }
        if (this.ended()) {
            return this.endTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public String getPrettyQueueTime() {
        return TimeStamps.getPrettyTime(this.queueTime);
    }

    public String getPrettyStartTime() {
        return TimeStamps.getPrettyTime(this.startTime);
    }

    public String getPrettyEndTime() {
        return TimeStamps.getPrettyTime(this.endTime);
    }

    public String getPrettyQueueDate(Locale locale) {
        return TimeStamps.getPrettyDate(this.queueTime, locale);
    }

    public String getPrettyStartDate(Locale locale) {
        return TimeStamps.getPrettyDate(this.startTime, locale);
    }

    public String getPrettyEndDate(Locale locale) {
        return TimeStamps.getPrettyDate(this.endTime, locale);
    }

    public static String getPrettyElapsed(long elapsed) {
        return TimeStamps.getPrettyElapsed(elapsed, -1);
    }

    public static String getPrettyElapsed(long elapsed, int maxUnits) {
        long newElapsed;
        StringBuffer result = new StringBuffer();
        int unitsAdded = 0;
        if (elapsed == -1L) {
            return "n/a";
        }
        if ((maxUnits < 0 || unitsAdded < maxUnits) && (newElapsed = TimeStamps.addElapsedPart(elapsed, 31536000000L, "year", result)) >= 0L) {
            elapsed = newElapsed;
            ++unitsAdded;
        }
        if (maxUnits < 0 || unitsAdded < maxUnits) {
            newElapsed = TimeStamps.addElapsedPart(elapsed, 604800000L, "week", result);
            if (newElapsed >= 0L) {
                elapsed = newElapsed;
                ++unitsAdded;
            } else if (unitsAdded > 0) {
                ++unitsAdded;
            }
        }
        if (maxUnits < 0 || unitsAdded < maxUnits) {
            newElapsed = TimeStamps.addElapsedPart(elapsed, 86400000L, "day", result);
            if (newElapsed >= 0L) {
                elapsed = newElapsed;
                ++unitsAdded;
            } else if (unitsAdded > 0) {
                ++unitsAdded;
            }
        }
        if (maxUnits < 0 || unitsAdded < maxUnits) {
            newElapsed = TimeStamps.addElapsedPart(elapsed, 3600000L, "hour", result);
            if (newElapsed >= 0L) {
                elapsed = newElapsed;
                ++unitsAdded;
            } else if (unitsAdded > 0) {
                ++unitsAdded;
            }
        }
        if (maxUnits < 0 || unitsAdded < maxUnits) {
            newElapsed = TimeStamps.addElapsedPart(elapsed, 60000L, "min", result);
            if (newElapsed >= 0L) {
                elapsed = newElapsed;
                ++unitsAdded;
            } else if (unitsAdded > 0) {
                ++unitsAdded;
            }
        }
        if (maxUnits < 0 || unitsAdded < maxUnits) {
            if (elapsed < 1000L && result.length() == 0) {
                result.append(elapsed);
                result.append(" ms");
            } else {
                TimeStamps.addElapsedPart(elapsed, 1000L, "sec", result);
            }
        }
        return result.toString();
    }

    public String getPrettyElapsed() {
        return TimeStamps.getPrettyElapsed(this.getElapsed());
    }

    public boolean equals(Object other) {
        if (!(other instanceof TimeStamps)) {
            return false;
        }
        TimeStamps otherStamps = (TimeStamps)other;
        return this.queueTime == otherStamps.queueTime && this.startTime == otherStamps.startTime && this.endTime == otherStamps.endTime;
    }

    private static long addElapsedPart(long elapsed, long millisPerPart, String partName, StringBuffer result) {
        if (elapsed >= millisPerPart) {
            long part = elapsed / millisPerPart;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Long.toString(part));
            result.append(' ');
            result.append(partName);
            if (part > 1L) {
                result.append('s');
            }
            return elapsed % millisPerPart;
        }
        return -1L;
    }

    public static String getPrettyTime(long time) {
        if (time == -1L) {
            return "n/a";
        }
        return TimeStamps.getPrettyElapsed(System.currentTimeMillis() - time, 2) + " ago";
    }

    public static String getPrettyDate(long time, Locale locale) {
        if (time == -1L) {
            return "n/a";
        }
        return DateFormat.getDateTimeInstance(3, 1, locale).format(new Date(time));
    }

    public boolean started() {
        return this.startTime != -1L;
    }

    public boolean ended() {
        return this.endTime != -1L;
    }
}

