/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static String trimmedString(String s, int length) {
        if (s.length() > length) {
            if (length >= 3) {
                return s.substring(0, length - 3) + "...";
            }
            String result = "";
            for (int i = 0; i < length; ++i) {
                result = result + ".";
            }
            return result;
        }
        return s;
    }

    public static String wrapString(String s, int lineLength, String prefix) {
        return StringUtils.wrapString(s, lineLength, prefix, true);
    }

    public static String wrapString(String s, int lineLength, String prefix, boolean splitWord) {
        if (prefix != null && prefix.length() >= lineLength - 1) {
            throw new IllegalArgumentException("prefix length must be less than line length -1");
        }
        if (s.length() < lineLength) {
            return s;
        }
        int length = s.length();
        int effectiveLineLength = lineLength;
        StringBuilder result = new StringBuilder(length + length * 2 / lineLength);
        int i = 0;
        while (i < length) {
            int j;
            if (length - i <= effectiveLineLength) {
                result.append(s.substring(i));
                break;
            }
            boolean alreadySplit = false;
            for (j = i + effectiveLineLength; j >= i; --j) {
                if (s.charAt(j) != '\n') continue;
                alreadySplit = true;
                result.append(s.substring(i, j + 1));
                if (prefix != null) {
                    result.append(prefix);
                }
                i = j + 1;
                break;
            }
            if (!alreadySplit) {
                int candidate;
                for (j = candidate = i + effectiveLineLength; j > i; --j) {
                    if (s.charAt(j) != ' ') continue;
                    result.append(s.substring(i, j));
                    result.append('\n');
                    if (prefix != null) {
                        result.append(prefix);
                    }
                    i = j + 1;
                    break;
                }
                if (j == i) {
                    if (splitWord) {
                        result.append(s.substring(i, candidate));
                        result.append('\n');
                        if (prefix != null) {
                            result.append(prefix);
                        }
                        i = candidate;
                    } else {
                        for (int k = candidate; k < s.length(); ++k) {
                            if (!Character.isWhitespace(s.charAt(k))) continue;
                            result.append(s.substring(i, k));
                            result.append('\n');
                            if (s.charAt(k) == '\n') {
                                ++k;
                            }
                            if (prefix != null) {
                                result.append(prefix);
                            }
                            i = k;
                            break;
                        }
                        if (j == i) {
                            result.append(s.substring(i));
                            break;
                        }
                    }
                }
            }
            if (prefix == null) continue;
            effectiveLineLength = lineLength - prefix.length();
        }
        return result.toString();
    }

    public static String getLine(String s, int line) {
        String[] lines = s.split("\r\n|\n|\r");
        if (lines.length >= line) {
            return lines[line - 1];
        }
        return null;
    }

    public static int getLineOffset(String s, int line) {
        s = s.replace("\r\n", "\n");
        s = s.replace("\r", "\n");
        int currentLine = 1;
        for (int i = 0; i < s.length(); ++i) {
            if (currentLine == line) {
                return i;
            }
            if (s.charAt(i) == '\r') {
                ++currentLine;
                if (i + 1 >= s.length() || s.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (s.charAt(i) != '\n') continue;
            ++currentLine;
        }
        return -1;
    }

    public static List<String> split(String s) {
        LinkedList<String> result = new LinkedList<String>();
        boolean inQuotes = false;
        boolean escaped = false;
        boolean haveData = false;
        StringBuilder current = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escaped) {
                haveData = true;
                current.append(c);
                escaped = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    escaped = true;
                    continue block5;
                }
                case ' ': {
                    if (inQuotes) {
                        current.append(c);
                        continue block5;
                    }
                    if (!haveData) continue block5;
                    result.add(current.toString());
                    current.delete(0, current.length());
                    haveData = false;
                    continue block5;
                }
                case '\"': {
                    if (inQuotes) {
                        inQuotes = false;
                        continue block5;
                    }
                    inQuotes = true;
                    haveData = true;
                    continue block5;
                }
                default: {
                    current.append(c);
                    haveData = true;
                }
            }
        }
        if (escaped) {
            throw new IllegalArgumentException("Unexpected end of input after backslash (\\)");
        }
        if (inQuotes) {
            throw new IllegalArgumentException("Unexpected end of input looking for end of quote (\")");
        }
        if (haveData) {
            result.add(current.toString());
        }
        return result;
    }

    public static String unsplit(List<String> pieces) {
        StringBuilder result = new StringBuilder();
        StringBuilder current = new StringBuilder();
        boolean first = true;
        for (String piece : pieces) {
            boolean quote = piece.length() == 0;
            current.delete(0, current.length());
            for (int i = 0; i < piece.length(); ++i) {
                char c = piece.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        current.append('\\');
                        break;
                    }
                    case ' ': {
                        quote = true;
                    }
                }
                current.append(c);
            }
            if (first) {
                first = false;
            } else {
                result.append(' ');
            }
            if (quote) {
                result.append('\"');
            }
            result.append((CharSequence)current);
            if (!quote) continue;
            result.append('\"');
        }
        return result.toString();
    }

    public static String join(String glue, String ... pieces) {
        return StringUtils.join(glue, false, false, pieces);
    }

    public static String join(String glue, boolean glueCheck, String ... pieces) {
        return StringUtils.join(glue, glueCheck, false, pieces);
    }

    public static String join(String glue, boolean glueCheck, boolean skipEmpty, String ... pieces) {
        StringBuilder result = new StringBuilder();
        if (skipEmpty) {
            ArrayList<String> list = new ArrayList<String>(pieces.length);
            for (String piece : pieces) {
                if (piece.length() <= 0) continue;
                list.add(piece);
            }
            pieces = list.toArray(new String[list.size()]);
        }
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i];
            if (glueCheck) {
                if (i > 0 && piece.startsWith(glue)) {
                    piece = piece.substring(glue.length());
                }
                if (i < pieces.length - 1 && piece.endsWith(glue)) {
                    piece = piece.substring(0, piece.length() - glue.length());
                }
            }
            if (i > 0) {
                result.append(glue);
            }
            result.append(piece);
        }
        return result.toString();
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

