/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util;

import com.zutubi.pulse.util.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.sql.DataSource;

public class JDBCUtils {
    private static final Logger LOG = Logger.getLogger(JDBCUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSchemaScript(Connection con, String[] sql) throws SQLException {
        if (sql != null && sql.length > 0) {
            boolean oldAutoCommit = con.getAutoCommit();
            con.setAutoCommit(false);
            try {
                Statement stmt = con.createStatement();
                try {
                    for (String aSql : sql) {
                        LOG.info("Executing schema statement: " + aSql);
                        try {
                            stmt.executeUpdate(aSql);
                        }
                        catch (SQLException ex) {
                            LOG.warning("Unsuccessful schema statement: " + aSql, ex);
                        }
                    }
                }
                finally {
                    JDBCUtils.close(stmt);
                }
                con.commit();
            }
            finally {
                con.setAutoCommit(oldAutoCommit);
            }
        }
    }

    public static String[] loadScript(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        LinkedList<String> statements = new LinkedList<String>();
        StringBuffer statement = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            statement.append(line).append(" ");
            if (!line.endsWith(";")) continue;
            statements.add(statement.toString());
            statement = new StringBuffer();
        }
        return statements.toArray(new String[statements.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DataSource ds, String sql) throws SQLException {
        Connection con = null;
        try {
            con = ds.getConnection();
            JDBCUtils.execute(con, sql);
        }
        finally {
            JDBCUtils.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Connection con, String sql) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            stmt.execute();
        }
        finally {
            JDBCUtils.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeSimpleQuery(DataSource ds, String sql) throws SQLException {
        Connection con = null;
        try {
            con = ds.getConnection();
            Object object = JDBCUtils.executeSimpleQuery(con, sql);
            return object;
        }
        finally {
            JDBCUtils.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeSimpleQuery(Connection con, String sql) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                Object object = rs.getObject(1);
                return object;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            JDBCUtils.close(stmt);
        }
    }

    public static boolean tableExists(DataSource ds, String tableName) {
        try {
            JDBCUtils.execute(ds, "SELECT COUNT(*) FROM " + tableName);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static boolean tableExists(Connection con, String tableName) {
        try {
            JDBCUtils.execute(con, "SELECT COUNT(*) FROM " + tableName);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static boolean columnExists(DataSource dataSource, String tableName, String columnName) {
        try {
            JDBCUtils.execute(dataSource, "SELECT COUNT(" + columnName + ") FROM " + tableName);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static boolean columnExists(Connection con, String tableName, String columnName) {
        try {
            JDBCUtils.execute(con, "SELECT COUNT(" + columnName + ") FROM " + tableName);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSchemaTableNames(Connection con) {
        String[] stringArray;
        LinkedList<String> tableNames = new LinkedList<String>();
        DatabaseMetaData meta = con.getMetaData();
        ResultSet rs = null;
        try {
            rs = meta.getTables(null, null, "%", new String[]{"TABLE"});
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
            stringArray = tableNames.toArray(new String[tableNames.size()]);
        }
        catch (Throwable throwable) {
            try {
                JDBCUtils.close(rs);
                throw throwable;
            }
            catch (SQLException e) {
                LOG.severe(e);
                return null;
            }
        }
        JDBCUtils.close(rs);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSchemaColumnNames(Connection con, String table) {
        String[] stringArray;
        LinkedList<String> columnNames = new LinkedList<String>();
        DatabaseMetaData meta = con.getMetaData();
        ResultSet rs = null;
        try {
            rs = meta.getColumns(null, null, table, "%");
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                columnNames.add(columnName);
            }
            stringArray = columnNames.toArray(new String[columnNames.size()]);
        }
        catch (Throwable throwable) {
            try {
                JDBCUtils.close(rs);
                throw throwable;
            }
            catch (SQLException e) {
                LOG.severe(e);
                return null;
            }
        }
        JDBCUtils.close(rs);
        return stringArray;
    }

    public static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warning(e);
            }
        }
    }

    public static void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                LOG.warning(e);
            }
        }
    }

    public static void close(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                LOG.warning(e);
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.warning(e);
            }
        }
    }

    public static void setString(PreparedStatement ps, int col, String str) throws SQLException {
        if (str == null) {
            ps.setNull(col, 12);
        } else {
            ps.setString(col, str);
        }
    }

    public static void setParam(PreparedStatement ps, int col, Object obj, int type) throws SQLException {
        if (type == -5) {
            JDBCUtils.setLong(ps, col, (Long)obj);
        } else if (type == 4) {
            JDBCUtils.setInt(ps, col, (Integer)obj);
        } else if (type == 12) {
            JDBCUtils.setString(ps, col, (String)obj);
        } else if (type == -7) {
            JDBCUtils.setBool(ps, col, (Boolean)obj);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
    }

    public static String getString(ResultSet rs, String col) throws SQLException {
        String result = rs.getString(col);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static void setInt(PreparedStatement ps, int col, Integer i) throws SQLException {
        if (i == null) {
            ps.setNull(col, 4);
        } else {
            ps.setInt(col, i);
        }
    }

    public static Integer getInt(ResultSet rs, String col) throws SQLException {
        Integer result = rs.getInt(col);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static void setLong(PreparedStatement ps, int col, Long l) throws SQLException {
        if (l == null) {
            ps.setNull(col, -5);
        } else {
            ps.setLong(col, l);
        }
    }

    public static Long getLong(ResultSet rs, String col) throws SQLException {
        Long result = rs.getLong(col);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static void setBool(PreparedStatement ps, int col, Boolean b) throws SQLException {
        if (b == null) {
            ps.setNull(col, 16);
        } else {
            ps.setBoolean(col, b);
        }
    }

    public static Boolean getBool(ResultSet rs, String col) throws SQLException {
        Boolean result = rs.getBoolean(col);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeUpdate(Connection con, String sql, Object[] args, int[] types) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            for (int i = 0; i < args.length; ++i) {
                JDBCUtils.setParam(ps, i + 1, args[i], types[i]);
            }
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close(ps);
        }
    }

    public static int executeCount(Connection con, String sql) throws SQLException {
        return JDBCUtils.executeCount(con, sql, new Object[0], new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCount(Connection con, String sql, Object[] args, int[] types) throws SQLException {
        int n;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            for (int i = 0; i < args.length; ++i) {
                JDBCUtils.setParam(ps, i + 1, args[i], types[i]);
            }
            rs = ps.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            n = count;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close(ps);
            throw throwable;
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCount(DataSource dataSource, String sql) throws SQLException {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            int n = JDBCUtils.executeCount(con, sql);
            return n;
        }
        finally {
            JDBCUtils.close(con);
        }
    }
}

