/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularBuffer<T>
implements Iterable<T> {
    private T[] buffer;
    private int index;
    private int count;

    public CircularBuffer(int capacity) {
        this.initialise(capacity);
    }

    public int getCount() {
        return this.count;
    }

    public int getCapacity() {
        return this.buffer.length - 1;
    }

    public synchronized void append(T t) {
        this.buffer[this.index++] = t;
        if (this.index >= this.buffer.length) {
            this.index = 0;
        }
        if (this.count < this.getCapacity()) {
            ++this.count;
        }
    }

    public synchronized T getElement(int i) {
        int actualIndex = this.count < this.getCapacity() ? i + 1 : (this.index + i + 1) % this.buffer.length;
        return this.buffer[actualIndex];
    }

    @Override
    public Iterator<T> iterator() {
        return new CircularBufferIterator();
    }

    public synchronized void clear() {
        this.initialise(this.getCapacity());
    }

    public synchronized List<T> takeSnapshot() {
        LinkedList<T> result = new LinkedList<T>();
        for (T t : this) {
            result.add(t);
        }
        return result;
    }

    private void initialise(int capacity) {
        this.buffer = new Object[capacity + 1];
        this.index = capacity > 0 ? 1 : 0;
        this.count = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CircularBufferIterator
    implements Iterator<T> {
        private int current;
        int last;

        public CircularBufferIterator() {
            if (CircularBuffer.this.count < CircularBuffer.this.getCapacity()) {
                this.current = 1;
                this.last = CircularBuffer.this.count + 1;
            } else {
                this.current = (CircularBuffer.this.index + 1) % CircularBuffer.this.buffer.length;
                this.last = CircularBuffer.this.index;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != this.last;
        }

        @Override
        public T next() {
            Object result = CircularBuffer.this.buffer[this.current++];
            if (this.current == CircularBuffer.this.buffer.length) {
                this.current = 0;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

