/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.p4;

import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import com.zutubi.pulse.core.model.NumericalRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.personal.PersonalBuildSupport;
import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.WorkingCopy;
import com.zutubi.pulse.scm.WorkingCopyStatus;
import com.zutubi.pulse.scm.p4.P4Client;
import com.zutubi.pulse.scm.p4.P4FStatHandler;
import com.zutubi.pulse.scm.p4.P4ProgressPrintingHandler;
import com.zutubi.pulse.scm.p4.P4SyncHandler;
import java.io.File;
import java.util.Properties;

public class P4WorkingCopy
extends PersonalBuildSupport
implements WorkingCopy {
    public static final String PROPERTY_CONFIRM_RESOLVE = "p4.confirm.resolve";
    private P4Client client = new P4Client();
    private ConfigSupport configSupport;

    public P4WorkingCopy(File base, Config config) {
        this.configSupport = new ConfigSupport(config);
    }

    public boolean matchesRepository(Properties repositoryDetails) throws SCMException {
        String port = (String)repositoryDetails.get("p4.port");
        if (port != null) {
            String[] lines;
            P4Client.P4Result result = this.client.runP4(null, "p4", "set");
            for (String line : lines = this.client.splitLines(result)) {
                String key;
                int index = line.indexOf(61);
                if (index <= 0 || index >= line.length() - 1 || !(key = line.substring(0, index)).equals("P4PORT")) continue;
                String value = line.substring(index + 1);
                if ((value = value.split(" ")[0]).equals(port)) continue;
                this.warning("P4PORT setting '" + value + "' does not match Pulse project's P4PORT '" + port + "'");
                return false;
            }
        }
        return true;
    }

    public WorkingCopyStatus getStatus() throws SCMException {
        WorkingCopyStatus status;
        NumericalRevision revision;
        NumericalRevision checkRevision;
        do {
            revision = this.client.getLatestRevisionForFiles(null, new String[0]);
            status = new WorkingCopyStatus(this.client.getClientRoot(), revision);
            P4FStatHandler handler = new P4FStatHandler(this.getUi(), status);
            this.client.runP4WithHandler(handler, null, "p4", "fstat", "-Op", "//...");
        } while (!(checkRevision = this.client.getLatestRevisionForFiles(null, new String[0])).equals(revision));
        return status;
    }

    public WorkingCopyStatus getLocalStatus(String ... spec) throws SCMException {
        WorkingCopyStatus status = new WorkingCopyStatus(this.client.getClientRoot());
        P4FStatHandler handler = new P4FStatHandler(this.getUi(), status, false);
        if (spec.length == 1 && spec[0].startsWith(":")) {
            String changelist = spec[0].substring(1);
            if (changelist.length() == 0) {
                throw new SCMException("Empty changelist name specified (" + spec[0] + ")");
            }
            this.client.runP4WithHandler(handler, null, "p4", "fstat", "-Op", "-Ro", "-e", changelist, "//...");
        } else if (spec.length > 0) {
            String[] commands = new String[spec.length + 4];
            commands[0] = "p4";
            commands[1] = "fstat";
            commands[2] = "-Op";
            commands[3] = "-Ro";
            System.arraycopy(spec, 0, commands, 4, spec.length);
            this.client.runP4WithHandler(handler, null, commands);
        } else {
            this.client.runP4WithHandler(handler, null, "p4", "fstat", "-Op", "-Ro", "-e", "default", "//...");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Revision update() throws SCMException {
        NumericalRevision revision = this.client.getLatestRevisionForFiles(null, new String[0]);
        P4SyncHandler syncHandler = new P4SyncHandler(this.getUi());
        this.client.runP4WithHandler(syncHandler, null, "p4", "sync", "@" + revision.getRevisionString());
        if (syncHandler.isResolveRequired()) {
            if (this.configSupport.getBooleanProperty(PROPERTY_CONFIRM_RESOLVE, true).booleanValue()) {
                PersonalBuildUI.Response response = this.ynaPrompt("Some files must be resolved.  Auto-resolve now?", PersonalBuildUI.Response.YES);
                if (response.isPersistent()) {
                    this.configSupport.setBooleanProperty(PROPERTY_CONFIRM_RESOLVE, !response.isAffirmative());
                }
                if (!response.isAffirmative()) {
                    return revision;
                }
            }
            this.status("Running auto-resolve...");
            this.enterContext();
            try {
                this.client.runP4WithHandler(new P4ProgressPrintingHandler(this.getUi(), false), null, "p4", "resolve", "-am");
            }
            finally {
                this.exitContext();
            }
            this.status("Resolve complete.");
        }
        return revision;
    }

    P4Client getClient() {
        return this.client;
    }
}

