/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.p4;

import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.scm.SCMCancelledException;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.p4.P4Handler;

public class P4SyncHandler
implements P4Handler {
    private PersonalBuildUI ui;
    private boolean resolveRequired = false;
    private boolean errorEncountered = false;

    public P4SyncHandler(PersonalBuildUI ui) {
        this.ui = ui;
    }

    public void handleStdout(String line) throws SCMException {
        if (this.ui != null) {
            if (line.startsWith("...") && line.contains("must resolve")) {
                this.resolveRequired = true;
            }
            this.ui.status(line);
        }
    }

    public void handleStderr(String line) throws SCMException {
        if (this.ui != null) {
            if (line.contains("ile(s) up-to-date.")) {
                this.ui.status(line);
            } else {
                this.ui.error(line);
                this.errorEncountered = true;
            }
        }
    }

    public void handleExitCode(int code) throws SCMException {
        if (code != 0) {
            throw new SCMException("p4 process returned non-zero exit code: " + code);
        }
        if (this.errorEncountered) {
            throw new SCMException("p4 process reported errors");
        }
    }

    public void checkCancelled() throws SCMCancelledException {
    }

    public boolean isResolveRequired() {
        return this.resolveRequired;
    }
}

