/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.p4;

import com.zutubi.pulse.personal.PersonalBuildUI;
import com.zutubi.pulse.scm.FileStatus;
import com.zutubi.pulse.scm.SCMCancelledException;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.WorkingCopyStatus;
import com.zutubi.pulse.scm.p4.P4Constants;
import com.zutubi.pulse.scm.p4.P4ErrorDetectingHandler;
import java.util.HashMap;
import java.util.Map;

public class P4FStatHandler
extends P4ErrorDetectingHandler {
    private PersonalBuildUI ui;
    private WorkingCopyStatus status;
    private boolean checkOutOfDate = true;
    private Map<String, String> currentItem = new HashMap<String, String>();

    public P4FStatHandler(PersonalBuildUI ui, WorkingCopyStatus status) {
        super(true);
        this.ui = ui;
        this.status = status;
    }

    public P4FStatHandler(PersonalBuildUI ui, WorkingCopyStatus status, boolean checkOutOfDate) {
        this(ui, status);
        this.checkOutOfDate = checkOutOfDate;
    }

    public void handleStdout(String line) throws SCMException {
        if ((line = line.trim()).length() == 0) {
            if (this.currentItem.size() > 0) {
                this.handleItem();
                this.currentItem.clear();
            }
        } else {
            String[] parts = line.split(" ", 3);
            if (parts.length == 3) {
                this.currentItem.put(parts[1], parts[2]);
            } else if (parts.length == 2) {
                this.currentItem.put(parts[1], "");
            }
        }
    }

    public void handleStderr(String line) {
        if (!line.contains("file(s) not opened on this client") && !line.equals("//... - no such file(s).")) {
            super.handleStderr(line);
        }
    }

    public void handleExitCode(int code) throws SCMException {
        super.handleExitCode(code);
        if (this.currentItem.size() > 0) {
            this.handleItem();
        }
    }

    public void checkCancelled() throws SCMCancelledException {
    }

    private void handleItem() {
        if (this.currentItem.containsKey("clientFile")) {
            String path = this.getPath(this.currentItem.get("clientFile"));
            String action = this.currentItem.get("action");
            FileStatus.State state = FileStatus.State.UNCHANGED;
            if (this.currentItem.containsKey("unresolved")) {
                state = FileStatus.State.UNRESOLVED;
            } else if (action != null) {
                state = this.mapAction(action);
                String have = this.currentItem.get("haveRev");
                if (have != null && have.equals("none") && state != FileStatus.State.DELETED) {
                    this.warning("Change to deleted file '" + path + "'");
                    state = FileStatus.State.UNRESOLVED;
                }
            }
            FileStatus fs = new FileStatus(path, state, false);
            if (this.checkOutOfDate && fs.getState().isConsistent() && fs.getState() != FileStatus.State.DELETED) {
                fs.setOutOfDate(this.isCurrentItemOutOfDate());
            }
            if (fs.isInteresting()) {
                if (this.ui != null) {
                    this.ui.status(fs.toString());
                }
                if (fs.getState().requiresFile()) {
                    String type = this.getCurrentItemType();
                    String headType = this.getCurrentItemHeadType();
                    if (this.fileIsText(type)) {
                        fs.setProperty("eol", FileStatus.EOLStyle.TEXT.toString());
                    }
                    this.resolveExecutableProperty(fs, type, headType);
                }
                this.status.add(fs);
            }
        }
    }

    private boolean isCurrentItemOutOfDate() {
        String haveRevision = this.currentItem.get("haveRev");
        String headRevision = this.currentItem.get("headRev");
        if (haveRevision == null) {
            return headRevision != null;
        }
        if (headRevision == null) {
            this.warning("Have revision but no head revision, assuming file is out of date.");
        }
        return !haveRevision.equals(headRevision);
    }

    private String getCurrentItemType() {
        String type = this.currentItem.get("type");
        if (type == null) {
            type = this.getCurrentItemHeadType();
        }
        return type;
    }

    private String getCurrentItemHeadType() {
        String type = this.currentItem.get("headType");
        if (type == null) {
            type = "text";
        }
        return type;
    }

    private void resolveExecutableProperty(FileStatus fs, String type, String headType) {
        if (!type.equals(headType)) {
            if (this.fileIsExecutable(type)) {
                if (!this.fileIsExecutable(headType)) {
                    fs.setProperty("executable", "true");
                }
            } else if (this.fileIsExecutable(headType)) {
                fs.setProperty("executable", "false");
            }
        }
    }

    private FileStatus.State mapAction(String action) {
        if (action.equals("add")) {
            return FileStatus.State.ADDED;
        }
        if (action.equals("branch")) {
            return FileStatus.State.BRANCHED;
        }
        if (action.equals("delete")) {
            return FileStatus.State.DELETED;
        }
        if (action.equals("edit")) {
            return FileStatus.State.MODIFIED;
        }
        if (action.equals("integrate")) {
            return FileStatus.State.MERGED;
        }
        this.warning("Unrecognised action '" + action + "': assuming file is modified.");
        return FileStatus.State.MODIFIED;
    }

    private String getPath(String clientFile) {
        int index;
        int length = clientFile.length();
        if (length > 3 && (index = clientFile.indexOf(47, 2)) >= 0 && index < length - 1) {
            clientFile = clientFile.substring(index + 1);
        }
        return clientFile;
    }

    private boolean fileIsExecutable(String type) {
        int plusIndex = type.indexOf(43);
        if (plusIndex >= 0) {
            for (int i = plusIndex + 1; i < type.length(); ++i) {
                if (type.charAt(i) != 'x') continue;
                return true;
            }
        } else {
            for (String exe : P4Constants.EXECUTABLE_TYPES) {
                if (!type.equals(exe)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean fileIsText(String type) {
        return type.contains("text");
    }

    private void warning(String message) {
        if (this.ui != null) {
            this.ui.warning(message);
        }
    }
}

