/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.p4;

import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.p4.P4Handler;

public abstract class P4ErrorDetectingHandler
implements P4Handler {
    private boolean throwOnStderr = false;
    private StringBuffer stderr;

    public P4ErrorDetectingHandler(boolean throwOnStderr) {
        this.throwOnStderr = throwOnStderr;
        this.stderr = new StringBuffer();
    }

    public void handleStderr(String line) {
        this.stderr.append(line);
        this.stderr.append('\n');
    }

    public void handleExitCode(int code) throws SCMException {
        if (code != 0) {
            String message = "p4 process returned non-zero exit code: " + Integer.toString(code);
            if (this.stderr.length() > 0) {
                message = message + ", error '" + this.stderr.toString().trim() + "'";
            }
            throw new SCMException(message);
        }
        if (this.stderr.length() > 0 && this.throwOnStderr) {
            throw new SCMException("p4 process returned error '" + this.stderr.toString().trim() + "'");
        }
    }

    public StringBuffer getStderr() {
        return this.stderr;
    }
}

