/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.cvs.client;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.scm.cvs.client.connection.SshConnection;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.LocalConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;

public class ConnectionFactory {
    public static Connection getConnection(CVSRoot cvsRoot, String password) {
        String method = cvsRoot.getMethod();
        if ("ext".equals(method)) {
            SshConnection sshConnection = new SshConnection(cvsRoot);
            if (TextUtils.stringSet((String)password)) {
                sshConnection.setPassword(password);
            }
            return sshConnection;
        }
        if ("pserver".equals(method)) {
            PServerConnection pServerConnection = new PServerConnection(cvsRoot);
            if (TextUtils.stringSet((String)password)) {
                String encodedPassword = StandardScrambler.getInstance().scramble(password);
                pServerConnection.setEncodedPassword(encodedPassword);
            }
            return pServerConnection;
        }
        if ("local".equals(method) || method == null) {
            LocalConnection c = new LocalConnection();
            c.setRepository(cvsRoot.getRepository());
            return c;
        }
        throw new IllegalArgumentException("Unsupported connection method: " + method);
    }
}

