/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.cvs;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.config.Config;
import com.zutubi.pulse.config.ConfigSupport;
import com.zutubi.pulse.core.model.CvsRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.personal.PersonalBuildException;
import com.zutubi.pulse.personal.PersonalBuildSupport;
import com.zutubi.pulse.scm.FileStatus;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMUtils;
import com.zutubi.pulse.scm.WorkingCopy;
import com.zutubi.pulse.scm.WorkingCopyStatus;
import com.zutubi.pulse.scm.cvs.client.CvsClient;
import com.zutubi.pulse.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class CvsWorkingCopy
extends PersonalBuildSupport
implements WorkingCopy {
    private CvsClient client;
    private File workingDir;
    private ConfigSupport configSupport;
    private String localWorkingRoot;
    private String localWorkingModule;

    public CvsWorkingCopy(File path, Config config) throws PersonalBuildException {
        CVSRoot cvsRoot;
        this.workingDir = path;
        this.client = new CvsClient();
        this.configSupport = new ConfigSupport(config);
        try {
            this.localWorkingRoot = this.loadLocalWorkingRoot();
            this.localWorkingModule = this.loadLocalWorkingModule();
            if (this.localWorkingRoot == null) {
                throw new IOException("Failed to retrieve the cvs.root from " + this.workingDir.getAbsolutePath() + "CVS/Root");
            }
            cvsRoot = CVSRoot.parse((String)this.localWorkingRoot);
        }
        catch (IOException e) {
            if (this.configSupport.hasProperty("cvs.root")) {
                cvsRoot = CVSRoot.parse((String)this.configSupport.getProperty("cvs.root"));
            }
            throw new PersonalBuildException("Failed to determine the cvs root. You can work around this problem by adding the cvs.root property to the .pulse.properties file.");
        }
        catch (Exception e) {
            throw new PersonalBuildException("Unexpected exception generated whilst attempting to determine the local working copies cvs.root. Cause: " + e.getClass() + ": " + e.getMessage());
        }
        this.client.setRoot(cvsRoot);
        if (!TextUtils.stringSet((String)cvsRoot.getPassword()) && this.configSupport.hasProperty("cvs.password")) {
            this.client.setPassword(this.configSupport.getProperty("cvs.password"));
        }
    }

    public boolean matchesRepository(Properties repositoryDetails) throws SCMException {
        String projectRoot;
        CVSRoot projectCvsRoot;
        CVSRoot localCvsRoot = CVSRoot.parse((String)this.localWorkingRoot);
        if (localCvsRoot.getCompatibilityLevel(projectCvsRoot = CVSRoot.parse((String)(projectRoot = repositoryDetails.getProperty("cvs.root")))) == -1) {
            return false;
        }
        String projectModule = repositoryDetails.getProperty("cvs.module");
        return this.localWorkingModule.equals(projectModule);
    }

    private String loadLocalWorkingModule() throws IOException {
        File repositoryFile = new File(this.workingDir, "CVS" + File.separator + "Repository");
        return IOUtils.fileToString(repositoryFile).trim();
    }

    private String loadLocalWorkingRoot() throws IOException {
        File rootFile = new File(this.workingDir, "CVS" + File.separator + "Root");
        return IOUtils.fileToString(rootFile).trim();
    }

    public WorkingCopyStatus getStatus() throws SCMException {
        WorkingCopyStatus status = new WorkingCopyStatus(this.workingDir);
        StatusHandler statusHandler = new StatusHandler(status);
        this.client.status(this.workingDir, null, (CVSListener)statusHandler);
        return status;
    }

    public WorkingCopyStatus getLocalStatus(String ... spec) throws SCMException {
        File[] files = SCMUtils.specToFiles(this.workingDir, spec);
        WorkingCopyStatus status = new WorkingCopyStatus(this.workingDir);
        StatusHandler statusHandler = new StatusHandler(status, false);
        this.client.status(this.workingDir, files, (CVSListener)statusHandler);
        return status;
    }

    public Revision update() throws SCMException {
        String branch = this.configSupport.getProperty("cvs.branch");
        if ("".equals(branch)) {
            branch = null;
        }
        UpdateHandler updateHandler = new UpdateHandler();
        CvsRevision revision = new CvsRevision(null, branch, null, new Date());
        this.client.update(this.workingDir, revision, (CVSListener)updateHandler);
        return revision;
    }

    private class StatusHandler
    extends CVSAdapter {
        private WorkingCopyStatus status = null;
        private boolean recordOutOfDate = true;

        public StatusHandler(WorkingCopyStatus status) {
            this.status = status;
        }

        public StatusHandler(WorkingCopyStatus status, boolean recordOutOfDate) {
            this.status = status;
            this.recordOutOfDate = recordOutOfDate;
        }

        public void fileInfoGenerated(FileInfoEvent e) {
            StatusInformation fileInfo = (StatusInformation)e.getInfoContainer();
            File localFile = fileInfo.getFile();
            String path = localFile.getPath();
            if (path.startsWith(CvsWorkingCopy.this.workingDir.getPath())) {
                path = path.substring(CvsWorkingCopy.this.workingDir.getPath().length());
            }
            if (path.startsWith("/") || path.startsWith(File.separator)) {
                path = path.substring(1);
            }
            FileStatus.State fileState = null;
            boolean outOfDate = false;
            org.netbeans.lib.cvsclient.file.FileStatus fileStatus = fileInfo.getStatus();
            if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.UP_TO_DATE) {
                fileState = FileStatus.State.UNCHANGED;
            } else if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.ADDED) {
                fileState = FileStatus.State.ADDED;
            } else if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.REMOVED) {
                fileState = FileStatus.State.DELETED;
            } else if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.MODIFIED) {
                fileState = FileStatus.State.MODIFIED;
            } else if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.NEEDS_CHECKOUT) {
                fileState = FileStatus.State.UNCHANGED;
                outOfDate = true;
            } else if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.NEEDS_MERGE) {
                fileState = FileStatus.State.MODIFIED;
                outOfDate = true;
            } else if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.NEEDS_PATCH) {
                fileState = FileStatus.State.UNCHANGED;
                outOfDate = true;
            } else if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.HAS_CONFLICTS) {
                fileState = FileStatus.State.UNRESOLVED;
            } else if (fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.UNRESOLVED_CONFLICT) {
                fileState = FileStatus.State.OBSTRUCTED;
            } else if (fileStatus != org.netbeans.lib.cvsclient.file.FileStatus.UNKNOWN && fileStatus == org.netbeans.lib.cvsclient.file.FileStatus.INVALID) {
                fileState = FileStatus.State.UNSUPPORTED;
            }
            if (fileState != null) {
                FileStatus fs = new FileStatus(path, fileState, localFile.isDirectory());
                fs.setTargetPath(CvsWorkingCopy.this.localWorkingModule + "/" + path);
                fs.setOutOfDate(this.recordOutOfDate && outOfDate);
                if (fs.isInteresting()) {
                    CvsWorkingCopy.this.status(fs.toString());
                    this.status.add(fs);
                }
            }
        }
    }

    private class UpdateHandler
    extends CVSAdapter {
        private String basePath = new File("").getAbsolutePath();

        private UpdateHandler() {
        }

        public void fileInfoGenerated(FileInfoEvent e) {
            DefaultFileInfoContainer info = (DefaultFileInfoContainer)e.getInfoContainer();
            String file = info.getFile().getAbsolutePath();
            if (file.startsWith(this.basePath) && (file = file.substring(this.basePath.length() + 1)).startsWith(File.separator)) {
                file = file.substring(1);
            }
            CvsWorkingCopy.this.status(String.format("%s     %s", info.getType(), file));
        }
    }
}

