/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm;

import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.scm.FileStatus;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopyStatus
implements Iterable<FileStatus> {
    private Revision revision;
    private List<FileStatus> changes = new LinkedList<FileStatus>();
    private transient File base;

    public WorkingCopyStatus() {
    }

    public WorkingCopyStatus(File base) {
        this.base = base;
    }

    public WorkingCopyStatus(File base, Revision revision) {
        this(base);
        this.revision = revision;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public void setRevision(Revision revision) {
        this.revision = revision;
    }

    public void add(FileStatus status) {
        this.getChanges().add(status);
    }

    @Override
    public Iterator<FileStatus> iterator() {
        return this.getChanges().iterator();
    }

    public boolean isOutOfDate() {
        for (FileStatus fs : this.getChanges()) {
            if (!fs.isOutOfDate()) continue;
            return true;
        }
        return false;
    }

    public boolean inConsistentState() {
        for (FileStatus fs : this.getChanges()) {
            if (fs.getState().isConsistent()) continue;
            return false;
        }
        return true;
    }

    public List<FileStatus> getChanges() {
        if (this.changes == null) {
            this.changes = new LinkedList<FileStatus>();
        }
        return this.changes;
    }

    public FileStatus getFileStatus(String path) {
        for (FileStatus fs : this.changes) {
            if (!fs.getPath().equals(path)) continue;
            return fs;
        }
        return null;
    }

    public void removeFileStatus(String path) {
        Iterator<FileStatus> i = this.changes.iterator();
        while (i.hasNext()) {
            if (!i.next().getPath().equals(path)) continue;
            i.remove();
            break;
        }
    }

    public boolean hasChanges() {
        return this.changes.size() > 0;
    }

    public File getBase() {
        return this.base;
    }
}

