/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm;

import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatus {
    public static final String PROPERTY_EOL_STYLE = "eol";
    public static final String PROPERTY_EXECUTABLE = "executable";
    private File file;
    private String path;
    private State state;
    private boolean directory;
    private String targetPath;
    private boolean outOfDate;
    private Map<String, String> properties = new HashMap<String, String>();

    public FileStatus(String path, State state, boolean directory) {
        if (path != null) {
            path = FileSystemUtils.normaliseSeparators(path);
        }
        this.path = path;
        this.state = state;
        this.directory = directory;
        this.outOfDate = false;
    }

    public String getTargetPath() {
        if (this.targetPath != null) {
            return this.targetPath;
        }
        return this.path;
    }

    public void setTargetPath(String targetPath) {
        if (targetPath != null) {
            this.targetPath = FileSystemUtils.normaliseSeparators(targetPath);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isOutOfDate() {
        return this.outOfDate;
    }

    public void setOutOfDate(boolean outOfDate) {
        this.outOfDate = outOfDate;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public boolean isInteresting() {
        return this.isOutOfDate() || this.state != State.UNCHANGED || this.properties.size() > 0;
    }

    public void preApply(File base) throws IOException {
        if (this.state == State.DELETED || this.state == State.REPLACED) {
            File f = new File(base, this.getTargetPath());
            if (this.directory) {
                FileSystemUtils.rmdir(f);
            } else {
                f.delete();
            }
        }
    }

    public void postApply(File base, EOLStyle localEOL) throws IOException {
        String executableValue;
        this.file = new File(base, this.getTargetPath());
        String eolName = this.properties.get(PROPERTY_EOL_STYLE);
        if (eolName != null) {
            try {
                EOLStyle eol = EOLStyle.valueOf(eolName);
                eol.apply(this.file, localEOL);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if ((executableValue = this.properties.get(PROPERTY_EXECUTABLE)) != null) {
            boolean executable = Boolean.parseBoolean(executableValue);
            if (this.file.exists()) {
                FileSystemUtils.setExecutable(this.file, executable);
            }
        }
    }

    public String toString() {
        return String.format("%-12s %s %s", this.state.toString(), this.outOfDate ? "*" : " ", this.path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ADDED{

            public boolean isConsistent() {
                return true;
            }

            public boolean requiresFile() {
                return true;
            }
        }
        ,
        BRANCHED{

            public boolean isConsistent() {
                return true;
            }

            public boolean requiresFile() {
                return true;
            }
        }
        ,
        DELETED{

            public boolean isConsistent() {
                return true;
            }

            public boolean requiresFile() {
                return false;
            }
        }
        ,
        INCOMPLETE{

            public boolean isConsistent() {
                return false;
            }

            public boolean requiresFile() {
                return false;
            }
        }
        ,
        MERGED{

            public boolean isConsistent() {
                return true;
            }

            public boolean requiresFile() {
                return true;
            }
        }
        ,
        MISSING{

            public boolean isConsistent() {
                return false;
            }

            public boolean requiresFile() {
                return false;
            }
        }
        ,
        MODIFIED{

            public boolean isConsistent() {
                return true;
            }

            public boolean requiresFile() {
                return true;
            }
        }
        ,
        OBSTRUCTED{

            public boolean isConsistent() {
                return false;
            }

            public boolean requiresFile() {
                return false;
            }
        }
        ,
        REPLACED{

            public boolean isConsistent() {
                return true;
            }

            public boolean requiresFile() {
                return true;
            }
        }
        ,
        UNRESOLVED{

            public boolean isConsistent() {
                return false;
            }

            public boolean requiresFile() {
                return false;
            }
        }
        ,
        UNSUPPORTED{

            public boolean isConsistent() {
                return false;
            }

            public boolean requiresFile() {
                return false;
            }
        }
        ,
        UNCHANGED{

            public boolean isConsistent() {
                return true;
            }

            public boolean requiresFile() {
                return false;
            }
        };


        public abstract boolean isConsistent();

        public abstract boolean requiresFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EOLStyle {
        BINARY{

            public void apply(File file, EOLStyle localEOL) throws IOException {
            }
        }
        ,
        CARRIAGE_RETURN{

            public void apply(File file, EOLStyle localEOL) throws IOException {
                this.translateEOLs(file, SystemUtils.CR_BYTES);
            }
        }
        ,
        CARRIAGE_RETURN_LINEFEED{

            public void apply(File file, EOLStyle localEOL) throws IOException {
                this.translateEOLs(file, SystemUtils.CRLF_BYTES);
            }
        }
        ,
        LINEFEED{

            public void apply(File file, EOLStyle localEOL) throws IOException {
                this.translateEOLs(file, SystemUtils.LF_BYTES);
            }
        }
        ,
        NATIVE{

            public void apply(File file, EOLStyle localEOL) throws IOException {
                this.translateEOLs(file, SystemUtils.LINE_SEPARATOR_BYTES);
            }
        }
        ,
        TEXT{

            public void apply(File file, EOLStyle localEOL) throws IOException {
                localEOL.apply(file, localEOL);
            }
        };


        public void translateEOLs(File file, byte[] lineSeparatorBytes) throws IOException {
            if (file.exists()) {
                FileSystemUtils.translateEOLs(file, lineSeparatorBytes, true);
            }
        }

        public abstract void apply(File var1, EOLStyle var2) throws IOException;
    }
}

