/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.resources;

import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.resources.AntResourceConstructor;
import com.zutubi.pulse.resources.JavaResourceConstructor;
import com.zutubi.pulse.resources.Maven2ResourceConstructor;
import com.zutubi.pulse.resources.MavenResourceConstructor;
import com.zutubi.pulse.resources.ResourceConstructor;
import com.zutubi.pulse.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDiscoverer {
    public List<Resource> discover() {
        LinkedList<Resource> result = new LinkedList<Resource>();
        this.discoverAnt(result);
        this.discoverMake(result);
        this.discoverMaven(result);
        this.discoverMaven2(result);
        this.discoverJava(result);
        return result;
    }

    private List<ResourceConstructor> getConstructors() {
        LinkedList<ResourceConstructor> constructors = new LinkedList<ResourceConstructor>();
        constructors.add(new AntResourceConstructor());
        constructors.add(new JavaResourceConstructor());
        constructors.add(new MavenResourceConstructor());
        constructors.add(new Maven2ResourceConstructor());
        return constructors;
    }

    private void discoverAnt(List<Resource> resources) {
        AntResourceConstructor antConstructor = new AntResourceConstructor();
        String home = System.getenv("ANT_HOME");
        if (antConstructor.isResourceHome(home)) {
            try {
                resources.add(antConstructor.createResource(home));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void discoverMake(List<Resource> resources) {
        File makeBin = SystemUtils.findInPath("make");
        if (makeBin != null) {
            Resource makeResource = new Resource("make");
            makeResource.addProperty(new ResourceProperty("make.bin", makeBin.getAbsolutePath(), false, false, false));
            resources.add(makeResource);
        }
    }

    private void discoverMaven(List<Resource> resources) {
        MavenResourceConstructor constructor = new MavenResourceConstructor();
        String home = System.getenv("MAVEN_HOME");
        if (constructor.isResourceHome(home)) {
            try {
                resources.add(constructor.createResource(home));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void discoverMaven2(List<Resource> resources) {
        Maven2ResourceConstructor constructor = new Maven2ResourceConstructor();
        String home = System.getenv("MAVEN2_HOME");
        if (constructor.isResourceHome(home)) {
            try {
                resources.add(constructor.createResource(home));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void discoverJava(List<Resource> resources) {
        JavaResourceConstructor javaConstructor = new JavaResourceConstructor();
        String home = System.getenv("JAVA_HOME");
        if (javaConstructor.isResourceHome(home)) {
            try {
                resources.add(javaConstructor.createResource(home));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

