/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.plugins.descriptors;

import com.zutubi.plugins.internal.ComponentDescriptorSupport;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import nu.xom.Element;

public class EventListenerComponentDescriptor
extends ComponentDescriptorSupport {
    private String listenerClassName;
    private EventManager eventManager;
    private EventListener instance;
    private ObjectFactory objectFactory;

    public void init(Element config) {
        super.init(config);
        this.setListenerClassName(config.getAttributeValue("class"));
    }

    public void setListenerClassName(String className) {
        this.listenerClassName = className;
    }

    public String getListenerClassName() {
        return this.listenerClassName;
    }

    protected synchronized EventListener getInstance() {
        if (this.instance == null) {
            try {
                Class cls = this.plugin.loadClass(this.listenerClassName, EventListenerComponentDescriptor.class);
                this.instance = (EventListener)this.objectFactory.buildBean(cls);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
        return this.instance;
    }

    public void enable() {
        super.enable();
        this.eventManager.register(this.getInstance());
    }

    public void disable() {
        super.disable();
        this.eventManager.unregister(this.getInstance());
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

